/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PersistentQueueBindingEncoding;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Test;

public class QueueBindingEncodingTest
extends Assert {
    @Test
    public void testEncodeDecode() {
        SimpleString name = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString filterString = RandomUtil.randomSimpleString();
        SimpleString user = RandomUtil.randomSimpleString();
        boolean autoCreated = RandomUtil.randomBoolean();
        int maxConsumers = RandomUtil.randomInt();
        boolean purgeOnNoConsumers = RandomUtil.randomBoolean();
        boolean exclusive = RandomUtil.randomBoolean();
        boolean groupRebalance = RandomUtil.randomBoolean();
        int groupBuckets = RandomUtil.randomInt();
        SimpleString groupFirstKey = RandomUtil.randomSimpleString();
        boolean lastValue = RandomUtil.randomBoolean();
        SimpleString lastValueKey = RandomUtil.randomSimpleString();
        boolean nonDestructive = RandomUtil.randomBoolean();
        int consumersBeforeDispatch = RandomUtil.randomInt();
        long delayBeforeDispatch = RandomUtil.randomLong();
        boolean autoDelete = RandomUtil.randomBoolean();
        long autoDeleteDelay = RandomUtil.randomLong();
        long autoDeleteMessageCount = RandomUtil.randomLong();
        byte routingType = RandomUtil.randomByte();
        boolean configurationManaged = RandomUtil.randomBoolean();
        long ringSize = RandomUtil.randomLong();
        boolean enabled = RandomUtil.randomBoolean();
        boolean groupRebalancePauseDispatch = RandomUtil.randomBoolean();
        PersistentQueueBindingEncoding encoding = new PersistentQueueBindingEncoding(name, address, filterString, user, autoCreated, maxConsumers, purgeOnNoConsumers, enabled, exclusive, groupRebalance, groupRebalancePauseDispatch, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, routingType, configurationManaged, ringSize);
        int size = encoding.getEncodeSize();
        ActiveMQBuffer encodedBuffer = ActiveMQBuffers.fixedBuffer((int)size);
        encoding.encode(encodedBuffer);
        PersistentQueueBindingEncoding decoding = new PersistentQueueBindingEncoding();
        decoding.decode(encodedBuffer);
        QueueBindingEncodingTest.assertEquals((Object)name, (Object)decoding.getQueueName());
        QueueBindingEncodingTest.assertEquals((Object)address, (Object)decoding.getAddress());
        QueueBindingEncodingTest.assertEquals((Object)filterString, (Object)decoding.getFilterString());
        QueueBindingEncodingTest.assertEquals((Object)user, (Object)decoding.getUser());
        QueueBindingEncodingTest.assertEquals((Object)autoCreated, (Object)decoding.isAutoCreated());
        QueueBindingEncodingTest.assertEquals((long)maxConsumers, (long)decoding.getMaxConsumers());
        QueueBindingEncodingTest.assertEquals((Object)purgeOnNoConsumers, (Object)decoding.isPurgeOnNoConsumers());
        QueueBindingEncodingTest.assertEquals((Object)enabled, (Object)decoding.isEnabled());
        QueueBindingEncodingTest.assertEquals((Object)exclusive, (Object)decoding.isExclusive());
        QueueBindingEncodingTest.assertEquals((Object)groupRebalance, (Object)decoding.isGroupRebalance());
        QueueBindingEncodingTest.assertEquals((long)groupBuckets, (long)decoding.getGroupBuckets());
        QueueBindingEncodingTest.assertEquals((Object)groupFirstKey, (Object)decoding.getGroupFirstKey());
        QueueBindingEncodingTest.assertEquals((Object)lastValue, (Object)decoding.isLastValue());
        QueueBindingEncodingTest.assertEquals((Object)lastValueKey, (Object)decoding.getLastValueKey());
        QueueBindingEncodingTest.assertEquals((Object)nonDestructive, (Object)decoding.isNonDestructive());
        QueueBindingEncodingTest.assertEquals((long)consumersBeforeDispatch, (long)decoding.getConsumersBeforeDispatch());
        QueueBindingEncodingTest.assertEquals((long)delayBeforeDispatch, (long)decoding.getDelayBeforeDispatch());
        QueueBindingEncodingTest.assertEquals((Object)autoDelete, (Object)decoding.isAutoDelete());
        QueueBindingEncodingTest.assertEquals((long)autoDeleteDelay, (long)decoding.getAutoDeleteDelay());
        QueueBindingEncodingTest.assertEquals((long)autoDeleteMessageCount, (long)decoding.getAutoDeleteMessageCount());
        QueueBindingEncodingTest.assertEquals((long)routingType, (long)decoding.getRoutingType());
        QueueBindingEncodingTest.assertEquals((Object)configurationManaged, (Object)decoding.isConfigurationManaged());
        QueueBindingEncodingTest.assertEquals((long)ringSize, (long)decoding.getRingSize());
        QueueBindingEncodingTest.assertEquals((Object)groupRebalancePauseDispatch, (Object)decoding.isGroupRebalancePauseDispatch());
    }
}

