/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.apache.activemq.artemis.core.remoting.impl.netty.HttpAcceptorHandler;
import org.apache.activemq.artemis.core.remoting.impl.netty.HttpKeepAliveRunnable;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class HttpAcceptorHandlerTest {
    private static final String HTTP_HANDLER = "http-handler";
    private HttpKeepAliveRunnable spy;

    @Before
    public void setUp() throws Exception {
        this.spy = (HttpKeepAliveRunnable)Mockito.spy((Object)new HttpKeepAliveRunnable());
    }

    @Test
    public void testUnregisterIsCalledTwiceWhenChannelIsInactive() {
        EmbeddedChannel channel = new EmbeddedChannel();
        HttpAcceptorHandler httpHandler = new HttpAcceptorHandler(this.spy, 1000L, (Channel)channel);
        channel.pipeline().addLast(HTTP_HANDLER, (ChannelHandler)httpHandler);
        channel.close();
        ((HttpKeepAliveRunnable)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.times((int)2))).unregisterKeepAliveHandler(httpHandler);
    }

    @Test
    public void testUnregisterIsCalledWhenHandlerIsRemovedFromPipeline() {
        EmbeddedChannel channel = new EmbeddedChannel();
        HttpAcceptorHandler httpHandler = new HttpAcceptorHandler(this.spy, 1000L, (Channel)channel);
        channel.pipeline().addLast(HTTP_HANDLER, (ChannelHandler)httpHandler);
        channel.pipeline().remove(HTTP_HANDLER);
        ((HttpKeepAliveRunnable)Mockito.verify((Object)this.spy)).unregisterKeepAliveHandler(httpHandler);
    }
}

