/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security;

import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.junit.Assert;
import org.junit.Test;

public class RoleTest
extends Assert {
    @Test
    public void testWriteRole() throws Exception {
        Role role = new Role("testWriteRole", true, false, false, false, false, false, false, false, false, false);
        Assert.assertTrue((boolean)CheckType.SEND.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CONSUME.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CREATE_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CREATE_NON_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.DELETE_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.DELETE_NON_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.MANAGE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.BROWSE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CREATE_ADDRESS.hasRole(role));
    }

    @Test
    public void testReadRole() throws Exception {
        Role role = new Role("testReadRole", false, true, false, false, false, false, false, true, false, false);
        Assert.assertFalse((boolean)CheckType.SEND.hasRole(role));
        Assert.assertTrue((boolean)CheckType.CONSUME.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CREATE_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CREATE_NON_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.DELETE_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.DELETE_NON_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.MANAGE.hasRole(role));
        Assert.assertTrue((boolean)CheckType.BROWSE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CREATE_ADDRESS.hasRole(role));
    }

    @Test
    public void testCreateRole() throws Exception {
        Role role = new Role("testCreateRole", false, false, true, false, false, false, false, false, false, false);
        Assert.assertFalse((boolean)CheckType.SEND.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CONSUME.hasRole(role));
        Assert.assertTrue((boolean)CheckType.CREATE_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CREATE_NON_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.DELETE_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.DELETE_NON_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.MANAGE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.BROWSE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CREATE_ADDRESS.hasRole(role));
    }

    @Test
    public void testManageRole() throws Exception {
        Role role = new Role("testManageRole", false, false, false, false, false, false, true, false, false, false);
        Assert.assertFalse((boolean)CheckType.SEND.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CONSUME.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CREATE_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CREATE_NON_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.DELETE_DURABLE_QUEUE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.DELETE_NON_DURABLE_QUEUE.hasRole(role));
        Assert.assertTrue((boolean)CheckType.MANAGE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.BROWSE.hasRole(role));
        Assert.assertFalse((boolean)CheckType.CREATE_ADDRESS.hasRole(role));
    }

    @Test
    public void testEqualsAndHashcode() throws Exception {
        Role role = new Role("testEquals", true, true, true, false, false, false, false, false, false, false);
        Role sameRole = new Role("testEquals", true, true, true, false, false, false, false, false, false, false);
        Role roleWithDifferentName = new Role("notEquals", true, true, true, false, false, false, false, false, false, false);
        Role roleWithDifferentRead = new Role("testEquals", false, true, true, false, false, false, false, false, false, false);
        Role roleWithDifferentWrite = new Role("testEquals", true, false, true, false, false, false, false, false, false, false);
        Role roleWithDifferentCreate = new Role("testEquals", true, true, false, false, false, false, false, false, false, false);
        Assert.assertTrue((boolean)role.equals((Object)role));
        Assert.assertTrue((boolean)role.equals((Object)sameRole));
        Assert.assertTrue((role.hashCode() == sameRole.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)role.equals((Object)roleWithDifferentName));
        Assert.assertFalse((role.hashCode() == roleWithDifferentName.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)role.equals((Object)roleWithDifferentRead));
        Assert.assertFalse((role.hashCode() == roleWithDifferentRead.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)role.equals((Object)roleWithDifferentWrite));
        Assert.assertFalse((role.hashCode() == roleWithDifferentWrite.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)role.equals((Object)roleWithDifferentCreate));
        Assert.assertFalse((role.hashCode() == roleWithDifferentCreate.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)role.equals(null));
    }
}

