/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.core.security.jaas.StubCertificateLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.JaasCallbackHandler;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CertificateLoginModuleTest
extends Assert {
    private static final String USER_NAME = "testUser";
    private static final List<String> ROLE_NAMES = new Vector<String>();
    private StubCertificateLoginModule loginModule;
    private Subject subject;

    public CertificateLoginModuleTest() {
        ROLE_NAMES.add("testRole1");
        ROLE_NAMES.add("testRole2");
        ROLE_NAMES.add("testRole3");
        ROLE_NAMES.add("testRole4");
    }

    @Before
    public void setUp() throws Exception {
        this.subject = new Subject();
    }

    private void loginWithCredentials(String userName, Set<String> rolesNames) throws LoginException {
        this.loginModule = new StubCertificateLoginModule(userName, new HashSet<String>(rolesNames));
        JaasCallbackHandler callbackHandler = new JaasCallbackHandler(null, null, null);
        this.loginModule.initialize(this.subject, (CallbackHandler)callbackHandler, null, new HashMap());
        this.loginModule.login();
        this.loginModule.commit();
    }

    private void checkPrincipalsMatch(Subject subject) {
        boolean nameFound = false;
        boolean[] rolesFound = new boolean[ROLE_NAMES.size()];
        for (int i = 0; i < rolesFound.length; ++i) {
            rolesFound[i] = false;
        }
        for (Principal currentPrincipal : subject.getPrincipals()) {
            if (currentPrincipal instanceof UserPrincipal) {
                if (currentPrincipal.getName().equals(USER_NAME)) {
                    if (!nameFound) {
                        nameFound = true;
                        continue;
                    }
                    CertificateLoginModuleTest.fail((String)"UserPrincipal found twice.");
                    continue;
                }
                CertificateLoginModuleTest.fail((String)"Unknown UserPrincipal found.");
                continue;
            }
            if (currentPrincipal instanceof RolePrincipal) {
                int principalIdx = ROLE_NAMES.indexOf(((RolePrincipal)currentPrincipal).getName());
                if (principalIdx < 0) {
                    CertificateLoginModuleTest.fail((String)"Unknown RolePrincipal found.");
                }
                if (!rolesFound[principalIdx]) {
                    rolesFound[principalIdx] = true;
                    continue;
                }
                CertificateLoginModuleTest.fail((String)"RolePrincipal found twice.");
                continue;
            }
            CertificateLoginModuleTest.fail((String)"Unknown Principal type found.");
        }
    }

    @Test
    public void testLoginSuccess() throws IOException {
        try {
            this.loginWithCredentials(USER_NAME, new HashSet<String>(ROLE_NAMES));
        }
        catch (Exception e) {
            CertificateLoginModuleTest.fail((String)("Unable to login: " + e.getMessage()));
        }
        this.checkPrincipalsMatch(this.subject);
    }

    @Test
    public void testLoginFailure() throws IOException {
        boolean loginFailed = false;
        try {
            this.loginWithCredentials(null, new HashSet<String>());
        }
        catch (LoginException e) {
            loginFailed = true;
        }
        if (!loginFailed) {
            CertificateLoginModuleTest.fail((String)"Logged in with unknown certificate.");
        }
    }

    @Test
    public void testLogOut() throws IOException {
        try {
            this.loginWithCredentials(USER_NAME, new HashSet<String>(ROLE_NAMES));
        }
        catch (Exception e) {
            CertificateLoginModuleTest.fail((String)("Unable to login: " + e.getMessage()));
        }
        this.loginModule.logout();
        CertificateLoginModuleTest.assertEquals((String)"logout should have cleared Subject principals.", (long)0L, (long)this.subject.getPrincipals().size());
    }
}

