/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.jaas;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuestLoginModuleTest
extends Assert {
    private static final Logger logger;

    @Test
    public void testLogin() throws LoginException {
        LoginContext context = new LoginContext("GuestLogin", new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                Assert.assertEquals((String)"Should have no Callbacks", (long)0L, (long)callbacks.length);
            }
        });
        context.login();
        Subject subject = context.getSubject();
        GuestLoginModuleTest.assertEquals((String)"Should have two principals", (long)2L, (long)subject.getPrincipals().size());
        GuestLoginModuleTest.assertEquals((String)"Should have one user principal", (long)1L, (long)subject.getPrincipals(UserPrincipal.class).size());
        GuestLoginModuleTest.assertTrue((String)"User principal is 'foo'", (boolean)subject.getPrincipals(UserPrincipal.class).contains(new UserPrincipal("foo")));
        GuestLoginModuleTest.assertEquals((String)"Should have one group principal", (long)1L, (long)subject.getPrincipals(RolePrincipal.class).size());
        GuestLoginModuleTest.assertTrue((String)"Role principal is 'bar'", (boolean)subject.getPrincipals(RolePrincipal.class).contains(new RolePrincipal("bar")));
        context.logout();
        GuestLoginModuleTest.assertEquals((String)"Should have zero principals", (long)0L, (long)subject.getPrincipals().size());
    }

    @Test
    public void testLoginWithDefaults() throws LoginException {
        LoginContext context = new LoginContext("GuestLoginWithDefaults", new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                Assert.assertEquals((String)"Should have no Callbacks", (long)0L, (long)callbacks.length);
            }
        });
        context.login();
        Subject subject = context.getSubject();
        GuestLoginModuleTest.assertEquals((String)"Should have two principals", (long)2L, (long)subject.getPrincipals().size());
        GuestLoginModuleTest.assertEquals((String)"Should have one user principal", (long)1L, (long)subject.getPrincipals(UserPrincipal.class).size());
        GuestLoginModuleTest.assertTrue((String)"User principal is 'guest'", (boolean)subject.getPrincipals(UserPrincipal.class).contains(new UserPrincipal("guest")));
        GuestLoginModuleTest.assertEquals((String)"Should have one group principal", (long)1L, (long)subject.getPrincipals(RolePrincipal.class).size());
        GuestLoginModuleTest.assertTrue((String)"Role principal is 'guests'", (boolean)subject.getPrincipals(RolePrincipal.class).contains(new RolePrincipal("guests")));
        context.logout();
        GuestLoginModuleTest.assertEquals((String)"Should have zero principals", (long)0L, (long)subject.getPrincipals().size());
    }

    static {
        URL resource;
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = GuestLoginModuleTest.class.getClassLoader().getResource("login.config")) != null) {
            try {
                path = URLDecoder.decode(resource.getFile(), StandardCharsets.UTF_8.name());
                System.setProperty("java.security.auth.login.config", path);
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

