/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.jaas;

import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.impl.SecurityStoreImpl;
import org.apache.activemq.artemis.core.security.jaas.PropertiesLoginModuleTest;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class JAASSecurityManagerClassLoadingTest {
    private static final Logger logger;
    @Parameterized.Parameter
    public boolean usingNewLoader;
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();

    @Parameterized.Parameters(name="newLoader=({0})")
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoginClassloading() throws Exception {
        ClassLoader existingLoader = Thread.currentThread().getContextClassLoader();
        logger.debug("loader: {}", (Object)existingLoader);
        try {
            if (this.usingNewLoader) {
                URLClassLoader simulatedLoader = new URLClassLoader(new URL[]{this.tmpDir.getRoot().toURI().toURL()}, null);
                Thread.currentThread().setContextClassLoader(simulatedLoader);
            }
            ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
            Subject result = securityManager.authenticate("first", "secret", null, null);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"first", (Object)SecurityStoreImpl.getUserFromSubject((Subject)result));
            Role role = new Role("programmers", true, true, true, true, true, true, true, true, true, true);
            HashSet<Role> roles = new HashSet<Role>();
            roles.add(role);
            boolean authorizationResult = securityManager.authorize(result, roles, CheckType.SEND, "someaddress");
            Assert.assertTrue((boolean)authorizationResult);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingLoader);
        }
    }

    static {
        URL resource;
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = PropertiesLoginModuleTest.class.getClassLoader().getResource("login.config")) != null) {
            try {
                path = URLDecoder.decode(resource.getFile(), StandardCharsets.UTF_8.name());
                System.setProperty("java.security.auth.login.config", path);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

