/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.jaas;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.activemq.artemis.core.security.jaas.NoCacheLoginModule;
import org.apache.activemq.artemis.core.security.jaas.PropertiesLoginModuleTest;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.NoCacheLoginException;
import org.junit.Assert;
import org.junit.Test;

public class JAASSecurityManagerTest {
    @Test
    public void testNoCacheLoginException() {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("testNoCacheLoginException");
        try {
            securityManager.authenticate(null, null, null, null);
            Assert.fail();
        }
        catch (NoCacheLoginException ncle) {
            Assert.assertEquals((Object)NoCacheLoginModule.MESSAGE, (Object)ncle.getMessage());
        }
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = PropertiesLoginModuleTest.class.getClassLoader().getResource("login.config")) != null) {
            try {
                path = URLDecoder.decode(resource.getFile(), StandardCharsets.UTF_8.name());
                System.setProperty("java.security.auth.login.config", path);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

