/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.jaas;

import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=1024)})
@ApplyLdifFiles(value={"test.ldif"})
public class LDAPLoginModuleMaskPasswordTest
extends AbstractLdapTestUnit {
    private final String loginConfigSysPropName = "java.security.auth.login.config";
    private String oldLoginConfig;

    @Before
    public void setLoginConfigSysProperty() {
        this.oldLoginConfig = System.getProperty("java.security.auth.login.config", null);
        System.setProperty("java.security.auth.login.config", "src/test/resources/login.config");
    }

    @After
    public void resetLoginConfigSysProperty() {
        if (this.oldLoginConfig != null) {
            System.setProperty("java.security.auth.login.config", this.oldLoginConfig);
        }
    }

    @Test
    public void testLoginMaskedPassword() throws LoginException {
        LoginContext context = new LoginContext("LDAPLoginMaskedPassword", callbacks -> {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName("first");
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword("secret".toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i]);
            }
        });
        context.login();
        context.logout();
    }

    @Test
    public void testLoginMaskedPasswordUnauthenticated() throws LoginException {
        LoginContext context = new LoginContext("LDAPLoginMaskedPassword", callbacks -> {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName("first");
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword("nosecret".toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i]);
            }
        });
        try {
            context.login();
        }
        catch (FailedLoginException le) {
            Assert.assertEquals((Object)le.getMessage(), (Object)"Password does not match for user: first");
            return;
        }
        Assert.fail((String)"Should have failed authenticating");
    }

    @Test
    public void testLoginExternalCodec() throws LoginException {
        LoginContext context = new LoginContext("LDAPLoginExternalPasswordCodec", callbacks -> {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName("first");
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword("secret".toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i]);
            }
        });
        context.login();
        context.logout();
    }

    @Test
    public void testLoginExternalCodec2() throws LoginException {
        LoginContext context = new LoginContext("LDAPLoginExternalPasswordCodec2", callbacks -> {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName("first");
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword("secret".toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i]);
            }
        });
        context.login();
        context.logout();
    }

    @Test
    public void testLoginExternalCodecUnauthenticated() throws LoginException {
        LoginContext context = new LoginContext("LDAPLoginExternalPasswordCodec", callbacks -> {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName("first");
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword("nosecret".toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i]);
            }
        });
        try {
            context.login();
        }
        catch (FailedLoginException le) {
            Assert.assertEquals((Object)le.getMessage(), (Object)"Password does not match for user: first");
            return;
        }
        Assert.fail((String)"Should have failed authenticating");
    }
}

