/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.jaas;

import java.io.File;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ServerStatus;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoader;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoginModule;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class StatusTest
extends ActiveMQTestBase {
    private String existingPath = null;

    @Before
    public void trackSystemProp() throws Exception {
        this.existingPath = System.getProperty(PropertiesLoader.LOGIN_CONFIG_SYS_PROP_NAME);
    }

    @After
    public void revertExisting() throws Exception {
        StatusTest.setOrClearLoginConfigSystemProperty(this.existingPath);
    }

    @Test
    public void testStatusOfLoginConfigSystemProperty() throws Exception {
        File parentDir = new File(this.temporaryFolder.getRoot(), "sub");
        parentDir.mkdirs();
        File fileToReferenceViaLoginSystemPropAndFromPropertiesLoginModule = new File(parentDir, "someFileInTempDir.txt");
        fileToReferenceViaLoginSystemPropAndFromPropertiesLoginModule.createNewFile();
        StatusTest.setOrClearLoginConfigSystemProperty(fileToReferenceViaLoginSystemPropAndFromPropertiesLoginModule.getAbsolutePath());
        ActiveMQServer server = this.createServer(false);
        server.getConfiguration().setConfigurationFileRefreshPeriod(1L);
        server.start();
        PropertiesLoginModule propertiesLoginModule = new PropertiesLoginModule();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("reload", "true");
        options.put("org.apache.activemq.jaas.properties.user", fileToReferenceViaLoginSystemPropAndFromPropertiesLoginModule.getName());
        options.put("org.apache.activemq.jaas.properties.role", fileToReferenceViaLoginSystemPropAndFromPropertiesLoginModule.getName());
        propertiesLoginModule.initialize(new Subject(), null, null, options);
        StatusTest.assertTrue((String)"contains", (boolean)ServerStatus.getInstance().asJson().contains(fileToReferenceViaLoginSystemPropAndFromPropertiesLoginModule.getName()));
        String UNKNOWN = "UNKNOWN";
        ServerStatus.getInstance().update("server", "{\"jaas\":{\"properties\":{\"" + fileToReferenceViaLoginSystemPropAndFromPropertiesLoginModule.getName() + "\": {\"reloadTime\":\"UNKNOWN\"}}}}");
        fileToReferenceViaLoginSystemPropAndFromPropertiesLoginModule.setLastModified(System.currentTimeMillis());
        StatusTest.assertTrue((String)"contains", (boolean)ServerStatus.getInstance().asJson().contains("UNKNOWN"));
        parentDir.setLastModified(System.currentTimeMillis());
        Wait.assertFalse(() -> ServerStatus.getInstance().asJson().contains("UNKNOWN"));
    }

    private static void setOrClearLoginConfigSystemProperty(String path) throws Exception {
        if (path != null) {
            System.setProperty(PropertiesLoader.LOGIN_CONFIG_SYS_PROP_NAME, path);
        } else {
            System.clearProperty(PropertiesLoader.LOGIN_CONFIG_SYS_PROP_NAME);
        }
    }
}

