/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.impl;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.junit.Assert;
import org.junit.Test;

public class ClusterConnectionImplMockTest
extends ActiveMQTestBase {
    @Test
    public void testRemvalOfLocalParameters() throws Exception {
        TransportConfiguration tc = new TransportConfiguration();
        tc.setFactoryClassName("mock");
        tc.getParams().put("localAddress", "localAddress");
        tc.getParams().put("localPort", "localPort");
        ArtemisExecutor executor = ArtemisExecutor.delegate((Executor)Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        ClusterConnectionImpl cci = new ClusterConnectionImpl(null, new TransportConfiguration[]{tc}, null, null, null, 0, 0L, 0L, 0L, 0.0, 0L, 0, 0, 0L, 0L, false, null, 0, 0, () -> executor, (ActiveMQServer)new MockServer(), null, null, null, 0, null, null, null, true, 0L, 0);
        Assert.assertEquals((long)1L, (long)cci.allowableConnections.size());
        Assert.assertFalse((String)"Local address can not be part of allowable connection.", (boolean)((TransportConfiguration)cci.allowableConnections.iterator().next()).getParams().containsKey("localAddress"));
        Assert.assertFalse((String)"Local port can not be part of allowable connection.", (boolean)((TransportConfiguration)cci.allowableConnections.iterator().next()).getParams().containsKey("localPort"));
    }

    static final class MockServer
    extends ActiveMQServerImpl {
        MockServer() {
        }

        public ClusterManager getClusterManager() {
            return new ClusterManager(this.getExecutorFactory(), (ActiveMQServer)this, null, null, null, null, null, false);
        }

        public ExecutorFactory getExecutorFactory() {
            return new ExecutorFactory(){

                public ArtemisExecutor getExecutor() {
                    return null;
                }
            };
        }

        public Activation getActivation() {
            return new Activation(){

                public void close(boolean permanently, boolean restarting) throws Exception {
                }

                public void run() {
                }
            };
        }
    }
}

