/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.server.files.FileMoveManager;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.HierarchicalObjectRepository;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.ThreadLeakCheckRule;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileMoveManagerTest {
    @Rule
    public TemporaryFolder temporaryFolder;
    @Rule
    public ThreadLeakCheckRule leakCheckRule = new ThreadLeakCheckRule();
    private File dataLocation;
    private FileMoveManager manager;

    @Before
    public void setUp() {
        this.dataLocation = new File(this.temporaryFolder.getRoot(), "data");
        this.dataLocation.mkdirs();
        this.manager = new FileMoveManager(this.dataLocation, 10, new String[0]);
    }

    public FileMoveManagerTest() {
        File parent = new File("./target/tmp");
        parent.mkdirs();
        this.temporaryFolder = new TemporaryFolder(parent);
    }

    @Test
    public void testBackupFiles() {
        int[] originalFiles = new int[12];
        int count = 0;
        for (int i = 0; i < 12; ++i) {
            originalFiles[count++] = i;
            File bkp = new File(this.dataLocation, "oldreplica." + i);
            bkp.mkdirs();
        }
        Assert.assertEquals((long)12L, (long)this.manager.getFolders().length);
        Assert.assertEquals((long)12L, (long)this.manager.getNumberOfFolders());
        this.assertIDs(originalFiles, this.manager.getIDlist());
    }

    @Test
    public void testMinMax() {
        File bkp;
        int i;
        int[] originalFiles = new int[12];
        int count = 0;
        for (i = 0; i < 5; ++i) {
            originalFiles[count++] = i;
            bkp = new File(this.dataLocation, "oldreplica." + i);
            bkp.mkdirs();
        }
        for (i = 7; i < 14; ++i) {
            originalFiles[count++] = i;
            bkp = new File(this.dataLocation, "oldreplica." + i);
            bkp.mkdirs();
        }
        Assert.assertEquals((long)12L, (long)this.manager.getFolders().length);
        Assert.assertEquals((long)12L, (long)this.manager.getNumberOfFolders());
        int[] ids = this.manager.getIDlist();
        this.assertIDs(originalFiles, ids);
        Assert.assertEquals((long)0L, (long)this.manager.getMinID());
        Assert.assertEquals((long)13L, (long)this.manager.getMaxID());
        this.manager.setMaxFolders(3).checkOldFolders();
        Assert.assertEquals((long)3L, (long)this.manager.getNumberOfFolders());
        Assert.assertEquals((long)13L, (long)this.manager.getMaxID());
        Assert.assertEquals((long)11L, (long)this.manager.getMinID());
    }

    @Test
    public void testGarbageCreated() {
        File garbage = new File(this.dataLocation, "bkp.zzz");
        garbage.mkdirs();
        this.testMinMax();
        this.resetTmp();
        garbage = new File(this.dataLocation, "bkp.001.old");
        garbage.mkdirs();
        this.resetTmp();
        garbage = new File(this.dataLocation, "bkp.1.5");
        garbage.mkdirs();
        this.testMinMax();
    }

    @Test
    public void testNoFolders() {
        Assert.assertEquals((long)0L, (long)this.manager.getFolders().length);
        Assert.assertEquals((long)0L, (long)this.manager.getNumberOfFolders());
        Assert.assertTrue((boolean)this.dataLocation.delete());
        Assert.assertEquals((long)0L, (long)this.manager.getFolders().length);
        Assert.assertEquals((long)0L, (long)this.manager.getNumberOfFolders());
    }

    @Test
    public void testNoFiles() throws Exception {
        this.manager.doMove();
        Assert.assertEquals((long)0L, (long)this.manager.getNumberOfFolders());
    }

    @Test
    public void testMoveFiles() throws Exception {
        this.manager.setMaxFolders(3);
        for (int bkp = 1; bkp <= 10; ++bkp) {
            String[] filesAfterMove;
            for (int i = 0; i < 100; ++i) {
                this.createFile(this.dataLocation, i);
            }
            this.manager.doMove();
            Assert.assertEquals((long)Math.min(bkp, this.manager.getMaxFolders()), (long)this.manager.getNumberOfFolders());
            File bkpFolder = this.manager.getFolder(bkp);
            FileMoveManager bkp1Manager = new FileMoveManager(bkpFolder, 10, new String[0]);
            for (String file : filesAfterMove = bkp1Manager.getFiles()) {
                this.checkFile(bkpFolder, file);
            }
        }
        Assert.assertEquals((long)this.manager.getMaxFolders(), (long)this.manager.getNumberOfFolders());
        this.manager.setMaxFolders(-1).checkOldFolders();
        Assert.assertEquals((long)3L, (long)this.manager.getNumberOfFolders());
        this.manager.setMaxFolders(1).checkOldFolders();
        Assert.assertEquals((long)1L, (long)this.manager.getNumberOfFolders());
        Assert.assertEquals((long)10L, (long)this.manager.getMaxID());
        Assert.assertEquals((long)10L, (long)this.manager.getMinID());
    }

    @Test
    public void testMoveFolders() throws Exception {
        this.manager.setMaxFolders(3);
        int NUMBER_OF_FOLDERS = 10;
        int FILES_PER_FOLDER = 10;
        for (int bkp = 1; bkp <= 10; ++bkp) {
            for (int f = 0; f < NUMBER_OF_FOLDERS; ++f) {
                File folderF = new File(this.dataLocation, "folder" + f);
                folderF.mkdirs();
                for (int i = 0; i < FILES_PER_FOLDER + f; ++i) {
                    this.createFile(folderF, i);
                }
            }
            this.manager.doMove();
            Assert.assertEquals((long)Math.min(bkp, this.manager.getMaxFolders()), (long)this.manager.getNumberOfFolders());
            File bkpFolder = this.manager.getFolder(bkp);
            for (int f = 0; f < NUMBER_OF_FOLDERS; ++f) {
                File fileTmp = new File(bkpFolder, "folder" + f);
                String[] filesOnFolder = fileTmp.list();
                Assert.assertEquals((long)(FILES_PER_FOLDER + f), (long)filesOnFolder.length);
                for (String file : filesOnFolder) {
                    this.checkFile(fileTmp, file);
                }
            }
        }
        Assert.assertEquals((long)this.manager.getMaxFolders(), (long)this.manager.getNumberOfFolders());
        this.manager.setMaxFolders(-1).checkOldFolders();
        Assert.assertEquals((long)3L, (long)this.manager.getNumberOfFolders());
        this.manager.setMaxFolders(1).checkOldFolders();
        Assert.assertEquals((long)1L, (long)this.manager.getNumberOfFolders());
        Assert.assertEquals((long)10L, (long)this.manager.getMaxID());
        Assert.assertEquals((long)10L, (long)this.manager.getMinID());
    }

    @Test
    public void testMaxZero() throws Exception {
        this.manager.setMaxFolders(0);
        int NUMBER_OF_FOLDERS = 10;
        int FILES_PER_FOLDER = 10;
        for (int bkp = 1; bkp <= 10; ++bkp) {
            for (int f = 0; f < NUMBER_OF_FOLDERS; ++f) {
                File folderF = new File(this.dataLocation, "folder" + f);
                folderF.mkdirs();
                File replicaFolder = new File(this.dataLocation, "oldreplica." + f);
                replicaFolder.mkdir();
                for (int i = 0; i < FILES_PER_FOLDER + f; ++i) {
                    this.createFile(folderF, i);
                    this.createFile(replicaFolder, i);
                }
            }
            this.manager.doMove();
            Assert.assertEquals((long)0L, (long)this.manager.getNumberOfFolders());
            Assert.assertEquals((long)0L, (long)this.manager.getFiles().length);
        }
        Assert.assertEquals((long)0L, (long)this.manager.getMaxID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveOverPaging() throws Exception {
        AssertionLoggerHandler.startCapture();
        ExecutorService threadPool = Executors.newCachedThreadPool();
        try {
            this.manager.setMaxFolders(3);
            for (int i = 1; i <= 10; ++i) {
                HierarchicalObjectRepository addressSettings = new HierarchicalObjectRepository();
                AddressSettings settings = new AddressSettings();
                settings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
                addressSettings.setDefault((Object)settings);
                NullStorageManager storageManager = new NullStorageManager();
                PagingStoreFactoryNIO storeFactory = new PagingStoreFactoryNIO((StorageManager)storageManager, this.dataLocation, 100L, null, (ExecutorFactory)new OrderedExecutorFactory((Executor)threadPool), (ExecutorFactory)new OrderedExecutorFactory((Executor)threadPool), true, null);
                PagingManagerImpl managerImpl = new PagingManagerImpl((PagingStoreFactory)storeFactory, (HierarchicalRepository)addressSettings, -1L, -1L, ActiveMQDefaultConfiguration.getDefaultManagementAddress());
                managerImpl.start();
                PagingStore store = managerImpl.getPageStore(new SimpleString("simple-test"));
                store.startPaging();
                store.stop();
                managerImpl.stop();
                this.manager.doMove();
                Assert.assertEquals((long)Math.min(i, this.manager.getMaxFolders()), (long)this.manager.getNumberOfFolders());
            }
            Assert.assertFalse((String)"The loggers are complaining about address.txt", (boolean)AssertionLoggerHandler.findText((String[])new String[]{"address.txt"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
            threadPool.shutdown();
        }
    }

    private void assertIDs(int[] originalFiles, int[] ids) {
        Assert.assertEquals((long)originalFiles.length, (long)ids.length);
        for (int i = 0; i < ids.length; ++i) {
            Assert.assertEquals((long)originalFiles[i], (long)ids[i]);
        }
    }

    private void resetTmp() {
        this.temporaryFolder.delete();
        this.temporaryFolder.getRoot().mkdirs();
        Assert.assertEquals((long)0L, (long)this.manager.getNumberOfFolders());
    }

    private void createFile(File folder, int i) throws FileNotFoundException {
        File dataFile = new File(folder, i + ".jrn");
        PrintWriter outData = new PrintWriter(new FileOutputStream(dataFile));
        outData.print(i);
        outData.close();
    }

    private void checkFile(File bkpFolder, String file) throws IOException {
        File fileRead = new File(bkpFolder, file);
        try (InputStreamReader stream = new InputStreamReader(new FileInputStream(fileRead));){
            BufferedReader reader = new BufferedReader(stream);
            String valueRead = reader.readLine();
            int id = Integer.parseInt(file.substring(0, file.indexOf(46)));
            Assert.assertEquals((String)"content of the file wasn't the expected", (long)id, (long)Integer.parseInt(valueRead));
        }
    }
}

