/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.files;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreMonitorTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ScheduledExecutorService scheduledExecutorService;
    private ExecutorService executorService;

    @Before
    public void startScheduled() {
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(5);
        this.executorService = Executors.newSingleThreadExecutor();
    }

    @After
    public void stopScheduled() {
        this.scheduledExecutorService.shutdown();
        this.scheduledExecutorService = null;
        this.executorService.shutdown();
    }

    @Test
    public void testSimpleTick() throws Exception {
        File garbageFile = new File(this.getTestDirfile(), "garbage.bin");
        FileOutputStream garbage = new FileOutputStream(garbageFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(garbage);
        PrintStream out = new PrintStream(bufferedOutputStream);
        for (int i = 0; i < 100; ++i) {
            out.println("Garbage " + i);
        }
        bufferedOutputStream.close();
        final AtomicInteger over = new AtomicInteger(0);
        final AtomicInteger under = new AtomicInteger(0);
        final AtomicInteger tick = new AtomicInteger(0);
        FileStoreMonitor.Callback callback = new FileStoreMonitor.Callback(){

            public void tick(long usableSpace, long totalSpace) {
                tick.incrementAndGet();
                logger.debug("tick:: usableSpace: {}, totalSpace:{}", (Object)usableSpace, (Object)totalSpace);
            }

            public void over(long usableSpace, long totalSpace) {
                over.incrementAndGet();
                logger.debug("over:: usableSpace: {}, totalSpace:{}", (Object)usableSpace, (Object)totalSpace);
            }

            public void under(long usableSpace, long totalSpace) {
                under.incrementAndGet();
                logger.debug("under:: usableSpace: {}, totalSpace: {}", (Object)usableSpace, (Object)totalSpace);
            }
        };
        FileStoreMonitor storeMonitor = new FileStoreMonitor(this.scheduledExecutorService, (Executor)this.executorService, 100L, TimeUnit.MILLISECONDS, 0.999, null);
        storeMonitor.addCallback(callback);
        storeMonitor.addStore(this.getTestDirfile());
        storeMonitor.tick();
        Assert.assertEquals((long)0L, (long)over.get());
        Assert.assertEquals((long)1L, (long)tick.get());
        Assert.assertEquals((long)1L, (long)under.get());
        storeMonitor.setMaxUsage(0.0);
        storeMonitor.tick();
        Assert.assertEquals((long)1L, (long)over.get());
        Assert.assertEquals((long)2L, (long)tick.get());
        Assert.assertEquals((long)1L, (long)under.get());
    }

    @Test
    public void testScheduler() throws Exception {
        FileStoreMonitor storeMonitor = new FileStoreMonitor(this.scheduledExecutorService, (Executor)this.executorService, 20L, TimeUnit.MILLISECONDS, 0.9, null);
        final ReusableLatch latch = new ReusableLatch(5);
        storeMonitor.addStore(this.getTestDirfile());
        storeMonitor.addCallback(new FileStoreMonitor.Callback(){

            public void tick(long usableSpace, long totalSpace) {
                logger.debug("Tick");
                latch.countDown();
            }

            public void over(long usableSpace, long totalSpace) {
            }

            public void under(long usableSpace, long totalSpace) {
            }
        });
        storeMonitor.start();
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        storeMonitor.stop();
        latch.setCount(1);
        Assert.assertFalse((boolean)latch.await(100L, TimeUnit.MILLISECONDS));
    }
}

