/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.lang.ref.WeakReference;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.EmbeddedServerTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.junit.Test;

public class ActiveMQServerImplTest
extends ActiveMQTestBase {
    @Test
    public void testAddingAndStartingExternalComponent() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        EmbeddedServerTest.FakeExternalComponent component = new EmbeddedServerTest.FakeExternalComponent();
        server.addExternalComponent((ActiveMQComponent)component, true);
        Assert.assertTrue((boolean)component.isStarted());
        Assert.assertThat((Object)server.getExternalComponents(), (Matcher)CoreMatchers.hasItem((Object)component));
    }

    @Test
    public void testAddingWithoutStartingExternalComponent() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        EmbeddedServerTest.FakeExternalComponent component = new EmbeddedServerTest.FakeExternalComponent();
        server.addExternalComponent((ActiveMQComponent)component, false);
        Assert.assertFalse((boolean)component.isStarted());
        Assert.assertThat((Object)server.getExternalComponents(), (Matcher)CoreMatchers.hasItem((Object)component));
    }

    @Test
    public void testCannotAddExternalComponentsIfNotStarting() throws Exception {
        ActiveMQServer server = this.createServer(false);
        EmbeddedServerTest.FakeExternalComponent component = new EmbeddedServerTest.FakeExternalComponent();
        try {
            server.addExternalComponent((ActiveMQComponent)component, false);
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertFalse((boolean)component.isStarted());
            Assert.assertThat((Object)server.getExternalComponents(), (Matcher)IsEmptyCollection.empty());
        }
    }

    @Test
    public void testCannotAddExternalComponentsIfStopped() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        server.stop();
        EmbeddedServerTest.FakeExternalComponent component = new EmbeddedServerTest.FakeExternalComponent();
        try {
            server.addExternalComponent((ActiveMQComponent)component, false);
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertFalse((boolean)component.isStarted());
            Assert.assertThat((Object)server.getExternalComponents(), (Matcher)IsEmptyCollection.empty());
        }
    }

    @Test
    public void testScheduledPoolGC() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        Runnable scheduledRunnable = new Runnable(){

            @Override
            public void run() {
                Assert.fail();
            }
        };
        WeakReference<1> scheduledRunnableRef = new WeakReference<1>(scheduledRunnable);
        ScheduledExecutorService scheduledPool = server.getScheduledPool();
        ScheduledFuture<?> scheduledFuture = scheduledPool.schedule(scheduledRunnable, 5000L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)scheduledFuture.isCancelled());
        Assert.assertTrue((boolean)scheduledFuture.cancel(true));
        Assert.assertTrue((boolean)scheduledFuture.isCancelled());
        Assert.assertNotEquals(null, scheduledRunnableRef.get());
        scheduledRunnable = null;
        ActiveMQServerImplTest.forceGC();
        Assert.assertEquals(null, scheduledRunnableRef.get());
        server.stop();
    }
}

