/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerAccessor;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerPolicy;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.apache.activemq.artemis.utils.critical.CriticalComponentImpl;
import org.junit.Assert;
import org.junit.Test;

public class ActiveMQServerStartupTest
extends ActiveMQTestBase {
    @Test
    public void testTooLongToStartHalt() throws Exception {
        this.testTooLongToStart(CriticalAnalyzerPolicy.HALT);
    }

    @Test
    public void testTooLongToStartShutdown() throws Exception {
        this.testTooLongToStart(CriticalAnalyzerPolicy.SHUTDOWN);
    }

    @Test
    public void testTooLongToStartLOG() throws Exception {
        this.testTooLongToStart(CriticalAnalyzerPolicy.LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTooLongToStart(CriticalAnalyzerPolicy policy) throws Exception {
        AssertionLoggerHandler.startCapture();
        try {
            ConfigurationImpl configuration = new ConfigurationImpl();
            configuration.setCriticalAnalyzerPolicy(policy);
            configuration.setCriticalAnalyzer(true);
            configuration.setPersistenceEnabled(false);
            ActiveMQServerImpl server = new ActiveMQServerImpl((Configuration)configuration);
            this.addServer((ActiveMQServer)server);
            server.start();
            server.setState(ActiveMQServer.SERVER_STATE.STARTING);
            CriticalAnalyzerAccessor.fireActions(server.getCriticalAnalyzer(), (CriticalComponent)new CriticalComponentImpl(server.getCriticalAnalyzer(), 2));
            Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"224116"}));
            Assert.assertEquals((Object)ActiveMQServer.SERVER_STATE.STARTING, (Object)server.getState());
            server.stop();
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }
}

