/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.config.ServerLocatorConfig;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterConnectReplyMessage;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.LiveNodeLocator;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.BackupManager;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.ClusterController;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicaPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicationBackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicationPrimaryPolicy;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumManager;
import org.apache.activemq.artemis.core.server.cluster.qourum.SharedNothingBackupQuorum;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.ReplicationBackupActivation;
import org.apache.activemq.artemis.core.server.impl.ReplicationObserver;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.quorum.DistributedPrimitiveManager;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.TopologyResponseHandler;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.ThreadDumpUtil;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class BackupActivationNoReconnectTest {
    @Test(timeout=30000L)
    public void verifyReplicationBackupActivation() throws Exception {
        ReplicationBackupPolicy policy = (ReplicationBackupPolicy)Mockito.mock(ReplicationBackupPolicy.class);
        ReplicationPrimaryPolicy replicationPrimaryPolicy = (ReplicationPrimaryPolicy)Mockito.mock(ReplicationPrimaryPolicy.class);
        Mockito.when((Object)policy.getLivePolicy()).thenReturn((Object)replicationPrimaryPolicy);
        ActiveMQServerImpl server = (ActiveMQServerImpl)Mockito.mock(ActiveMQServerImpl.class);
        DistributedPrimitiveManager distributedManager = (DistributedPrimitiveManager)Mockito.mock(DistributedPrimitiveManager.class);
        ReplicationBackupActivation replicationBackupActivation = new ReplicationBackupActivation(server, distributedManager, policy);
        this.verifySingleAttemptToLocateLive(server, (Activation)replicationBackupActivation);
    }

    @Test(timeout=30000L)
    public void verifySharedNothingBackupActivation() throws Exception {
        ActiveMQServerImpl server = (ActiveMQServerImpl)Mockito.mock(ActiveMQServerImpl.class);
        Mockito.when((Object)server.isStarted()).thenReturn((Object)true);
        ExecutorService threadPool = (ExecutorService)Mockito.mock(ExecutorService.class);
        ((ExecutorService)Mockito.doAnswer(invocation -> {
            Runnable runnable = (Runnable)invocation.getArgument(0);
            runnable.run();
            return null;
        }).when((Object)threadPool)).execute((Runnable)ArgumentMatchers.any(Runnable.class));
        Mockito.when((Object)server.getThreadPool()).thenReturn((Object)threadPool);
        HAPolicy haPolicy = (HAPolicy)Mockito.mock(HAPolicy.class);
        Mockito.when((Object)haPolicy.isBackup()).thenReturn((Object)true);
        Mockito.when((Object)server.getHAPolicy()).thenReturn((Object)haPolicy);
        Mockito.when((Object)server.getManagementService()).thenReturn((Object)((ManagementService)Mockito.mock(ManagementService.class)));
        HashMap activationParams = new HashMap();
        ReplicaPolicy replicaPolicy = new ReplicaPolicy(null, 0);
        replicaPolicy.setAllowFailback(false);
        this.verifySingleAttemptToLocateLive(server, replicaPolicy.createActivation(server, false, activationParams, null));
    }

    protected void verifySingleAttemptToLocateLive(ActiveMQServerImpl server, Activation activation) throws Exception {
        NodeManager nodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        Mockito.when((Object)server.getNodeManager()).thenReturn((Object)nodeManager);
        Mockito.when((Object)nodeManager.getNodeActivationSequence()).thenReturn((Object)0L);
        Mockito.when((Object)server.initialisePart1(Mockito.anyBoolean())).thenReturn((Object)true);
        ClusterManager clusterManager = (ClusterManager)Mockito.mock(ClusterManager.class);
        ClusterController clusterController = (ClusterController)Mockito.mock(ClusterController.class);
        Mockito.when((Object)clusterManager.getClusterController()).thenReturn((Object)clusterController);
        Mockito.when((Object)server.getClusterManager()).thenReturn((Object)clusterManager);
        QuorumManager quorumManager = (QuorumManager)Mockito.mock(QuorumManager.class);
        Mockito.when((Object)clusterManager.getQuorumManager()).thenReturn((Object)quorumManager);
        Version version = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)server.getVersion()).thenReturn((Object)version);
        BackupManager backupManager = (BackupManager)Mockito.mock(BackupManager.class);
        Mockito.when((Object)server.getBackupManager()).thenReturn((Object)backupManager);
        CountDownLatch gotLocator = new CountDownLatch(1);
        AtomicReference locatorAtomicReference = new AtomicReference();
        ((ClusterController)Mockito.doAnswer(invocation -> {
            locatorAtomicReference.set((LiveNodeLocator)invocation.getArguments()[0]);
            gotLocator.countDown();
            return null;
        }).when((Object)clusterController)).addClusterTopologyListenerForReplication((ClusterTopologyListener)Mockito.any());
        Mockito.when((Object)server.checkLiveIsNotColocated(Mockito.anyString())).thenReturn((Object)true);
        ClusterControl clusterControl = (ClusterControl)Mockito.mock(ClusterControl.class);
        Mockito.when((Object)clusterController.connectToNodeInReplicatedCluster((TransportConfiguration)Mockito.any())).thenReturn((Object)clusterControl);
        try (ServerSocket serverSocket = new ServerSocket(0);){
            ServerLocatorInternal serverLocator = (ServerLocatorInternal)Mockito.mock(ServerLocatorInternal.class);
            TransportConfiguration connectorConfig = (TransportConfiguration)Mockito.mock(TransportConfiguration.class);
            ServerLocatorConfig locatorConfig = (ServerLocatorConfig)Mockito.mock(ServerLocatorConfig.class);
            boolean reconnectAttempts = true;
            Executor threadPool = (Executor)Mockito.mock(Executor.class);
            ScheduledExecutorService scheduledThreadPool = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
            ClientProtocolManager clientProtocolManager = (ClientProtocolManager)Mockito.mock(ClientProtocolManager.class);
            Mockito.when((Object)serverLocator.newProtocolManager()).thenReturn((Object)clientProtocolManager);
            Mockito.when((Object)connectorConfig.getFactoryClassName()).thenReturn((Object)NettyConnectorFactory.class.getName());
            HashMap<String, Integer> urlParams = new HashMap<String, Integer>();
            urlParams.put("port", serverSocket.getLocalPort());
            Mockito.when((Object)connectorConfig.getCombinedParams()).thenReturn(urlParams);
            ClientSessionFactoryImpl sessionFactory = new ClientSessionFactoryImpl(serverLocator, connectorConfig, locatorConfig, 1, threadPool, scheduledThreadPool, null, null);
            Mockito.when((Object)clusterControl.getSessionFactory()).thenReturn((Object)sessionFactory);
            Mockito.when((Object)clientProtocolManager.isAlive()).thenReturn((Object)true);
            CoreRemotingConnection remotingConnection = (CoreRemotingConnection)Mockito.mock(CoreRemotingConnection.class);
            Mockito.when((Object)clientProtocolManager.connect((Connection)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (List)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (TopologyResponseHandler)ArgumentMatchers.any())).thenReturn((Object)remotingConnection);
            CountDownLatch gotReplicationObserverListener = new CountDownLatch(1);
            CountDownLatch gotListener = new CountDownLatch(1);
            AtomicReference failureListenerAtomicReference = new AtomicReference();
            ((CoreRemotingConnection)Mockito.doAnswer(invocation -> {
                FailureListener listener = (FailureListener)invocation.getArgument(0);
                if (listener instanceof ReplicationObserver || listener instanceof SharedNothingBackupQuorum) {
                    gotReplicationObserverListener.countDown();
                } else {
                    failureListenerAtomicReference.set(listener);
                    gotListener.countDown();
                }
                return null;
            }).when((Object)remotingConnection)).addFailureListener((FailureListener)ArgumentMatchers.any());
            Mockito.when((Object)remotingConnection.getID()).thenReturn((Object)"First");
            Channel channel = (Channel)Mockito.mock(Channel.class);
            ClusterConnectReplyMessage clusterConnectReplyMessage = (ClusterConnectReplyMessage)Mockito.mock(ClusterConnectReplyMessage.class);
            Mockito.when((Object)channel.sendBlocking((Packet)ArgumentMatchers.any(), ArgumentMatchers.anyByte())).thenReturn((Object)clusterConnectReplyMessage);
            Mockito.when((Object)clusterConnectReplyMessage.isAuthorized()).thenReturn((Object)true);
            ExecutorFactory executorFactory = (ExecutorFactory)Mockito.mock(ExecutorFactory.class);
            Mockito.when((Object)server.getExecutorFactory()).thenReturn((Object)executorFactory);
            ArtemisExecutor executor = (ArtemisExecutor)Mockito.mock(ArtemisExecutor.class);
            ((ArtemisExecutor)Mockito.doAnswer(invocation -> {
                Runnable runnable = (Runnable)invocation.getArgument(0);
                runnable.run();
                return null;
            }).when((Object)executor)).execute((Runnable)ArgumentMatchers.any(Runnable.class));
            Mockito.when((Object)executorFactory.getExecutor()).thenReturn((Object)executor);
            Mockito.when((Object)clusterControl.createReplicationChannel()).thenReturn((Object)channel);
            StorageManager storageManager = (StorageManager)Mockito.mock(StorageManager.class);
            Mockito.when((Object)server.getStorageManager()).thenReturn((Object)storageManager);
            Journal journal = (Journal)Mockito.mock(Journal.class);
            Mockito.when((Object)storageManager.getBindingsJournal()).thenReturn((Object)journal);
            Mockito.when((Object)storageManager.getMessageJournal()).thenReturn((Object)journal);
            Mockito.when((Object)server.createPagingManager()).thenReturn((Object)((PagingManager)Mockito.mock(PagingManager.class)));
            AtomicBoolean reconnectWorkOnRetry = new AtomicBoolean();
            ActiveMQDisconnectedException forcedError = new ActiveMQDisconnectedException("DD");
            Mockito.when((Object)clientProtocolManager.cleanupBeforeFailover((ActiveMQException)((Object)ArgumentMatchers.any()))).then(invocation -> {
                Assert.assertEquals((Object)forcedError, (Object)invocation.getArgument(0));
                reconnectWorkOnRetry.set(true);
                return true;
            });
            final CountDownLatch failure = new CountDownLatch(2);
            final AtomicBoolean failoverEventReported = new AtomicBoolean(true);
            sessionFactory.addFailureListener(new SessionFailureListener(){

                public void beforeReconnect(ActiveMQException exception) {
                    failure.countDown();
                }

                public void connectionFailed(ActiveMQException exception, boolean failedOver) {
                }

                public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
                    failure.countDown();
                    failoverEventReported.set(failedOver);
                }
            });
            Thread activationThread = new Thread((Runnable)activation);
            activationThread.start();
            Assert.assertTrue((boolean)gotLocator.await(5L, TimeUnit.SECONDS));
            ((LiveNodeLocator)locatorAtomicReference.get()).nodeUP((TopologyMember)new TopologyMemberImpl("nodeId", "backupGroupName", "", new TransportConfiguration(), new TransportConfiguration()), false);
            Socket clientSocket = serverSocket.accept();
            Assert.assertTrue((String)"Replication observer in play", (boolean)gotReplicationObserverListener.await(5L, TimeUnit.SECONDS));
            clientSocket.close();
            Assert.assertTrue((boolean)gotListener.await(5L, TimeUnit.SECONDS));
            ((FailureListener)failureListenerAtomicReference.get()).connectionFailed((ActiveMQException)forcedError, false);
            activationThread.join(10000L);
            if (activationThread.isAlive()) {
                String dump = ThreadDumpUtil.threadDump((String)"Activation thread is still alive!");
                activationThread.interrupt();
                Assert.fail((String)dump);
            }
            Assert.assertTrue((boolean)failure.await(5L, TimeUnit.SECONDS));
            Assert.assertFalse((boolean)failoverEventReported.get());
            Assert.assertFalse((boolean)reconnectWorkOnRetry.get());
        }
    }
}

