/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Collection;
import org.apache.activemq.artemis.core.server.impl.BucketMessageGroups;
import org.junit.Assert;
import org.junit.Test;

public class BucketMessageGroupsTest {
    @Test
    public void testEnsureBucketCountHonoured() {
        for (int count = 1; count < 100; ++count) {
            BucketMessageGroups messageGroups = new BucketMessageGroups(count);
            for (int i = 0; i < 100; ++i) {
                messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)i), (Object)("world" + i));
            }
            Assert.assertEquals((long)count, (long)messageGroups.size());
        }
    }

    @Test
    public void testBucketCountNotGreaterThanZero() {
        BucketMessageGroups messageGroups2;
        try {
            messageGroups2 = new BucketMessageGroups(0);
            Assert.fail((String)"IllegalArgumentException was expected as bucket count is NOT greater than 0");
        }
        catch (IllegalArgumentException messageGroups2) {
            // empty catch block
        }
        try {
            messageGroups2 = new BucketMessageGroups(-1);
            Assert.fail((String)"IllegalArgumentException was expected as bucket count is NOT greater than 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPut() {
        BucketMessageGroups messageGroups = new BucketMessageGroups(2);
        Assert.assertEquals((long)0L, (long)messageGroups.size());
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)1), (Object)"world");
        Assert.assertEquals((long)1L, (long)messageGroups.size());
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)2), (Object)"world2");
        Assert.assertEquals((long)2L, (long)messageGroups.size());
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)3), (Object)"world3");
        Assert.assertEquals((long)2L, (long)messageGroups.size());
    }

    @Test
    public void testGet() {
        BucketMessageGroups messageGroups = new BucketMessageGroups(2);
        Assert.assertNull((Object)messageGroups.get(BucketMessageGroups.toGroupBucketIntKey((int)1)));
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)1), (Object)"world");
        Assert.assertEquals((Object)"world", (Object)messageGroups.get(BucketMessageGroups.toGroupBucketIntKey((int)1)));
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)2), (Object)"world2");
        Assert.assertEquals((Object)"world2", (Object)messageGroups.get(BucketMessageGroups.toGroupBucketIntKey((int)2)));
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)3), (Object)"world3");
        Assert.assertEquals((Object)"world3", (Object)messageGroups.get(BucketMessageGroups.toGroupBucketIntKey((int)3)));
        Assert.assertEquals((Object)"world3", (Object)messageGroups.get(BucketMessageGroups.toGroupBucketIntKey((int)1)));
        Assert.assertEquals((Object)"world3", (Object)messageGroups.get(BucketMessageGroups.toGroupBucketIntKey((int)-1)));
        Assert.assertEquals((Object)"world2", (Object)messageGroups.get(BucketMessageGroups.toGroupBucketIntKey((int)-2)));
    }

    @Test
    public void testToMap() {
        BucketMessageGroups messageGroups = new BucketMessageGroups(2);
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)1), (Object)"world");
        Assert.assertEquals((long)1L, (long)messageGroups.toMap().size());
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)2), (Object)"world2");
        Assert.assertEquals((long)2L, (long)messageGroups.toMap().size());
        Collection values = messageGroups.toMap().values();
        Assert.assertTrue((boolean)values.contains("world"));
        Assert.assertTrue((boolean)values.contains("world2"));
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)3), (Object)"world3");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)4), (Object)"world4");
        values = messageGroups.toMap().values();
        Assert.assertFalse((boolean)values.contains("world"));
        Assert.assertFalse((boolean)values.contains("world2"));
        Assert.assertTrue((boolean)values.contains("world3"));
        Assert.assertTrue((boolean)values.contains("world4"));
    }

    @Test
    public void testRemove() {
        BucketMessageGroups messageGroups = new BucketMessageGroups(2);
        Assert.assertNull((Object)messageGroups.remove(BucketMessageGroups.toGroupBucketIntKey((int)1)));
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)1), (Object)"world");
        Assert.assertEquals((Object)"world", (Object)messageGroups.remove(BucketMessageGroups.toGroupBucketIntKey((int)1)));
        Assert.assertNull((Object)messageGroups.remove(BucketMessageGroups.toGroupBucketIntKey((int)1)));
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)1), (Object)"world1");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)2), (Object)"world2");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)3), (Object)"world3");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)4), (Object)"world4");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)5), (Object)"world5");
        Assert.assertEquals((long)2L, (long)messageGroups.size());
        Assert.assertEquals((Object)"world5", (Object)messageGroups.remove(BucketMessageGroups.toGroupBucketIntKey((int)3)));
        Assert.assertNull((Object)messageGroups.remove(BucketMessageGroups.toGroupBucketIntKey((int)5)));
        Assert.assertEquals((long)1L, (long)messageGroups.size());
        Assert.assertEquals((Object)"world4", (Object)messageGroups.remove(BucketMessageGroups.toGroupBucketIntKey((int)4)));
        Assert.assertEquals((long)0L, (long)messageGroups.size());
    }

    @Test
    public void testRemoveIf() {
        BucketMessageGroups messageGroups = new BucketMessageGroups(10);
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)1), (Object)"world1");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)2), (Object)"world2");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)3), (Object)"world1");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)4), (Object)"world2");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)5), (Object)"world1");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)6), (Object)"world2");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)7), (Object)"world1");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)8), (Object)"world2");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)9), (Object)"world3");
        messageGroups.put(BucketMessageGroups.toGroupBucketIntKey((int)10), (Object)"world4");
        Assert.assertEquals((long)10L, (long)messageGroups.size());
        messageGroups.removeIf("world1"::equals);
        Assert.assertEquals((long)6L, (long)messageGroups.size());
        messageGroups.removeIf("world4"::equals);
        Assert.assertEquals((long)5L, (long)messageGroups.size());
        messageGroups.removeIf("world3"::equals);
        Assert.assertEquals((long)4L, (long)messageGroups.size());
        messageGroups.removeIf("world2"::equals);
        Assert.assertEquals((long)0L, (long)messageGroups.size());
    }
}

