/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.core.PriorityAware;
import org.apache.activemq.artemis.core.server.impl.QueueConsumers;
import org.apache.activemq.artemis.core.server.impl.QueueConsumersImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueueConsumersImplTest {
    private QueueConsumers<TestPriority> queueConsumers;

    @Before
    public void setUp() {
        this.queueConsumers = new QueueConsumersImpl();
    }

    @Test
    public void addTest() {
        TestPriority testPriority = new TestPriority("hello", 0);
        Assert.assertFalse((boolean)this.queueConsumers.hasNext());
        this.queueConsumers.add((PriorityAware)testPriority);
        Assert.assertFalse((boolean)this.queueConsumers.hasNext());
        this.queueConsumers.reset();
        Assert.assertTrue((boolean)this.queueConsumers.hasNext());
        Assert.assertEquals((Object)testPriority, (Object)this.queueConsumers.next());
    }

    @Test
    public void removeTest() {
        TestPriority testPriority = new TestPriority("hello", 0);
        Assert.assertFalse((boolean)this.queueConsumers.hasNext());
        this.queueConsumers.add((PriorityAware)testPriority);
        this.queueConsumers.reset();
        Assert.assertTrue((boolean)this.queueConsumers.hasNext());
        this.queueConsumers.remove((PriorityAware)testPriority);
        this.queueConsumers.reset();
        Assert.assertFalse((boolean)this.queueConsumers.hasNext());
        Assert.assertEquals((long)0L, (long)this.queueConsumers.getPriorites().size());
        this.queueConsumers.remove((PriorityAware)testPriority);
        this.queueConsumers.remove((PriorityAware)testPriority);
    }

    @Test
    public void roundRobinTest() {
        this.queueConsumers.add((PriorityAware)new TestPriority("A", 127));
        this.queueConsumers.add((PriorityAware)new TestPriority("B", 127));
        this.queueConsumers.add((PriorityAware)new TestPriority("E", 0));
        this.queueConsumers.add((PriorityAware)new TestPriority("D", 20));
        this.queueConsumers.add((PriorityAware)new TestPriority("C", 127));
        this.queueConsumers.reset();
        Assert.assertTrue((boolean)this.queueConsumers.hasNext());
        Assert.assertEquals((Object)"A", (Object)((TestPriority)this.queueConsumers.next()).getName());
        this.queueConsumers.reset();
        Assert.assertTrue((boolean)this.queueConsumers.hasNext());
        Assert.assertEquals((Object)"B", (Object)((TestPriority)this.queueConsumers.next()).getName());
        Assert.assertTrue((boolean)this.queueConsumers.hasNext());
        Assert.assertEquals((Object)"C", (Object)((TestPriority)this.queueConsumers.next()).getName());
        Assert.assertTrue((boolean)this.queueConsumers.hasNext());
        Assert.assertEquals((Object)"A", (Object)((TestPriority)this.queueConsumers.next()).getName());
        Assert.assertTrue((boolean)this.queueConsumers.hasNext());
        Assert.assertEquals((Object)"D", (Object)((TestPriority)this.queueConsumers.next()).getName());
        Assert.assertTrue((boolean)this.queueConsumers.hasNext());
        Assert.assertEquals((Object)"E", (Object)((TestPriority)this.queueConsumers.next()).getName());
        Assert.assertFalse((boolean)this.queueConsumers.hasNext());
        this.queueConsumers.reset();
        Assert.assertTrue((boolean)this.queueConsumers.hasNext());
        Assert.assertEquals((Object)"B", (Object)((TestPriority)this.queueConsumers.next()).getName());
    }

    @Test
    public void roundRobinEqualPriorityResetTest() {
        this.queueConsumers.add((PriorityAware)new TestPriority("A", 0));
        this.queueConsumers.add((PriorityAware)new TestPriority("B", 0));
        this.queueConsumers.add((PriorityAware)new TestPriority("C", 0));
        this.queueConsumers.reset();
        Assert.assertTrue((boolean)this.queueConsumers.hasNext());
        Assert.assertEquals((Object)"A", (Object)((TestPriority)this.queueConsumers.next()).getName());
        this.queueConsumers.reset();
        Assert.assertTrue((boolean)this.queueConsumers.hasNext());
        Assert.assertEquals((Object)"B", (Object)((TestPriority)this.queueConsumers.next()).getName());
        Assert.assertTrue((boolean)this.queueConsumers.hasNext());
        Assert.assertEquals((Object)"C", (Object)((TestPriority)this.queueConsumers.next()).getName());
        Assert.assertTrue((boolean)this.queueConsumers.hasNext());
        Assert.assertEquals((Object)"A", (Object)((TestPriority)this.queueConsumers.next()).getName());
        Assert.assertFalse((boolean)this.queueConsumers.hasNext());
    }

    private class TestPriority
    implements PriorityAware {
        private final int priority;
        private final String name;

        private TestPriority(String name, int priority) {
            this.priority = priority;
            this.name = name;
        }

        public int getPriority() {
            return this.priority;
        }

        public String getName() {
            return this.name;
        }
    }
}

