/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.cursor.PageIterator;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReferenceImpl;
import org.apache.activemq.artemis.core.paging.impl.PagedMessageImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class QueueImplTest {
    @Test
    public void deleteAllPagedReferencesTest() throws Exception {
        SimpleString address = new SimpleString("test");
        AtomicInteger pageIteratorIndex = new AtomicInteger(0);
        PageIterator pageIterator = (PageIterator)Mockito.mock(PageIterator.class);
        PageSubscription pageSubscription = (PageSubscription)Mockito.mock(PageSubscription.class);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        StorageManager storageManager = (StorageManager)Mockito.mock(StorageManager.class);
        ActiveMQServer server = (ActiveMQServer)Mockito.mock(ActiveMQServer.class);
        ExecutorFactory executorFactory = (ExecutorFactory)Mockito.mock(ExecutorFactory.class);
        int flushLimit = 100;
        int pagedReferences = 500;
        Semaphore availableTransactions = new Semaphore(3);
        ((PageIterator)Mockito.doAnswer(invocationOnMock -> pageIteratorIndex.get() < 500).when((Object)pageIterator)).hasNext();
        ((PageIterator)Mockito.doAnswer(invocationOnMock -> {
            pageIteratorIndex.incrementAndGet();
            return new PagedReferenceImpl((PagedMessage)new PagedMessageImpl((Message)Mockito.mock(Message.class), new long[]{0L}), pageSubscription);
        }).when((Object)pageIterator)).next();
        ((PageSubscription)Mockito.doReturn((Object)pageIterator).when((Object)pageSubscription)).iterator();
        ((StorageManager)Mockito.doAnswer(invocationOnMock -> {
            Assert.assertTrue((String)"Too transactions locked on afterCommit.", (boolean)availableTransactions.tryAcquire(3000L, TimeUnit.MILLISECONDS));
            executorService.execute(() -> {
                ((IOCallback)invocationOnMock.getArgument(0)).done();
                availableTransactions.release();
            });
            return null;
        }).when((Object)storageManager)).afterCompleteOperations((IOCallback)Mockito.any(IOCallback.class));
        ((ActiveMQServer)Mockito.doReturn((Object)executorFactory).when((Object)server)).getExecutorFactory();
        QueueImpl queue = new QueueImpl(0L, address, address, null, null, pageSubscription, null, false, false, false, (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class), (PostOffice)Mockito.mock(PostOffice.class), storageManager, null, (ArtemisExecutor)Mockito.mock(ArtemisExecutor.class), server, (QueueFactory)Mockito.mock(QueueFactory.class));
        ((PageSubscription)Mockito.doReturn((Object)queue).when((Object)pageSubscription)).getQueue();
        Assert.assertEquals((long)500L, (long)queue.deleteAllReferences(100));
    }
}

