/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.ReferenceCounter;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.NodeStore;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.junit.Assert;
import org.junit.Test;

public class RoutingContextTest {
    @Test
    public void testValidateInternal() {
        RoutingContextImpl context = new RoutingContextImpl((Transaction)new TransactionImpl((StorageManager)new NullStorageManager()));
        Assert.assertFalse((boolean)context.isInternal());
        context.addQueue(SimpleString.toSimpleString((String)"t1"), (Queue)new FakeQueueForRoutingContextTest("t1", true, true));
        Assert.assertTrue((boolean)context.isInternal());
        context.addQueue(SimpleString.toSimpleString((String)"t2"), (Queue)new FakeQueueForRoutingContextTest("t2", false, true));
        Assert.assertFalse((boolean)context.isInternal());
        context.addQueue(SimpleString.toSimpleString((String)"t3"), (Queue)new FakeQueueForRoutingContextTest("t3", true, true));
        Assert.assertFalse((boolean)context.isInternal());
        context.clear();
        Assert.assertFalse((boolean)context.isInternal());
        context.addQueue(SimpleString.toSimpleString((String)"t1"), (Queue)new FakeQueueForRoutingContextTest("t1", true, true));
        Assert.assertTrue((boolean)context.isInternal());
        context.addQueue(SimpleString.toSimpleString((String)"t2"), (Queue)new FakeQueueForRoutingContextTest("t2", true, true));
        Assert.assertTrue((boolean)context.isInternal());
        context.addQueue(SimpleString.toSimpleString((String)"t3"), (Queue)new FakeQueueForRoutingContextTest("t3", true, true));
        Assert.assertTrue((boolean)context.isInternal());
    }

    private static class FakeQueueForRoutingContextTest
    implements Queue {
        final String name;
        final boolean isInternal;
        final boolean durable;

        FakeQueueForRoutingContextTest(String name, boolean isInternal, boolean durable) {
            this.name = name;
            this.isInternal = isInternal;
            this.durable = durable;
        }

        public CriticalAnalyzer getCriticalAnalyzer() {
            return null;
        }

        public CriticalCloseable measureCritical(int path) {
            return null;
        }

        public boolean checkExpiration(long timeout, boolean reset) {
            return false;
        }

        public void route(Message message, RoutingContext context) throws Exception {
        }

        public void routeWithAck(Message message, RoutingContext context) throws Exception {
        }

        public SimpleString getName() {
            return SimpleString.toSimpleString((String)this.name);
        }

        public Long getID() {
            return null;
        }

        public Filter getFilter() {
            return null;
        }

        public void setFilter(Filter filter) {
        }

        public PagingStore getPagingStore() {
            return null;
        }

        public PageSubscription getPageSubscription() {
            return null;
        }

        public RoutingType getRoutingType() {
            return null;
        }

        public void setRoutingType(RoutingType routingType) {
        }

        public boolean allowsReferenceCallback() {
            return false;
        }

        public boolean isDurable() {
            return this.durable;
        }

        public int durableUp(Message message) {
            return 0;
        }

        public int durableDown(Message message) {
            return 0;
        }

        public void refUp(MessageReference messageReference) {
        }

        public void refDown(MessageReference messageReference) {
        }

        public MessageReference removeWithSuppliedID(String serverID, long id, NodeStore<MessageReference> nodeStore) {
            return null;
        }

        public boolean isDurableMessage() {
            return false;
        }

        public boolean isAutoDelete() {
            return false;
        }

        public long getAutoDeleteDelay() {
            return 0L;
        }

        public long getAutoDeleteMessageCount() {
            return 0L;
        }

        public boolean isTemporary() {
            return false;
        }

        public boolean isAutoCreated() {
            return false;
        }

        public boolean isPurgeOnNoConsumers() {
            return false;
        }

        public void setPurgeOnNoConsumers(boolean value) {
        }

        public boolean isEnabled() {
            return false;
        }

        public void setEnabled(boolean value) {
        }

        public int getConsumersBeforeDispatch() {
            return 0;
        }

        public void setConsumersBeforeDispatch(int consumersBeforeDispatch) {
        }

        public long getDelayBeforeDispatch() {
            return 0L;
        }

        public void setDelayBeforeDispatch(long delayBeforeDispatch) {
        }

        public long getDispatchStartTime() {
            return 0L;
        }

        public boolean isDispatching() {
            return false;
        }

        public void setDispatching(boolean dispatching) {
        }

        public boolean isExclusive() {
            return false;
        }

        public void setExclusive(boolean value) {
        }

        public boolean isLastValue() {
            return false;
        }

        public SimpleString getLastValueKey() {
            return null;
        }

        public boolean isNonDestructive() {
            return false;
        }

        public void setNonDestructive(boolean nonDestructive) {
        }

        public int getMaxConsumers() {
            return 0;
        }

        public void setMaxConsumer(int maxConsumers) {
        }

        public int getGroupBuckets() {
            return 0;
        }

        public void setGroupBuckets(int groupBuckets) {
        }

        public boolean isGroupRebalance() {
            return false;
        }

        public void setGroupRebalance(boolean groupRebalance) {
        }

        public boolean isGroupRebalancePauseDispatch() {
            return false;
        }

        public void setGroupRebalancePauseDispatch(boolean groupRebalancePauseDisptach) {
        }

        public SimpleString getGroupFirstKey() {
            return null;
        }

        public void setGroupFirstKey(SimpleString groupFirstKey) {
        }

        public boolean isConfigurationManaged() {
            return false;
        }

        public void setConfigurationManaged(boolean configurationManaged) {
        }

        public void addConsumer(Consumer consumer) throws Exception {
        }

        public void addLingerSession(String sessionId) {
        }

        public void removeLingerSession(String sessionId) {
        }

        public void removeConsumer(Consumer consumer) {
        }

        public int getConsumerCount() {
            return 0;
        }

        public long getConsumerRemovedTimestamp() {
            return 0L;
        }

        public void setRingSize(long ringSize) {
        }

        public long getRingSize() {
            return 0L;
        }

        public ReferenceCounter getConsumersRefCount() {
            return null;
        }

        public void addSorted(List<MessageReference> refs, boolean scheduling) {
        }

        public void reload(MessageReference ref) {
        }

        public void addTail(MessageReference ref) {
        }

        public void addTail(MessageReference ref, boolean direct) {
        }

        public void addHead(MessageReference ref, boolean scheduling) {
        }

        public void addSorted(MessageReference ref, boolean scheduling) {
        }

        public void addHead(List<MessageReference> refs, boolean scheduling) {
        }

        public void acknowledge(MessageReference ref) throws Exception {
        }

        public void acknowledge(MessageReference ref, ServerConsumer consumer) throws Exception {
        }

        public void acknowledge(MessageReference ref, AckReason reason, ServerConsumer consumer) throws Exception {
        }

        public void acknowledge(Transaction tx, MessageReference ref) throws Exception {
        }

        public void acknowledge(Transaction tx, MessageReference ref, AckReason reason, ServerConsumer consumer, boolean delivering) throws Exception {
        }

        public void reacknowledge(Transaction tx, MessageReference ref) throws Exception {
        }

        public void cancel(Transaction tx, MessageReference ref) {
        }

        public void cancel(Transaction tx, MessageReference ref, boolean ignoreRedeliveryCheck) {
        }

        public void cancel(MessageReference reference, long timeBase) throws Exception {
        }

        public void deliverAsync() {
        }

        public void unproposed(SimpleString groupID) {
        }

        public void forceDelivery() {
        }

        public void deleteQueue() throws Exception {
        }

        public void deleteQueue(boolean removeConsumers) throws Exception {
        }

        public void removeAddress() throws Exception {
        }

        public void destroyPaging() throws Exception {
        }

        public long getMessageCount() {
            return 0L;
        }

        public long getPersistentSize() {
            return 0L;
        }

        public long getDurableMessageCount() {
            return 0L;
        }

        public long getDurablePersistentSize() {
            return 0L;
        }

        public int getDeliveringCount() {
            return 0;
        }

        public long getDeliveringSize() {
            return 0L;
        }

        public int getDurableDeliveringCount() {
            return 0;
        }

        public long getDurableDeliveringSize() {
            return 0L;
        }

        public void referenceHandled(MessageReference ref) {
        }

        public int getScheduledCount() {
            return 0;
        }

        public long getScheduledSize() {
            return 0L;
        }

        public int getDurableScheduledCount() {
            return 0;
        }

        public long getDurableScheduledSize() {
            return 0L;
        }

        public List<MessageReference> getScheduledMessages() {
            return null;
        }

        public Map<String, List<MessageReference>> getDeliveringMessages() {
            return null;
        }

        public long getMessagesAdded() {
            return 0L;
        }

        public long getAcknowledgeAttempts() {
            return 0L;
        }

        public long getMessagesAcknowledged() {
            return 0L;
        }

        public long getMessagesExpired() {
            return 0L;
        }

        public long getMessagesKilled() {
            return 0L;
        }

        public long getMessagesReplaced() {
            return 0L;
        }

        public MessageReference removeReferenceWithID(long id) throws Exception {
            return null;
        }

        public MessageReference getReference(long id) throws ActiveMQException {
            return null;
        }

        public int deleteAllReferences() throws Exception {
            return 0;
        }

        public int deleteAllReferences(int flushLimit) throws Exception {
            return 0;
        }

        public boolean deleteReference(long messageID) throws Exception {
            return false;
        }

        public int deleteMatchingReferences(Filter filter) throws Exception {
            return 0;
        }

        public int deleteMatchingReferences(int flushLImit, Filter filter, AckReason ackReason) throws Exception {
            return 0;
        }

        public boolean expireReference(long messageID) throws Exception {
            return false;
        }

        public int expireReferences(Filter filter) throws Exception {
            return 0;
        }

        public void expireReferences(Runnable done) {
        }

        public void expire(MessageReference ref) throws Exception {
        }

        public void expire(MessageReference ref, ServerConsumer consumer, boolean delivering) throws Exception {
        }

        public boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
            return false;
        }

        public int sendMessagesToDeadLetterAddress(Filter filter) throws Exception {
            return 0;
        }

        public boolean sendToDeadLetterAddress(Transaction tx, MessageReference ref) throws Exception {
            return false;
        }

        public boolean changeReferencePriority(long messageID, byte newPriority) throws Exception {
            return false;
        }

        public int changeReferencesPriority(Filter filter, byte newPriority) throws Exception {
            return 0;
        }

        public boolean moveReference(long messageID, SimpleString toAddress, Binding binding, boolean rejectDuplicates) throws Exception {
            return false;
        }

        public int moveReferences(Filter filter, SimpleString toAddress, Binding binding) throws Exception {
            return 0;
        }

        public int moveReferences(int flushLimit, Filter filter, SimpleString toAddress, boolean rejectDuplicates, Binding binding) throws Exception {
            return 0;
        }

        public int moveReferences(int flushLimit, Filter filter, SimpleString toAddress, boolean rejectDuplicates, int messageCount, Binding binding) throws Exception {
            return 0;
        }

        public int retryMessages(Filter filter) throws Exception {
            return 0;
        }

        public void addRedistributor(long delay) {
        }

        public void cancelRedistributor() {
        }

        public boolean hasMatchingConsumer(Message message) {
            return false;
        }

        public Collection<Consumer> getConsumers() {
            return null;
        }

        public Map<SimpleString, Consumer> getGroups() {
            return null;
        }

        public void resetGroup(SimpleString groupID) {
        }

        public void resetAllGroups() {
        }

        public int getGroupCount() {
            return 0;
        }

        public Pair<Boolean, Boolean> checkRedelivery(MessageReference ref, long timeBase, boolean ignoreRedeliveryDelay) throws Exception {
            return null;
        }

        public LinkedListIterator<MessageReference> iterator() {
            return null;
        }

        public LinkedListIterator<MessageReference> browserIterator() {
            return null;
        }

        public SimpleString getExpiryAddress() {
            return null;
        }

        public SimpleString getDeadLetterAddress() {
            return null;
        }

        public void pause() {
        }

        public void pause(boolean persist) {
        }

        public void reloadPause(long recordID) {
        }

        public void resume() {
        }

        public boolean isPaused() {
            return false;
        }

        public boolean isPersistedPause() {
            return false;
        }

        public Executor getExecutor() {
            return null;
        }

        public void resetAllIterators() {
        }

        public boolean flushExecutor() {
            return false;
        }

        public void close() throws Exception {
        }

        public boolean isDirectDeliver() {
            return false;
        }

        public SimpleString getAddress() {
            return SimpleString.toSimpleString((String)this.name);
        }

        public boolean isInternalQueue() {
            return this.isInternal;
        }

        public void setInternalQueue(boolean internalQueue) {
        }

        public void resetMessagesAdded() {
        }

        public void resetMessagesAcknowledged() {
        }

        public void resetMessagesExpired() {
        }

        public void resetMessagesKilled() {
        }

        public void incrementMesssagesAdded() {
        }

        public void deliverScheduledMessages() throws ActiveMQException {
        }

        public void deliverScheduledMessages(String filter) throws ActiveMQException {
        }

        public void deliverScheduledMessage(long messageId) throws ActiveMQException {
        }

        public void postAcknowledge(MessageReference ref, AckReason reason) {
        }

        public void postAcknowledge(MessageReference ref, AckReason reason, boolean delivering) {
        }

        public SimpleString getUser() {
            return null;
        }

        public void setUser(SimpleString user) {
        }

        public void recheckRefCount(OperationContext context) {
        }
    }
}

