/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.MessageReferenceImpl;
import org.apache.activemq.artemis.core.server.impl.ScheduledDeliveryHandlerImpl;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.ReferenceCounter;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.NodeStore;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalComponentImpl;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledDeliveryHandlerTest
extends Assert {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testScheduleRandom() throws Exception {
        ScheduledDeliveryHandlerImpl handler = new ScheduledDeliveryHandlerImpl(null, (Queue)new FakeQueueForScheduleUnitTest(0));
        long nextMessage = 0L;
        long NUMBER_OF_SEQUENCES = 100000L;
        int i = 0;
        while ((long)i < NUMBER_OF_SEQUENCES) {
            int numberOfMessages = RandomUtil.randomInt() % 10;
            if (numberOfMessages == 0) {
                numberOfMessages = 1;
            }
            long nextScheduledTime = RandomUtil.randomPositiveLong();
            for (int j = 0; j < numberOfMessages; ++j) {
                boolean tail = RandomUtil.randomBoolean();
                this.addMessage(handler, nextMessage++, nextScheduledTime, tail);
            }
            ++i;
        }
        this.debugList(true, handler, nextMessage);
    }

    @Test
    public void testScheduleSameTimeHeadAndTail() throws Exception {
        int i;
        ScheduledDeliveryHandlerImpl handler = new ScheduledDeliveryHandlerImpl(null, (Queue)new FakeQueueForScheduleUnitTest(0));
        long time = System.currentTimeMillis() + 10000L;
        for (i = 10001; i < 20000; ++i) {
            this.addMessage(handler, i, time, true);
        }
        this.addMessage(handler, 10000L, time, false);
        time = System.currentTimeMillis() + 5000L;
        for (i = 1; i < 10000; ++i) {
            this.addMessage(handler, i, time, true);
        }
        this.addMessage(handler, 0L, time, false);
        this.debugList(true, handler, 20000L);
        this.validateSequence(handler);
    }

    @Test
    public void testScheduleFixedSample() throws Exception {
        ScheduledDeliveryHandlerImpl handler = new ScheduledDeliveryHandlerImpl(null, (Queue)new FakeQueueForScheduleUnitTest(0));
        this.addMessage(handler, 0L, 48L, true);
        this.addMessage(handler, 1L, 75L, true);
        this.addMessage(handler, 2L, 56L, true);
        this.addMessage(handler, 3L, 7L, false);
        this.addMessage(handler, 4L, 69L, true);
        this.debugList(true, handler, 5L);
    }

    @Test
    public void testScheduleWithAddHeads() throws Exception {
        ScheduledDeliveryHandlerImpl handler = new ScheduledDeliveryHandlerImpl(null, (Queue)new FakeQueueForScheduleUnitTest(0));
        this.addMessage(handler, 0L, 1L, true);
        this.addMessage(handler, 1L, 2L, true);
        this.addMessage(handler, 2L, 3L, true);
        this.addMessage(handler, 3L, 3L, true);
        this.addMessage(handler, 4L, 4L, true);
        this.addMessage(handler, 10L, 5L, false);
        this.addMessage(handler, 9L, 5L, false);
        this.addMessage(handler, 8L, 5L, false);
        this.addMessage(handler, 7L, 5L, false);
        this.addMessage(handler, 6L, 5L, false);
        this.addMessage(handler, 5L, 5L, false);
        this.validateSequence(handler);
    }

    @Test
    public void testScheduleFixedSampleTailAndHead() throws Exception {
        ScheduledDeliveryHandlerImpl handler = new ScheduledDeliveryHandlerImpl(null, (Queue)new FakeQueueForScheduleUnitTest(0));
        this.addMessage(handler, 1L, 48L, true);
        this.addMessage(handler, 2L, 48L, true);
        this.addMessage(handler, 3L, 48L, true);
        this.addMessage(handler, 4L, 48L, true);
        this.addMessage(handler, 5L, 48L, true);
        this.addMessage(handler, 0L, 48L, false);
        this.addMessage(handler, 13L, 59L, true);
        this.addMessage(handler, 14L, 59L, true);
        this.addMessage(handler, 15L, 59L, true);
        this.addMessage(handler, 16L, 59L, true);
        this.addMessage(handler, 17L, 59L, true);
        this.addMessage(handler, 12L, 59L, false);
        this.addMessage(handler, 7L, 49L, true);
        this.addMessage(handler, 8L, 49L, true);
        this.addMessage(handler, 9L, 49L, true);
        this.addMessage(handler, 10L, 49L, true);
        this.addMessage(handler, 11L, 49L, true);
        this.addMessage(handler, 6L, 49L, false);
        this.validateSequence(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScheduleNow() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(50, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        try {
            for (int i = 0; i < 100; ++i) {
                this.internalSchedule(executor, scheduler);
            }
        }
        finally {
            scheduler.shutdownNow();
            executor.shutdownNow();
        }
    }

    private void internalSchedule(ExecutorService executor, ScheduledThreadPoolExecutor scheduler) throws Exception {
        int NUMBER_OF_MESSAGES = 200;
        int NUMBER_OF_THREADS = 20;
        final FakeQueueForScheduleUnitTest fakeQueue = new FakeQueueForScheduleUnitTest(200 * NUMBER_OF_THREADS);
        final ScheduledDeliveryHandlerImpl handler = new ScheduledDeliveryHandlerImpl((ScheduledExecutorService)scheduler, (Queue)fakeQueue);
        final long now = System.currentTimeMillis();
        final CountDownLatch latchDone = new CountDownLatch(NUMBER_OF_THREADS);
        final AtomicInteger error = new AtomicInteger(0);
        for (int i = 0; i < NUMBER_OF_THREADS; ++i) {
            class ProducerThread
            implements Runnable {
                ProducerThread() {
                }

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 200; ++i) {
                            ScheduledDeliveryHandlerTest.this.checkAndSchedule(handler, i, now, false, fakeQueue);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        error.incrementAndGet();
                    }
                    finally {
                        latchDone.countDown();
                    }
                }
            }
            executor.execute(new ProducerThread());
        }
        ScheduledDeliveryHandlerTest.assertTrue((boolean)latchDone.await(1L, TimeUnit.MINUTES));
        ScheduledDeliveryHandlerTest.assertEquals((long)0L, (long)error.get());
        if (!fakeQueue.waitCompletion(2L, TimeUnit.SECONDS)) {
            ScheduledDeliveryHandlerTest.fail((String)("Couldn't complete queue.add, expected 200, still missing " + fakeQueue.expectedElements.toString()));
        }
    }

    private void validateSequence(ScheduledDeliveryHandlerImpl handler) throws Exception {
        long lastSequence = -1L;
        for (MessageReference ref : handler.getScheduledReferences()) {
            ScheduledDeliveryHandlerTest.assertEquals((long)(lastSequence + 1L), (long)ref.getMessage().getMessageID());
            lastSequence = ref.getMessage().getMessageID();
        }
    }

    private void addMessage(ScheduledDeliveryHandlerImpl handler, long nextMessageID, long nextScheduledTime, boolean tail) {
        MessageReferenceImpl refImpl = new MessageReferenceImpl((Message)new FakeMessage(nextMessageID), null);
        refImpl.setScheduledDeliveryTime(nextScheduledTime);
        handler.addInPlace(nextScheduledTime, (MessageReference)refImpl, tail);
    }

    private void checkAndSchedule(ScheduledDeliveryHandlerImpl handler, long nextMessageID, long nextScheduledTime, boolean tail, Queue queue) {
        MessageReferenceImpl refImpl = new MessageReferenceImpl((Message)new FakeMessage(nextMessageID), queue);
        refImpl.setScheduledDeliveryTime(nextScheduledTime);
        handler.checkAndSchedule((MessageReference)refImpl, tail);
    }

    private void debugList(boolean fail, ScheduledDeliveryHandlerImpl handler, long numberOfExpectedMessages) throws Exception {
        List refs = handler.getScheduledReferences();
        HashSet<Long> messages = new HashSet<Long>();
        long lastTime = -1L;
        for (MessageReference ref : refs) {
            ScheduledDeliveryHandlerTest.assertFalse((boolean)messages.contains(ref.getMessage().getMessageID()));
            messages.add(ref.getMessage().getMessageID());
            if (fail) {
                ScheduledDeliveryHandlerTest.assertTrue((ref.getScheduledDeliveryTime() >= lastTime ? 1 : 0) != 0);
            } else if (ref.getScheduledDeliveryTime() < lastTime) {
                logger.debug("^^^fail at {}", (Object)ref.getScheduledDeliveryTime());
            }
            lastTime = ref.getScheduledDeliveryTime();
        }
        for (long i = 0L; i < numberOfExpectedMessages; ++i) {
            ScheduledDeliveryHandlerTest.assertTrue((boolean)messages.contains(i));
        }
    }

    public class FakeQueueForScheduleUnitTest
    extends CriticalComponentImpl
    implements Queue {
        final CountDownLatch expectedElements;
        LinkedList<MessageReference> messages;

        public void setPurgeOnNoConsumers(boolean value) {
        }

        public boolean isEnabled() {
            return false;
        }

        public void setEnabled(boolean value) {
        }

        public PagingStore getPagingStore() {
            return null;
        }

        public int durableUp(Message message) {
            return 1;
        }

        public int durableDown(Message message) {
            return 1;
        }

        public void refUp(MessageReference messageReference) {
        }

        public MessageReference removeWithSuppliedID(String serverID, long id, NodeStore<MessageReference> nodeStore) {
            return null;
        }

        public void expireReferences(Runnable done) {
        }

        public void refDown(MessageReference messageReference) {
        }

        public void removeAddress() throws Exception {
        }

        public long getAcknowledgeAttempts() {
            return 0L;
        }

        public boolean allowsReferenceCallback() {
            return false;
        }

        public int getConsumersBeforeDispatch() {
            return 0;
        }

        public void setConsumersBeforeDispatch(int consumersBeforeDispatch) {
        }

        public long getDelayBeforeDispatch() {
            return 0L;
        }

        public void setDelayBeforeDispatch(long delayBeforeDispatch) {
        }

        public long getDispatchStartTime() {
            return 0L;
        }

        public boolean isDispatching() {
            return false;
        }

        public void setDispatching(boolean dispatching) {
        }

        public void setMaxConsumer(int maxConsumers) {
        }

        public int getGroupBuckets() {
            return 0;
        }

        public void setGroupBuckets(int groupBuckets) {
        }

        public boolean isGroupRebalance() {
            return false;
        }

        public void setGroupRebalance(boolean groupRebalance) {
        }

        public boolean isGroupRebalancePauseDispatch() {
            return false;
        }

        public void setGroupRebalancePauseDispatch(boolean groupRebalancePauseDisptach) {
        }

        public SimpleString getGroupFirstKey() {
            return null;
        }

        public void setGroupFirstKey(SimpleString groupFirstKey) {
        }

        public boolean isConfigurationManaged() {
            return false;
        }

        public void setConfigurationManaged(boolean configurationManaged) {
        }

        public void recheckRefCount(OperationContext context) {
        }

        public void unproposed(SimpleString groupID) {
        }

        public FakeQueueForScheduleUnitTest(int expectedElements) {
            super((CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), 1);
            this.messages = new LinkedList();
            this.expectedElements = new CountDownLatch(expectedElements);
        }

        public boolean isPersistedPause() {
            return false;
        }

        public boolean waitCompletion(long timeout, TimeUnit timeUnit) throws Exception {
            return this.expectedElements.await(timeout, timeUnit);
        }

        public SimpleString getName() {
            return null;
        }

        public Long getID() {
            return 0L;
        }

        public void pause(boolean persist) {
        }

        public void reloadPause(long recordID) {
        }

        public Filter getFilter() {
            return null;
        }

        public void setFilter(Filter filter) {
        }

        public PageSubscription getPageSubscription() {
            return null;
        }

        public RoutingType getRoutingType() {
            return null;
        }

        public void setRoutingType(RoutingType routingType) {
        }

        public boolean isDurable() {
            return false;
        }

        public boolean isDurableMessage() {
            return false;
        }

        public boolean isAutoDelete() {
            return false;
        }

        public long getAutoDeleteDelay() {
            return -1L;
        }

        public long getAutoDeleteMessageCount() {
            return -1L;
        }

        public boolean isTemporary() {
            return false;
        }

        public boolean isAutoCreated() {
            return false;
        }

        public boolean isPurgeOnNoConsumers() {
            return false;
        }

        public int getMaxConsumers() {
            return -1;
        }

        public void addConsumer(Consumer consumer) throws Exception {
        }

        public void addLingerSession(String sessionId) {
        }

        public void removeLingerSession(String sessionId) {
        }

        public void removeConsumer(Consumer consumer) {
        }

        public int retryMessages(Filter filter) throws Exception {
            return 0;
        }

        public int getConsumerCount() {
            return 0;
        }

        public long getConsumerRemovedTimestamp() {
            return 0L;
        }

        public void setRingSize(long ringSize) {
        }

        public long getRingSize() {
            return 0L;
        }

        public ReferenceCounter getConsumersRefCount() {
            return null;
        }

        public void addSorted(List<MessageReference> refs, boolean scheduling) {
            this.addHead(refs, scheduling);
        }

        public void reload(MessageReference ref) {
        }

        public void addTail(MessageReference ref) {
        }

        public void addTail(MessageReference ref, boolean direct) {
        }

        public void addHead(MessageReference ref, boolean scheduling) {
        }

        public void addSorted(MessageReference ref, boolean scheduling) {
        }

        public void addHead(List<MessageReference> refs, boolean scheduling) {
            for (MessageReference ref : refs) {
                this.addFirst(ref);
            }
        }

        private void addFirst(MessageReference ref) {
            this.expectedElements.countDown();
            this.messages.addFirst(ref);
        }

        public void acknowledge(MessageReference ref) throws Exception {
        }

        public void acknowledge(MessageReference ref, ServerConsumer consumer) throws Exception {
        }

        public void acknowledge(MessageReference ref, AckReason reason, ServerConsumer consumer) throws Exception {
        }

        public void acknowledge(Transaction tx, MessageReference ref) throws Exception {
        }

        public void acknowledge(Transaction tx, MessageReference ref, AckReason reason, ServerConsumer consumer, boolean delivering) throws Exception {
        }

        public void reacknowledge(Transaction tx, MessageReference ref) throws Exception {
        }

        public void cancel(Transaction tx, MessageReference ref) {
        }

        public void cancel(Transaction tx, MessageReference ref, boolean ignoreRedeliveryCheck) {
        }

        public void cancel(MessageReference reference, long timeBase) throws Exception {
        }

        public void deliverAsync() {
        }

        public void forceDelivery() {
        }

        public void deleteQueue() throws Exception {
        }

        public void deleteQueue(boolean removeConsumers) throws Exception {
        }

        public void destroyPaging() throws Exception {
        }

        public long getMessageCount() {
            return 0L;
        }

        public long getPersistentSize() {
            return 0L;
        }

        public long getDurableMessageCount() {
            return 0L;
        }

        public long getDurablePersistentSize() {
            return 0L;
        }

        public int getDeliveringCount() {
            return 0;
        }

        public long getDeliveringSize() {
            return 0L;
        }

        public int getDurableDeliveringCount() {
            return 0;
        }

        public long getDurableDeliveringSize() {
            return 0L;
        }

        public int getDurableScheduledCount() {
            return 0;
        }

        public long getDurableScheduledSize() {
            return 0L;
        }

        public void referenceHandled(MessageReference ref) {
        }

        public int getScheduledCount() {
            return 0;
        }

        public long getScheduledSize() {
            return 0L;
        }

        public List<MessageReference> getScheduledMessages() {
            return null;
        }

        public Map<String, List<MessageReference>> getDeliveringMessages() {
            return null;
        }

        public long getMessagesAdded() {
            return 0L;
        }

        public long getMessagesAcknowledged() {
            return 0L;
        }

        public long getMessagesExpired() {
            return 0L;
        }

        public long getMessagesKilled() {
            return 0L;
        }

        public long getMessagesReplaced() {
            return 0L;
        }

        public MessageReference removeReferenceWithID(long id) throws Exception {
            return null;
        }

        public MessageReference getReference(long id) {
            return null;
        }

        public int deleteAllReferences() throws Exception {
            return 0;
        }

        public int deleteAllReferences(int flushLimit) throws Exception {
            return 0;
        }

        public boolean deleteReference(long messageID) throws Exception {
            return false;
        }

        public int deleteMatchingReferences(Filter filter) throws Exception {
            return 0;
        }

        public int deleteMatchingReferences(int flushLImit, Filter filter, AckReason reason) throws Exception {
            return 0;
        }

        public boolean expireReference(long messageID) throws Exception {
            return false;
        }

        public int expireReferences(Filter filter) throws Exception {
            return 0;
        }

        public void expireReferences() {
        }

        public void expire(MessageReference ref) throws Exception {
        }

        public void expire(MessageReference ref, ServerConsumer consumer, boolean delivering) throws Exception {
        }

        public boolean sendToDeadLetterAddress(Transaction tx, MessageReference ref) throws Exception {
            return false;
        }

        public boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
            return false;
        }

        public int sendMessagesToDeadLetterAddress(Filter filter) throws Exception {
            return 0;
        }

        public boolean changeReferencePriority(long messageID, byte newPriority) throws Exception {
            return false;
        }

        public int changeReferencesPriority(Filter filter, byte newPriority) throws Exception {
            return 0;
        }

        public boolean moveReference(long messageID, SimpleString toAddress, Binding binding, boolean rejectDuplicates) throws Exception {
            return false;
        }

        public int moveReferences(Filter filter, SimpleString toAddress, Binding binding) throws Exception {
            return 0;
        }

        public int moveReferences(int flushLimit, Filter filter, SimpleString toAddress, boolean rejectDuplicates, Binding binding) throws Exception {
            return 0;
        }

        public int moveReferences(int flushLimit, Filter filter, SimpleString toAddress, boolean rejectDuplicates, int messageCount, Binding binding) throws Exception {
            return 0;
        }

        public void addRedistributor(long delay) {
        }

        public void cancelRedistributor() {
        }

        public boolean hasMatchingConsumer(Message message) {
            return false;
        }

        public Collection<Consumer> getConsumers() {
            return null;
        }

        public Map<SimpleString, Consumer> getGroups() {
            return null;
        }

        public void resetGroup(SimpleString groupID) {
        }

        public void resetAllGroups() {
        }

        public int getGroupCount() {
            return 0;
        }

        public Pair<Boolean, Boolean> checkRedelivery(MessageReference ref, long timeBase, boolean ignoreRedeliveryDelay) throws Exception {
            return new Pair((Object)false, (Object)false);
        }

        public LinkedListIterator<MessageReference> iterator() {
            return null;
        }

        public LinkedListIterator<MessageReference> browserIterator() {
            return null;
        }

        public SimpleString getExpiryAddress() {
            return null;
        }

        public SimpleString getDeadLetterAddress() {
            return null;
        }

        public void pause() {
        }

        public void resume() {
        }

        public boolean isPaused() {
            return false;
        }

        public Executor getExecutor() {
            return null;
        }

        public void resetAllIterators() {
        }

        public boolean flushExecutor() {
            return false;
        }

        public void close() throws Exception {
        }

        public boolean isDirectDeliver() {
            return false;
        }

        public SimpleString getAddress() {
            return null;
        }

        public boolean isInternalQueue() {
            return false;
        }

        public void setInternalQueue(boolean internalQueue) {
        }

        public void resetMessagesAdded() {
        }

        public void resetMessagesAcknowledged() {
        }

        public void resetMessagesExpired() {
        }

        public void resetMessagesKilled() {
        }

        public void incrementMesssagesAdded() {
        }

        public void deliverScheduledMessages() {
        }

        public void deliverScheduledMessages(String filter) throws ActiveMQException {
        }

        public void deliverScheduledMessage(long messageId) throws ActiveMQException {
        }

        public void route(Message message, RoutingContext context) throws Exception {
        }

        public void routeWithAck(Message message, RoutingContext context) {
        }

        public void postAcknowledge(MessageReference ref, AckReason reason, boolean delivering) {
        }

        public void postAcknowledge(MessageReference ref, AckReason reason) {
        }

        public SimpleString getUser() {
            return null;
        }

        public void setUser(SimpleString user) {
        }

        public boolean isLastValue() {
            return false;
        }

        public SimpleString getLastValueKey() {
            return null;
        }

        public boolean isNonDestructive() {
            return false;
        }

        public void setNonDestructive(boolean nonDestructive) {
        }

        public boolean isExclusive() {
            return false;
        }

        public void setExclusive(boolean exclusive) {
        }
    }

    class FakeMessage
    implements Message {
        final long id;

        public Object getUserContext(Object key) {
            return null;
        }

        public void setUserContext(Object key, Object value) {
        }

        public String getProtocolName() {
            return this.getClass().getName();
        }

        public SimpleString getReplyTo() {
            return null;
        }

        public Message setReplyTo(SimpleString address) {
            return null;
        }

        public Object removeAnnotation(SimpleString key) {
            return null;
        }

        public Object getAnnotation(SimpleString key) {
            return null;
        }

        public void persist(ActiveMQBuffer targetRecord) {
        }

        public int getDurableCount() {
            return 0;
        }

        public Long getScheduledDeliveryTime() {
            return null;
        }

        public void reloadPersistence(ActiveMQBuffer record, CoreMessageObjectPools pools) {
        }

        public Persister<Message> getPersister() {
            return null;
        }

        public int getPersistSize() {
            return 0;
        }

        public CoreMessage toCore() {
            return this.toCore(null);
        }

        public CoreMessage toCore(CoreMessageObjectPools coreMessageObjectPools) {
            return null;
        }

        FakeMessage(long id) {
            this.id = id;
        }

        public FakeMessage setMessageID(long id) {
            return this;
        }

        public long getMessageID() {
            return this.id;
        }

        public int durableUp() {
            return 0;
        }

        public int durableDown() {
            return 0;
        }

        public Message copy(long newID) {
            return null;
        }

        public Message copy() {
            return null;
        }

        public int getMemoryEstimate() {
            return 0;
        }

        public int getRefCount() {
            return 0;
        }

        public byte[] getDuplicateIDBytes() {
            return new byte[0];
        }

        public Object getDuplicateProperty() {
            return null;
        }

        public void messageChanged() {
        }

        public UUID getUserID() {
            return null;
        }

        public String getAddress() {
            return null;
        }

        public SimpleString getAddressSimpleString() {
            return null;
        }

        public Message setAddress(String address) {
            return null;
        }

        public Message setAddress(SimpleString address) {
            return null;
        }

        public boolean isDurable() {
            return false;
        }

        public FakeMessage setDurable(boolean durable) {
            return this;
        }

        public long getExpiration() {
            return 0L;
        }

        public boolean isExpired() {
            return false;
        }

        public FakeMessage setExpiration(long expiration) {
            return this;
        }

        public long getTimestamp() {
            return 0L;
        }

        public FakeMessage setTimestamp(long timestamp) {
            return this;
        }

        public byte getPriority() {
            return 0;
        }

        public FakeMessage setPriority(byte priority) {
            return this;
        }

        public int getEncodeSize() {
            return 0;
        }

        public boolean isLargeMessage() {
            return false;
        }

        public Message putBooleanProperty(SimpleString key, boolean value) {
            return null;
        }

        public Message putBooleanProperty(String key, boolean value) {
            return null;
        }

        public Message putByteProperty(SimpleString key, byte value) {
            return null;
        }

        public Message putByteProperty(String key, byte value) {
            return null;
        }

        public Message putBytesProperty(SimpleString key, byte[] value) {
            return null;
        }

        public Message putBytesProperty(String key, byte[] value) {
            return null;
        }

        public Message putShortProperty(SimpleString key, short value) {
            return null;
        }

        public Message putShortProperty(String key, short value) {
            return null;
        }

        public Message putCharProperty(SimpleString key, char value) {
            return null;
        }

        public Message putCharProperty(String key, char value) {
            return null;
        }

        public Message putIntProperty(SimpleString key, int value) {
            return null;
        }

        public Message putIntProperty(String key, int value) {
            return null;
        }

        public Message putLongProperty(SimpleString key, long value) {
            return null;
        }

        public Message putLongProperty(String key, long value) {
            return null;
        }

        public Message putFloatProperty(SimpleString key, float value) {
            return null;
        }

        public Message putFloatProperty(String key, float value) {
            return null;
        }

        public Message putDoubleProperty(SimpleString key, double value) {
            return null;
        }

        public Message putDoubleProperty(String key, double value) {
            return null;
        }

        public Message putStringProperty(SimpleString key, SimpleString value) {
            return null;
        }

        public Message putStringProperty(SimpleString key, String value) {
            return null;
        }

        public Message putStringProperty(String key, String value) {
            return null;
        }

        public Message putObjectProperty(SimpleString key, Object value) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Message putObjectProperty(String key, Object value) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Object removeProperty(SimpleString key) {
            return null;
        }

        public Object removeProperty(String key) {
            return null;
        }

        public boolean containsProperty(SimpleString key) {
            return false;
        }

        public boolean containsProperty(String key) {
            return false;
        }

        public Boolean getBooleanProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Boolean getBooleanProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Byte getByteProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Byte getByteProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Double getDoubleProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Double getDoubleProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Integer getIntProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Integer getIntProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Long getLongProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Long getLongProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Object getObjectProperty(SimpleString key) {
            return null;
        }

        public Object getObjectProperty(String key) {
            return null;
        }

        public Short getShortProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Short getShortProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Float getFloatProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Float getFloatProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public String getStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public String getStringProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public SimpleString getSimpleStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public SimpleString getSimpleStringProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public byte[] getBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return new byte[0];
        }

        public byte[] getBytesProperty(String key) throws ActiveMQPropertyConversionException {
            return new byte[0];
        }

        public Set<SimpleString> getPropertyNames() {
            return null;
        }

        public Map<String, Object> toMap() {
            return null;
        }

        public Map<String, Object> toPropertyMap() {
            return null;
        }

        public Message setUserID(Object userID) {
            return null;
        }

        public void receiveBuffer(ByteBuf buffer) {
        }

        public int getUsage() {
            return 0;
        }

        public int usageUp() {
            return 0;
        }

        public int usageDown() {
            return 0;
        }

        public int refUp() {
            return 0;
        }

        public int refDown() {
            return 0;
        }

        public void sendBuffer(ByteBuf buffer, int count) {
        }

        public long getPersistentSize() throws ActiveMQException {
            return 0L;
        }

        public Object getOwner() {
            return null;
        }

        public void setOwner(Object object) {
        }
    }
}

