/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcLeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcSharedStateManager;
import org.apache.activemq.artemis.core.server.impl.jdbc.LeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.ScheduledLeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.TestJDBCDriver;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JdbcLeaseLockTest
extends ActiveMQTestBase {
    private JdbcSharedStateManager jdbcSharedStateManager;
    private DatabaseStorageConfiguration dbConf;
    private SQLProvider sqlProvider;
    @Parameterized.Parameter(value=0)
    public boolean withExistingTable;

    @Parameterized.Parameters(name="create_tables_prior_test={0}")
    public static List<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    private LeaseLock lock() {
        return this.lock(this.dbConf.getJdbcLockExpirationMillis());
    }

    private LeaseLock lock(long acquireMillis) {
        try {
            return JdbcSharedStateManager.createLiveLock((String)UUID.randomUUID().toString(), (JDBCConnectionProvider)this.jdbcSharedStateManager.getJdbcConnectionProvider(), (SQLProvider)this.sqlProvider, (long)acquireMillis, (long)this.dbConf.getJdbcAllowedTimeDiff());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private LeaseLock lock(long acquireMillis, long queryTimeoutMillis) {
        try {
            return JdbcSharedStateManager.createLiveLock((String)UUID.randomUUID().toString(), (JDBCConnectionProvider)this.jdbcSharedStateManager.getJdbcConnectionProvider(), (SQLProvider)this.sqlProvider, (long)acquireMillis, (long)queryTimeoutMillis, (long)this.dbConf.getJdbcAllowedTimeDiff());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private LeaseLock lock(long acquireMillis, long queryTimeoutMillis, long allowedTimeDiff) {
        try {
            return JdbcSharedStateManager.createLiveLock((String)UUID.randomUUID().toString(), (JDBCConnectionProvider)this.jdbcSharedStateManager.getJdbcConnectionProvider(), (SQLProvider)this.sqlProvider, (long)acquireMillis, (long)queryTimeoutMillis, (long)allowedTimeDiff);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Before
    public void createLockTable() throws Exception {
        this.dbConf = this.createDefaultDatabaseStorageConfiguration();
        this.sqlProvider = JDBCUtils.getSQLProvider((String)this.dbConf.getJdbcDriverClassName(), (String)this.dbConf.getNodeManagerStoreTableName(), (SQLProvider.DatabaseStoreType)SQLProvider.DatabaseStoreType.NODE_MANAGER);
        if (this.withExistingTable) {
            TestJDBCDriver testDriver = TestJDBCDriver.usingDbConf(this.dbConf, this.sqlProvider);
            testDriver.start();
            testDriver.stop();
        }
        this.jdbcSharedStateManager = JdbcSharedStateManager.usingConnectionProvider((String)UUID.randomUUID().toString(), (long)this.dbConf.getJdbcLockExpirationMillis(), (long)this.dbConf.getJdbcAllowedTimeDiff(), (JDBCConnectionProvider)this.dbConf.getConnectionProvider(), (SQLProvider)this.sqlProvider);
    }

    @After
    public void dropLockTable() throws Exception {
        this.jdbcSharedStateManager.destroy();
        this.jdbcSharedStateManager.close();
    }

    @Test
    public void shouldAcquireLock() {
        LeaseLock lock = this.lock();
        boolean acquired = lock.tryAcquire();
        Assert.assertTrue((String)"Must acquire the lock!", (boolean)acquired);
        try {
            Assert.assertTrue((String)"The lock is been held by the caller!", (boolean)lock.isHeldByCaller());
        }
        finally {
            lock.release();
        }
    }

    @Test
    public void shouldNotAcquireLockWhenAlreadyHeldByOthers() {
        LeaseLock lock = this.lock();
        Assert.assertTrue((String)"Must acquire the lock", (boolean)lock.tryAcquire());
        try {
            Assert.assertTrue((String)"Lock held by the caller", (boolean)lock.isHeldByCaller());
            LeaseLock failingLock = this.lock();
            Assert.assertFalse((String)"lock already held by other", (boolean)failingLock.tryAcquire());
            Assert.assertFalse((String)"lock already held by other", (boolean)failingLock.isHeldByCaller());
            Assert.assertTrue((String)"lock already held by other", (boolean)failingLock.isHeld());
        }
        finally {
            lock.release();
        }
    }

    @Test
    public void shouldNotAcquireLockTwice() {
        LeaseLock lock = this.lock();
        Assert.assertTrue((String)"Must acquire the lock", (boolean)lock.tryAcquire());
        try {
            Assert.assertFalse((String)"lock already acquired", (boolean)lock.tryAcquire());
        }
        finally {
            lock.release();
        }
    }

    @Test
    public void shouldNotCorruptGuardedState() throws InterruptedException {
        AtomicLong sharedState = new AtomicLong(0L);
        int producers = 2;
        int writesPerProducer = 10;
        long idleMillis = 1000L;
        long millisToAcquireLock = 10000L;
        LeaseLock.Pauser pauser = LeaseLock.Pauser.sleep((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        CountDownLatch finished = new CountDownLatch(2);
        LeaseLock[] locks = new LeaseLock[2];
        AtomicInteger lockIndex = new AtomicInteger(0);
        Runnable producerTask = () -> {
            LeaseLock lock = locks[lockIndex.getAndIncrement()];
            try {
                for (int i = 0; i < 10; ++i) {
                    LeaseLock.AcquireResult acquireResult = lock.tryAcquire(10000L, pauser, () -> true);
                    if (acquireResult != LeaseLock.AcquireResult.Done) {
                        throw new IllegalStateException(acquireResult + " from " + Thread.currentThread());
                    }
                    sharedState.lazySet(sharedState.get() + 1L);
                    lock.release();
                }
            }
            finally {
                finished.countDown();
            }
        };
        Thread[] producerThreads = new Thread[2];
        for (int i = 0; i < 2; ++i) {
            locks[i] = this.lock();
            producerThreads[i] = new Thread(producerTask);
        }
        Stream.of(producerThreads).forEach(Thread::start);
        long maxTestTime = 200000L;
        Assert.assertTrue((String)"Each producers must complete the writes", (boolean)finished.await(200000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((String)"locks hasn't mutual excluded producers", (long)20L, (long)sharedState.get());
    }

    @Test
    public void shouldAcquireExpiredLock() throws InterruptedException {
        LeaseLock lock = this.lock(10L);
        Assert.assertTrue((String)"lock is not owned by anyone", (boolean)lock.tryAcquire());
        try {
            Thread.sleep(lock.expirationMillis() * 2L);
            Assert.assertFalse((String)"lock is already expired", (boolean)lock.isHeldByCaller());
            Assert.assertFalse((String)"lock is already expired", (boolean)lock.isHeld());
            Assert.assertTrue((String)"lock is already expired", (boolean)lock.tryAcquire());
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldOtherAcquireExpiredLock() throws InterruptedException {
        LeaseLock lock = this.lock(10L);
        Assert.assertTrue((String)"lock is not owned by anyone", (boolean)lock.tryAcquire());
        try {
            Thread.sleep(lock.expirationMillis() * 2L);
            Assert.assertFalse((String)"lock is already expired", (boolean)lock.isHeldByCaller());
            Assert.assertFalse((String)"lock is already expired", (boolean)lock.isHeld());
            LeaseLock otherLock = this.lock(10L);
            try {
                Assert.assertTrue((String)"lock is already expired", (boolean)otherLock.tryAcquire());
            }
            finally {
                otherLock.release();
            }
        }
        finally {
            lock.release();
        }
    }

    @Test
    public void shouldRenewAcquiredLock() throws InterruptedException {
        LeaseLock lock = this.lock(TimeUnit.SECONDS.toMillis(10L));
        Assert.assertTrue((String)"lock is not owned by anyone", (boolean)lock.tryAcquire());
        try {
            Assert.assertTrue((String)"lock is owned", (boolean)lock.renew());
        }
        finally {
            lock.release();
        }
    }

    @Test
    public void shouldNotRenewReleasedLock() throws InterruptedException {
        LeaseLock lock = this.lock(TimeUnit.SECONDS.toMillis(10L));
        Assert.assertTrue((String)"lock is not owned by anyone", (boolean)lock.tryAcquire());
        lock.release();
        Assert.assertFalse((String)"lock is already released", (boolean)lock.isHeldByCaller());
        Assert.assertFalse((String)"lock is already released", (boolean)lock.isHeld());
        Assert.assertFalse((String)"lock is already released", (boolean)lock.renew());
    }

    @Test
    public void shouldRenewExpiredLockNotAcquiredByOthers() throws InterruptedException {
        LeaseLock lock = this.lock(500L);
        Assert.assertTrue((String)"lock is not owned by anyone", (boolean)lock.tryAcquire());
        try {
            Thread.sleep(lock.expirationMillis() * 2L);
            Assert.assertFalse((String)"lock is already expired", (boolean)lock.isHeldByCaller());
            Assert.assertFalse((String)"lock is already expired", (boolean)lock.isHeld());
            Assert.assertTrue((String)"lock is owned", (boolean)lock.renew());
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotRenewLockAcquiredByOthers() throws InterruptedException {
        LeaseLock lock = this.lock(10L);
        Assert.assertTrue((String)"lock is not owned by anyone", (boolean)lock.tryAcquire());
        try {
            Thread.sleep(lock.expirationMillis() * 2L);
            Assert.assertFalse((String)"lock is already expired", (boolean)lock.isHeldByCaller());
            Assert.assertFalse((String)"lock is already expired", (boolean)lock.isHeld());
            LeaseLock otherLock = this.lock(TimeUnit.SECONDS.toMillis(10L));
            Assert.assertTrue((String)"lock is already expired", (boolean)otherLock.tryAcquire());
            try {
                Assert.assertFalse((String)"lock is owned by others", (boolean)lock.renew());
            }
            finally {
                otherLock.release();
            }
        }
        finally {
            lock.release();
        }
    }

    @Test
    public void shouldNotNotifyLostLock() throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        OrderedExecutorFactory factory = new OrderedExecutorFactory((Executor)executorService);
        ArtemisExecutor artemisExecutor = factory.getExecutor();
        AtomicLong lostLock = new AtomicLong();
        NodeManager.LockListener lockListener = () -> lostLock.incrementAndGet();
        ScheduledLeaseLock scheduledLeaseLock = ScheduledLeaseLock.of((ScheduledExecutorService)scheduledExecutorService, (ArtemisExecutor)artemisExecutor, (String)"test", (LeaseLock)this.lock(), (long)this.dbConf.getJdbcLockRenewPeriodMillis(), (NodeManager.LockListener)lockListener);
        Assert.assertTrue((boolean)scheduledLeaseLock.lock().tryAcquire());
        scheduledLeaseLock.start();
        Assert.assertEquals((long)0L, (long)lostLock.get());
        scheduledLeaseLock.stop();
        Assert.assertEquals((long)0L, (long)lostLock.get());
        executorService.shutdown();
        scheduledExecutorService.shutdown();
        scheduledLeaseLock.lock().release();
    }

    @Test
    public void shouldNotifyManyTimesLostLock() throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        OrderedExecutorFactory factory = new OrderedExecutorFactory((Executor)executorService);
        ArtemisExecutor artemisExecutor = factory.getExecutor();
        AtomicLong lostLock = new AtomicLong();
        NodeManager.LockListener lockListener = () -> lostLock.incrementAndGet();
        ScheduledLeaseLock scheduledLeaseLock = ScheduledLeaseLock.of((ScheduledExecutorService)scheduledExecutorService, (ArtemisExecutor)artemisExecutor, (String)"test", (LeaseLock)this.lock(TimeUnit.SECONDS.toMillis(1L)), (long)100L, (NodeManager.LockListener)lockListener);
        Assert.assertTrue((boolean)scheduledLeaseLock.lock().tryAcquire());
        scheduledLeaseLock.start();
        TimeUnit.MILLISECONDS.sleep(2L * scheduledLeaseLock.renewPeriodMillis());
        Assert.assertTrue((boolean)scheduledLeaseLock.lock().isHeldByCaller());
        Assert.assertEquals((long)0L, (long)lostLock.get());
        scheduledLeaseLock.lock().release();
        Assert.assertFalse((boolean)scheduledLeaseLock.lock().isHeldByCaller());
        TimeUnit.MILLISECONDS.sleep(3L * scheduledLeaseLock.renewPeriodMillis());
        MatcherAssert.assertThat((Object)lostLock.get(), (Matcher)Is.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(2L))));
        scheduledLeaseLock.stop();
        executorService.shutdown();
        scheduledExecutorService.shutdown();
    }

    @Test
    public void shouldJdbcAndSystemTimeToBeAligned() throws InterruptedException {
        LeaseLock lock = this.lock(TimeUnit.SECONDS.toMillis(10L), TimeUnit.SECONDS.toMillis(10L));
        Assume.assumeThat((Object)lock, (Matcher)IsInstanceOf.instanceOf(JdbcLeaseLock.class));
        JdbcLeaseLock jdbcLock = (JdbcLeaseLock)JdbcLeaseLock.class.cast(lock);
        long utcSystemTime = System.currentTimeMillis();
        TimeUnit.SECONDS.sleep(1L);
        long utcJdbcTime = jdbcLock.dbCurrentTimeMillis();
        long millisDiffJdbcSystem = utcJdbcTime - utcSystemTime;
        MatcherAssert.assertThat((Object)millisDiffJdbcSystem, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)millisDiffJdbcSystem, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(TimeUnit.SECONDS.toMillis(10L))));
    }

    @Test
    public void shouldNotifyOnceLostLockIfStopped() throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        OrderedExecutorFactory factory = new OrderedExecutorFactory((Executor)executorService);
        ArtemisExecutor artemisExecutor = factory.getExecutor();
        AtomicLong lostLock = new AtomicLong();
        AtomicReference<ScheduledLeaseLock> lock = new AtomicReference<ScheduledLeaseLock>();
        AtomicReference<Object> stopErrors = new AtomicReference<Object>();
        NodeManager.LockListener lockListener = () -> {
            lostLock.incrementAndGet();
            try {
                ((ScheduledLeaseLock)lock.get()).stop();
            }
            catch (Throwable e) {
                stopErrors.set(e);
            }
        };
        ScheduledLeaseLock scheduledLeaseLock = ScheduledLeaseLock.of((ScheduledExecutorService)scheduledExecutorService, (ArtemisExecutor)artemisExecutor, (String)"test", (LeaseLock)this.lock(TimeUnit.SECONDS.toMillis(1L)), (long)100L, (NodeManager.LockListener)lockListener);
        lock.set(scheduledLeaseLock);
        Assert.assertTrue((boolean)scheduledLeaseLock.lock().tryAcquire());
        lostLock.set(0L);
        scheduledLeaseLock.start();
        Assert.assertTrue((boolean)scheduledLeaseLock.lock().isHeldByCaller());
        scheduledLeaseLock.lock().release();
        Assert.assertFalse((boolean)scheduledLeaseLock.lock().isHeldByCaller());
        Wait.assertTrue(() -> lostLock.get() > 0L);
        Assert.assertFalse((boolean)scheduledLeaseLock.isStarted());
        TimeUnit.MILLISECONDS.sleep(scheduledLeaseLock.renewPeriodMillis());
        Assert.assertEquals((long)1L, (long)lostLock.getAndSet(0L));
        Assert.assertNull(stopErrors.getAndSet(null));
        scheduledLeaseLock.stop();
        executorService.shutdown();
        scheduledExecutorService.shutdown();
    }

    @Test
    public void validateTimeDiffsOnLeaseLock() {
        AssertionLoggerHandler.startCapture();
        this.runAfter(AssertionLoggerHandler::stopCapture);
        final AtomicInteger diff = new AtomicInteger(0);
        JdbcLeaseLock hackLock = new JdbcLeaseLock("SomeID", this.jdbcSharedStateManager.getJdbcConnectionProvider(), this.sqlProvider.tryAcquireLiveLockSQL(), this.sqlProvider.tryReleaseLiveLockSQL(), this.sqlProvider.renewLiveLockSQL(), this.sqlProvider.isLiveLockedSQL(), this.sqlProvider.currentTimestampSQL(), this.sqlProvider.currentTimestampTimeZoneId(), -1L, 1000L, "LIVE", 1000L){

            protected long fetchDatabaseTime(Connection connection) throws SQLException {
                return System.currentTimeMillis() + (long)diff.get();
            }
        };
        diff.set(10000);
        hackLock.dbCurrentTimeMillis();
        Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224118"}));
        diff.set(-10000);
        AssertionLoggerHandler.clear();
        hackLock.dbCurrentTimeMillis();
        Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224118"}));
        diff.set(0);
        AssertionLoggerHandler.clear();
        hackLock.dbCurrentTimeMillis();
        Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224118"}));
    }
}

