/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcNodeManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class JdbcNodeManagerTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Parameterized.Parameter
    public boolean useAuthentication;
    private DatabaseStorageConfiguration dbConf;
    private ScheduledExecutorService leaseLockExecutor;

    @Parameterized.Parameters(name="authentication = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({false}, {true});
    }

    @Before
    public void configure() {
        if (this.useAuthentication) {
            System.setProperty("derby.connection.requireAuthentication", "true");
            System.setProperty("derby.user." + this.getJDBCUser(), this.getJDBCPassword());
        }
        this.dbConf = this.createDefaultDatabaseStorageConfiguration();
        this.dbConf.setJdbcUser(this.getJDBCUser());
        this.dbConf.setJdbcPassword(this.getJDBCPassword());
        this.leaseLockExecutor = Executors.newSingleThreadScheduledExecutor();
        this.runAfter(this.leaseLockExecutor::shutdownNow);
    }

    @Override
    protected String getJDBCUser() {
        if (this.useAuthentication) {
            return System.getProperty("jdbc.user", "testuser");
        }
        return null;
    }

    @Override
    protected String getJDBCPassword() {
        if (this.useAuthentication) {
            return System.getProperty("jdbc.password", "testpassword");
        }
        return null;
    }

    @Test
    public void shouldStartAndStopGracefullyTest() throws Exception {
        JdbcNodeManager nodeManager = JdbcNodeManager.with((DatabaseStorageConfiguration)this.dbConf, (ScheduledExecutorService)this.leaseLockExecutor, null);
        nodeManager.start();
        nodeManager.stop();
    }
}

