/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.jdbc.store.drivers.AbstractJDBCDriver;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.junit.Assert;

public class TestJDBCDriver
extends AbstractJDBCDriver {
    private boolean initialize;

    public static TestJDBCDriver usingDbConf(DatabaseStorageConfiguration dbConf, SQLProvider provider) {
        return TestJDBCDriver.usingDbConf(dbConf, provider, false);
    }

    public static TestJDBCDriver usingDbConf(DatabaseStorageConfiguration dbConf, SQLProvider provider, boolean initialize) {
        TestJDBCDriver driver = new TestJDBCDriver(initialize);
        driver.setSqlProvider(provider);
        driver.setJdbcConnectionProvider(dbConf.getConnectionProvider());
        return driver;
    }

    private TestJDBCDriver(boolean initialize) {
        this.initialize = initialize;
    }

    protected void prepareStatements() {
    }

    protected void createSchema() {
        try (Connection connection = this.getJdbcConnectionProvider().getConnection();){
            connection.createStatement().execute(this.sqlProvider.createNodeManagerStoreTableSQL());
            if (this.initialize) {
                connection.createStatement().execute(this.sqlProvider.createNodeIdSQL());
                connection.createStatement().execute(this.sqlProvider.createStateSQL());
                connection.createStatement().execute(this.sqlProvider.createLiveLockSQL());
                connection.createStatement().execute(this.sqlProvider.createBackupLockSQL());
            }
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

