/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.journal;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.junit.Assert;
import org.junit.Test;

public class JournalStorageManagerConstantTest {
    ExecutorFactory dumbExecutor = new ExecutorFactory(){

        public ArtemisExecutor getExecutor() {
            return new ArtemisExecutor(){

                public void execute(Runnable command) {
                    command.run();
                }
            };
        }
    };
    ScheduledExecutorService dumbScheduler = new ScheduledExecutorService(){

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return null;
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return null;
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return null;
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return null;
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return null;
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return null;
        }

        @Override
        public Future<?> submit(Runnable task) {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        @Override
        public void execute(Runnable command) {
        }
    };

    @Test
    public void testConstant() {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setJournalType(JournalType.NIO);
        configuration.setJournalPoolFiles(11);
        configuration.setJournalCompactMinFiles(22);
        configuration.setJournalCompactPercentage(33);
        JournalStorageManager journalStorageManager = new JournalStorageManager((Configuration)configuration, null, this.dumbExecutor, this.dumbScheduler, this.dumbExecutor);
        JournalImpl journal = (JournalImpl)journalStorageManager.getBindingsJournal();
        this.assertJournalConstants(journal);
        journal = (JournalImpl)journalStorageManager.getMessageJournal();
        this.assertJournalConstants(journal);
    }

    private void assertJournalConstants(JournalImpl journal) {
        Assert.assertEquals((Object)"0.33", (Object)("" + journal.getCompactPercentage()));
        Assert.assertEquals((long)22L, (long)journal.getCompactMinFiles());
        Assert.assertEquals((long)11L, (long)journal.getFilesRepository().getPoolSize());
    }
}

