/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.artemis.core.server.management.JMXAccessControlList;
import org.junit.Assert;
import org.junit.Test;

public class JMXAccessControlListTest {
    @Test
    public void testBasicDomain() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToAllowList("org.myDomain", null);
        controlList.addToAllowList("org.myDomain.foo", null);
        Assert.assertTrue((boolean)controlList.isInAllowList(new ObjectName("org.myDomain:*")));
        Assert.assertTrue((boolean)controlList.isInAllowList(new ObjectName("org.myDomain.foo:*")));
        Assert.assertFalse((boolean)controlList.isInAllowList(new ObjectName("org.myDomain.bar:*")));
    }

    @Test
    public void testBasicDomainWithProperty() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToAllowList("org.myDomain", "type=foo");
        controlList.addToAllowList("org.myDomain.foo", "type=bar");
        Assert.assertFalse((boolean)controlList.isInAllowList(new ObjectName("org.myDomain:*")));
        Assert.assertFalse((boolean)controlList.isInAllowList(new ObjectName("org.myDomain.foo:*")));
        Assert.assertFalse((boolean)controlList.isInAllowList(new ObjectName("org.myDomain.bar:*")));
        Assert.assertFalse((boolean)controlList.isInAllowList(new ObjectName("org.myDomain:subType=foo")));
        Assert.assertTrue((boolean)controlList.isInAllowList(new ObjectName("org.myDomain:type=foo")));
        Assert.assertTrue((boolean)controlList.isInAllowList(new ObjectName("org.myDomain:subType=bar,type=foo")));
    }

    @Test
    public void testBasicDomainWithWildCardProperty() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToAllowList("org.myDomain", "type=*");
        Assert.assertFalse((boolean)controlList.isInAllowList(new ObjectName("org.myDomain:*")));
        Assert.assertFalse((boolean)controlList.isInAllowList(new ObjectName("org.myDomain.foo:*")));
        Assert.assertFalse((boolean)controlList.isInAllowList(new ObjectName("org.myDomain.bar:*")));
        Assert.assertTrue((boolean)controlList.isInAllowList(new ObjectName("org.myDomain:type=foo")));
    }

    @Test
    public void testWildcardDomain() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToAllowList("*", null);
        Assert.assertTrue((boolean)controlList.isInAllowList(new ObjectName("org.myDomain:*")));
        Assert.assertTrue((boolean)controlList.isInAllowList(new ObjectName("org.myDomain.foo:*")));
    }

    @Test
    public void testWildcardDomainWithProperty() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToAllowList("*", "type=foo");
        controlList.addToAllowList("org.myDomain.foo", "type=bar");
        Assert.assertFalse((boolean)controlList.isInAllowList(new ObjectName("org.myDomain:*")));
        Assert.assertFalse((boolean)controlList.isInAllowList(new ObjectName("org.myDomain.foo:*")));
        Assert.assertTrue((boolean)controlList.isInAllowList(new ObjectName("org.myDomain.foo:type=bar")));
        Assert.assertFalse((boolean)controlList.isInAllowList(new ObjectName("org.myDomain.foo:type=foo")));
        Assert.assertFalse((boolean)controlList.isInAllowList(new ObjectName("org.myDomain.bar:*")));
        Assert.assertFalse((boolean)controlList.isInAllowList(new ObjectName("org.myDomain:subType=foo")));
        Assert.assertTrue((boolean)controlList.isInAllowList(new ObjectName("org.myDomain:type=foo")));
        Assert.assertTrue((boolean)controlList.isInAllowList(new ObjectName("org.myDomain:subType=bar,type=foo")));
    }

    @Test
    public void testBasicRole() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToRoleAccess("org.myDomain", null, "listSomething", new String[]{"admin"});
        List roles = controlList.getRolesForObject(new ObjectName("org.myDomain:*"), "listSomething");
        Assert.assertArrayEquals((Object[])roles.toArray(), (Object[])new String[]{"admin"});
    }

    @Test
    public void testBasicRoleWithKey() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToRoleAccess("org.myDomain", "type=foo", "listSomething", new String[]{"admin"});
        controlList.addToRoleAccess("org.myDomain", null, "listSomething", new String[]{"view"});
        List roles = controlList.getRolesForObject(new ObjectName("org.myDomain:type=foo"), "listSomething");
        Assert.assertArrayEquals((Object[])roles.toArray(), (Object[])new String[]{"admin"});
    }

    @Test
    public void testBasicRoleWithKeyContainingQuotes() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToRoleAccess("org.myDomain", "type=foo", "listSomething", new String[]{"admin"});
        controlList.addToRoleAccess("org.myDomain", null, "listSomething", new String[]{"view"});
        List roles = controlList.getRolesForObject(new ObjectName("org.myDomain:type=\"foo\""), "listSomething");
        Assert.assertArrayEquals((Object[])roles.toArray(), (Object[])new String[]{"admin"});
    }

    @Test
    public void testBasicRoleWithWildcardKey() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToRoleAccess("org.myDomain", "type=*", "listSomething", new String[]{"admin"});
        controlList.addToRoleAccess("org.myDomain", null, "listSomething", new String[]{"view"});
        List roles = controlList.getRolesForObject(new ObjectName("org.myDomain:type=foo"), "listSomething");
        Assert.assertArrayEquals((Object[])roles.toArray(), (Object[])new String[]{"admin"});
    }

    @Test
    public void testBasicRoleWithWildcardInKey() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToRoleAccess("org.myDomain", "type=foo*", "listSomething", new String[]{"update"});
        controlList.addToRoleAccess("org.myDomain", "type=bar*", "listSomething", new String[]{"browse"});
        controlList.addToRoleAccess("org.myDomain", "type=foo.bar*", "listSomething", new String[]{"admin"});
        controlList.addToRoleAccess("org.myDomain", null, "listSomething", new String[]{"view"});
        Assert.assertArrayEquals((Object[])controlList.getRolesForObject(new ObjectName("org.myDomain:type=foo.bar.test"), "listSomething").toArray(), (Object[])new String[]{"admin"});
        Assert.assertArrayEquals((Object[])controlList.getRolesForObject(new ObjectName("org.myDomain:type=bar.test"), "listSomething").toArray(), (Object[])new String[]{"browse"});
    }

    @Test
    public void testMutipleBasicRoles() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToRoleAccess("org.myDomain", null, "listSomething", new String[]{"admin", "view", "update"});
        List roles = controlList.getRolesForObject(new ObjectName("org.myDomain:*"), "listSomething");
        Assert.assertArrayEquals((Object[])roles.toArray(), (Object[])new String[]{"admin", "view", "update"});
    }

    @Test
    public void testBasicRoleWithPrefix() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToRoleAccess("org.myDomain", null, "list*", new String[]{"admin"});
        List roles = controlList.getRolesForObject(new ObjectName("org.myDomain:*"), "listSomething");
        Assert.assertArrayEquals((Object[])roles.toArray(), (Object[])new String[]{"admin"});
    }

    @Test
    public void testBasicRoleWithBoth() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToRoleAccess("org.myDomain", null, "listSomething", new String[]{"admin"});
        controlList.addToRoleAccess("org.myDomain", null, "list*", new String[]{"view"});
        List roles = controlList.getRolesForObject(new ObjectName("org.myDomain:*"), "listSomething");
        Assert.assertArrayEquals((Object[])roles.toArray(), (Object[])new String[]{"admin"});
        roles = controlList.getRolesForObject(new ObjectName("org.myDomain:*"), "listSomethingMore");
        Assert.assertArrayEquals((Object[])roles.toArray(), (Object[])new String[]{"view"});
    }

    @Test
    public void testBasicRoleWithDefaultsPrefix() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToDefaultAccess("setSomething", new String[]{"admin"});
        controlList.addToRoleAccess("org.myDomain", null, "list*", new String[]{"view"});
        List roles = controlList.getRolesForObject(new ObjectName("org.myDomain.foo:*"), "setSomething");
        Assert.assertArrayEquals((Object[])roles.toArray(), (Object[])new String[]{"admin"});
    }

    @Test
    public void testBasicRoleWithDefaultsWildcardPrefix() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToDefaultAccess("setSomething", new String[]{"admin"});
        controlList.addToDefaultAccess("set*", new String[]{"admin"});
        controlList.addToRoleAccess("org.myDomain", null, "list*", new String[]{"view"});
        List roles = controlList.getRolesForObject(new ObjectName("org.myDomain.foo:*"), "setSomethingMore");
        Assert.assertArrayEquals((Object[])roles.toArray(), (Object[])new String[]{"admin"});
    }

    @Test
    public void testBasicRoleWithDefaultscatchAllPrefix() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToDefaultAccess("setSomething", new String[]{"admin"});
        controlList.addToDefaultAccess("*", new String[]{"admin"});
        controlList.addToRoleAccess("org.myDomain", null, "list*", new String[]{"view"});
        List roles = controlList.getRolesForObject(new ObjectName("org.myDomain.foo:*"), "setSomethingMore");
        Assert.assertArrayEquals((Object[])roles.toArray(), (Object[])new String[]{"admin"});
    }

    @Test
    public void testKeylessDomain() throws MalformedObjectNameException {
        JMXAccessControlList controlList = new JMXAccessControlList();
        controlList.addToRoleAccess("org.myDomain.foo", null, "list*", new String[]{"amq", "monitor"});
        controlList.addToRoleAccess("org.myDomain.foo", null, "get*", new String[]{"amq", "monitor"});
        controlList.addToRoleAccess("org.myDomain.foo", null, "is*", new String[]{"amq", "monitor"});
        controlList.addToRoleAccess("org.myDomain.foo", null, "set*", new String[]{"amq"});
        controlList.addToRoleAccess("org.myDomain.foo", null, "*", new String[]{"amq"});
        List roles = controlList.getRolesForObject(new ObjectName("org.myDomain.foo:foo=bar"), "listFoo");
        Assert.assertNotNull((Object)roles);
        Assert.assertEquals((long)roles.size(), (long)2L);
        Assert.assertEquals(roles.get(0), (Object)"amq");
        Assert.assertEquals(roles.get(1), (Object)"monitor");
        roles = controlList.getRolesForObject(new ObjectName("org.myDomain.foo:foo=bar"), "getFoo");
        Assert.assertNotNull((Object)roles);
        Assert.assertEquals((long)roles.size(), (long)2L);
        Assert.assertEquals(roles.get(0), (Object)"amq");
        Assert.assertEquals(roles.get(1), (Object)"monitor");
        roles = controlList.getRolesForObject(new ObjectName("org.myDomain.foo:foo=bar"), "isFoo");
        Assert.assertNotNull((Object)roles);
        Assert.assertEquals((long)roles.size(), (long)2L);
        Assert.assertEquals(roles.get(0), (Object)"amq");
        Assert.assertEquals(roles.get(1), (Object)"monitor");
        roles = controlList.getRolesForObject(new ObjectName("org.myDomain.foo:foo=bar"), "setFoo");
        Assert.assertNotNull((Object)roles);
        Assert.assertEquals((long)roles.size(), (long)1L);
        Assert.assertEquals(roles.get(0), (Object)"amq");
        roles = controlList.getRolesForObject(new ObjectName("org.myDomain.foo:foo=bar"), "createFoo");
        Assert.assertNotNull((Object)roles);
        Assert.assertEquals((long)roles.size(), (long)1L);
        Assert.assertEquals(roles.get(0), (Object)"amq");
    }
}

