/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.management.ArtemisMBeanServerGuard;
import org.apache.activemq.artemis.core.server.management.impl.HawtioSecurityControlImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class HawtioSecurityControlImplTest {
    @Test
    public void testCanInvokeMBean() throws Exception {
        String objectName = "foo.bar.testing:type=SomeMBean";
        ArtemisMBeanServerGuard guard = (ArtemisMBeanServerGuard)Mockito.mock(ArtemisMBeanServerGuard.class);
        StorageManager storageManager = (StorageManager)Mockito.mock(StorageManager.class);
        Mockito.when((Object)guard.canInvoke(objectName, null)).thenReturn((Object)true);
        HawtioSecurityControlImpl control = new HawtioSecurityControlImpl(guard, storageManager);
        Assert.assertTrue((boolean)control.canInvoke(objectName));
    }

    @Test
    public void testCanInvokeMBean2() throws Exception {
        String objectName = "foo.bar.testing:type=SomeMBean";
        ArtemisMBeanServerGuard guard = (ArtemisMBeanServerGuard)Mockito.mock(ArtemisMBeanServerGuard.class);
        StorageManager storageManager = (StorageManager)Mockito.mock(StorageManager.class);
        Mockito.when((Object)guard.canInvoke(objectName, null)).thenReturn((Object)false);
        HawtioSecurityControlImpl control = new HawtioSecurityControlImpl(guard, storageManager);
        Assert.assertFalse((boolean)control.canInvoke(objectName));
    }

    @Test(expected=Exception.class)
    public void testCanInvokeMBeanThrowsException() throws Exception {
        String objectName = "foo.bar.testing:type=SomeMBean";
        ArtemisMBeanServerGuard guard = (ArtemisMBeanServerGuard)Mockito.mock(ArtemisMBeanServerGuard.class);
        StorageManager storageManager = (StorageManager)Mockito.mock(StorageManager.class);
        Mockito.when((Object)guard.canInvoke(objectName, null)).thenThrow(new Throwable[]{new Exception()});
        HawtioSecurityControlImpl control = new HawtioSecurityControlImpl(guard, storageManager);
        control.canInvoke(objectName);
        Assert.fail((String)"Should have thrown an exception");
    }

    @Test
    public void testCanInvokeMBeanNoGuard() throws Exception {
        HawtioSecurityControlImpl control = new HawtioSecurityControlImpl(null, null);
        Assert.assertTrue((boolean)control.canInvoke("foo.bar.testing:type=SomeMBean"));
    }

    @Test
    public void testCanInvokeMethod() throws Exception {
        String objectName = "foo.bar.testing:type=SomeMBean";
        ArtemisMBeanServerGuard guard = (ArtemisMBeanServerGuard)Mockito.mock(ArtemisMBeanServerGuard.class);
        StorageManager storageManager = (StorageManager)Mockito.mock(StorageManager.class);
        Mockito.when((Object)guard.canInvoke(objectName, "testMethod")).thenReturn((Object)true);
        Mockito.when((Object)guard.canInvoke(objectName, "otherMethod")).thenReturn((Object)false);
        HawtioSecurityControlImpl control = new HawtioSecurityControlImpl(guard, storageManager);
        Assert.assertTrue((boolean)control.canInvoke(objectName, "testMethod", new String[]{"long"}));
        Assert.assertTrue((boolean)control.canInvoke(objectName, "testMethod", new String[]{"java.lang.String"}));
        Assert.assertFalse((boolean)control.canInvoke(objectName, "otherMethod", new String[]{"java.lang.String", "java.lang.String"}));
    }

    @Test(expected=Exception.class)
    public void testCanInvokeMethodException() throws Exception {
        String objectName = "foo.bar.testing:type=SomeMBean";
        ArtemisMBeanServerGuard guard = (ArtemisMBeanServerGuard)Mockito.mock(ArtemisMBeanServerGuard.class);
        StorageManager storageManager = (StorageManager)Mockito.mock(StorageManager.class);
        Mockito.when((Object)guard.canInvoke(objectName, "testMethod")).thenThrow(new Throwable[]{new Exception()});
        HawtioSecurityControlImpl control = new HawtioSecurityControlImpl(guard, storageManager);
        control.canInvoke(objectName, "testMethod", new String[0]);
        Assert.fail((String)"Should have thrown an exception");
    }

    @Test
    public void testCanInvokeMethodNoGuard() throws Exception {
        HawtioSecurityControlImpl control = new HawtioSecurityControlImpl(null, null);
        Assert.assertTrue((boolean)control.canInvoke("foo.bar.testing:type=SomeMBean", "someMethod", new String[0]));
    }

    @Test
    public void testCanInvokeBulk() throws Exception {
        ArtemisMBeanServerGuard guard = (ArtemisMBeanServerGuard)Mockito.mock(ArtemisMBeanServerGuard.class);
        StorageManager storageManager = (StorageManager)Mockito.mock(StorageManager.class);
        String objectName = "foo.bar.testing:type=SomeMBean";
        Mockito.when((Object)guard.canInvoke(objectName, "testMethod")).thenReturn((Object)true);
        Mockito.when((Object)guard.canInvoke(objectName, "testMethod2")).thenReturn((Object)false);
        Mockito.when((Object)guard.canInvoke(objectName, "otherMethod")).thenReturn((Object)true);
        String objectName2 = "foo.bar.testing:type=SomeOtherMBean";
        Mockito.when((Object)guard.canInvoke(objectName2, null)).thenReturn((Object)true);
        String objectName3 = "foo.bar.foo.testing:type=SomeOtherMBean";
        Mockito.when((Object)guard.canInvoke(objectName3, null)).thenReturn((Object)false);
        HawtioSecurityControlImpl control = new HawtioSecurityControlImpl(guard, storageManager);
        HashMap<String, List<String>> query = new HashMap<String, List<String>>();
        query.put(objectName, Arrays.asList("otherMethod", "testMethod(long)", "testMethod2(java.lang.String)"));
        query.put(objectName2, Collections.emptyList());
        query.put(objectName3, Collections.emptyList());
        TabularData result = control.canInvoke(query);
        Assert.assertEquals((long)5L, (long)result.size());
        CompositeData cd = result.get(new Object[]{objectName, "testMethod(long)"});
        Assert.assertEquals((Object)objectName, (Object)cd.get("ObjectName"));
        Assert.assertEquals((Object)"testMethod(long)", (Object)cd.get("Method"));
        Assert.assertEquals((Object)true, (Object)cd.get("CanInvoke"));
        CompositeData cd2 = result.get(new Object[]{objectName, "testMethod2(java.lang.String)"});
        Assert.assertEquals((Object)objectName, (Object)cd2.get("ObjectName"));
        Assert.assertEquals((Object)"testMethod2(java.lang.String)", (Object)cd2.get("Method"));
        Assert.assertEquals((Object)false, (Object)cd2.get("CanInvoke"));
        CompositeData cd3 = result.get(new Object[]{objectName, "otherMethod"});
        Assert.assertEquals((Object)objectName, (Object)cd3.get("ObjectName"));
        Assert.assertEquals((Object)"otherMethod", (Object)cd3.get("Method"));
        Assert.assertEquals((Object)true, (Object)cd3.get("CanInvoke"));
        CompositeData cd4 = result.get(new Object[]{objectName2, ""});
        Assert.assertEquals((Object)objectName2, (Object)cd4.get("ObjectName"));
        Assert.assertEquals((Object)"", (Object)cd4.get("Method"));
        Assert.assertEquals((Object)true, (Object)cd4.get("CanInvoke"));
        CompositeData cd5 = result.get(new Object[]{objectName3, ""});
        Assert.assertEquals((Object)objectName3, (Object)cd5.get("ObjectName"));
        Assert.assertEquals((Object)"", (Object)cd5.get("Method"));
        Assert.assertEquals((Object)false, (Object)cd5.get("CanInvoke"));
    }

    @Test
    public void testCanInvokeBulkWithDuplicateMethods() throws Exception {
        ArtemisMBeanServerGuard guard = (ArtemisMBeanServerGuard)Mockito.mock(ArtemisMBeanServerGuard.class);
        StorageManager storageManager = (StorageManager)Mockito.mock(StorageManager.class);
        String objectName = "foo.bar.testing:type=SomeMBean";
        Mockito.when((Object)guard.canInvoke(objectName, "duplicateMethod1")).thenReturn((Object)true);
        Mockito.when((Object)guard.canInvoke(objectName, "duplicateMethod2")).thenReturn((Object)false);
        HawtioSecurityControlImpl control = new HawtioSecurityControlImpl(guard, storageManager);
        HashMap<String, List<String>> query = new HashMap<String, List<String>>();
        query.put(objectName, Arrays.asList("duplicateMethod1(long)", "duplicateMethod1(java.lang.String)", "duplicateMethod1(long)", "duplicateMethod2", "duplicateMethod2"));
        TabularData result = control.canInvoke(query);
        Assert.assertEquals((long)3L, (long)result.size());
        CompositeData cd = result.get(new Object[]{objectName, "duplicateMethod1(long)"});
        Assert.assertEquals((Object)objectName, (Object)cd.get("ObjectName"));
        Assert.assertEquals((Object)"duplicateMethod1(long)", (Object)cd.get("Method"));
        Assert.assertEquals((Object)true, (Object)cd.get("CanInvoke"));
        CompositeData cd2 = result.get(new Object[]{objectName, "duplicateMethod1(java.lang.String)"});
        Assert.assertEquals((Object)objectName, (Object)cd2.get("ObjectName"));
        Assert.assertEquals((Object)"duplicateMethod1(java.lang.String)", (Object)cd2.get("Method"));
        Assert.assertEquals((Object)true, (Object)cd2.get("CanInvoke"));
        CompositeData cd3 = result.get(new Object[]{objectName, "duplicateMethod2"});
        Assert.assertEquals((Object)objectName, (Object)cd3.get("ObjectName"));
        Assert.assertEquals((Object)"duplicateMethod2", (Object)cd3.get("Method"));
        Assert.assertEquals((Object)false, (Object)cd3.get("CanInvoke"));
    }
}

