/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.protocol.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.activemq.artemis.core.server.protocol.websocket.WebSocketFrameEncoder;
import org.apache.activemq.artemis.core.server.protocol.websocket.WebSocketFrameEncoderType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class WebSocketFrameEncoderTest {
    private int maxFramePayloadLength = 100;
    private WebSocketFrameEncoder binarySpy;
    private WebSocketFrameEncoder textSpy;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private ChannelPromise promise;

    @Before
    public void setUp() throws Exception {
        this.binarySpy = (WebSocketFrameEncoder)Mockito.spy((Object)new WebSocketFrameEncoder(this.maxFramePayloadLength, WebSocketFrameEncoderType.BINARY));
        this.textSpy = (WebSocketFrameEncoder)Mockito.spy((Object)new WebSocketFrameEncoder(this.maxFramePayloadLength, WebSocketFrameEncoderType.TEXT));
    }

    @Test
    public void testWriteNonByteBufBinary() throws Exception {
        this.testWriteNonByteBuf(this.binarySpy);
    }

    @Test
    public void testWriteNonByteBufText() throws Exception {
        this.testWriteNonByteBuf(this.textSpy);
    }

    private void testWriteNonByteBuf(WebSocketFrameEncoder spy) throws Exception {
        String msg = "Not a ByteBuf";
        spy.write(this.ctx, (Object)msg, this.promise);
        ((WebSocketFrameEncoder)Mockito.verify((Object)spy)).write(this.ctx, (Object)msg, this.promise);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx)).write((Object)msg, this.promise);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{spy, this.ctx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.promise});
    }

    @Test
    public void testWriteReleaseBufferBinary() throws Exception {
        this.testWriteReleaseBuffer(this.binarySpy, BinaryWebSocketFrame.class);
    }

    @Test
    public void testWriteReleaseBufferText() throws Exception {
        this.testWriteReleaseBuffer(this.textSpy, TextWebSocketFrame.class);
    }

    private void testWriteReleaseBuffer(WebSocketFrameEncoder spy, Class webSocketFrameClass) throws Exception {
        String content = "Buffer should be released";
        int utf8Bytes = ByteBufUtil.utf8Bytes((CharSequence)content);
        ByteBuf msg = Unpooled.directBuffer((int)utf8Bytes);
        ByteBufUtil.reserveAndWriteUtf8((ByteBuf)msg, (CharSequence)content, (int)utf8Bytes);
        ArgumentCaptor frameCaptor = ArgumentCaptor.forClass(WebSocketFrame.class);
        spy.write(this.ctx, (Object)msg, this.promise);
        Assert.assertEquals((long)0L, (long)msg.refCnt());
        Assert.assertEquals((long)0L, (long)msg.readableBytes());
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx)).writeAndFlush(frameCaptor.capture(), (ChannelPromise)Mockito.eq((Object)this.promise));
        WebSocketFrame frame = (WebSocketFrame)frameCaptor.getValue();
        Assert.assertTrue((boolean)webSocketFrameClass.isInstance(frame));
        Assert.assertTrue((boolean)frame.isFinalFragment());
        Assert.assertEquals((Object)content, (Object)frame.content().toString(StandardCharsets.UTF_8));
    }

    @Test
    public void testWriteSingleFrameBinary() throws Exception {
        this.testWriteSingleFrame(this.binarySpy, BinaryWebSocketFrame.class);
    }

    @Test
    public void testWriteSingleFrameText() throws Exception {
        this.testWriteSingleFrame(this.textSpy, TextWebSocketFrame.class);
    }

    private void testWriteSingleFrame(WebSocketFrameEncoder spy, Class webSocketFrameClass) throws Exception {
        String content = "Content MSG length less than max frame payload length: " + this.maxFramePayloadLength;
        ByteBuf msg = Unpooled.copiedBuffer((CharSequence)content, (Charset)StandardCharsets.UTF_8);
        ArgumentCaptor frameCaptor = ArgumentCaptor.forClass(WebSocketFrame.class);
        spy.write(this.ctx, (Object)msg, this.promise);
        Assert.assertEquals((long)0L, (long)msg.readableBytes());
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx)).writeAndFlush(frameCaptor.capture(), (ChannelPromise)Mockito.eq((Object)this.promise));
        WebSocketFrame frame = (WebSocketFrame)frameCaptor.getValue();
        Assert.assertTrue((boolean)webSocketFrameClass.isInstance(frame));
        Assert.assertTrue((boolean)frame.isFinalFragment());
        Assert.assertEquals((Object)content, (Object)frame.content().toString(StandardCharsets.UTF_8));
    }

    @Test
    public void testWriteContinuationFramesBinary() throws Exception {
        this.testWriteContinuationFrames(this.binarySpy, BinaryWebSocketFrame.class);
    }

    @Test
    public void testWriteContinuationFramesText() throws Exception {
        this.testWriteContinuationFrames(this.textSpy, TextWebSocketFrame.class);
    }

    private void testWriteContinuationFrames(WebSocketFrameEncoder spy, Class webSocketFrameClass) throws Exception {
        String contentPart = "Content MSG Length @ ";
        StringBuilder contentBuilder = new StringBuilder(3 * this.maxFramePayloadLength);
        while (contentBuilder.length() < 2 * this.maxFramePayloadLength) {
            contentBuilder.append(contentPart);
            contentBuilder.append(contentBuilder.length());
            contentBuilder.append('\n');
        }
        String content = contentBuilder.toString();
        int length = content.length();
        Assert.assertTrue((length > 2 * this.maxFramePayloadLength ? 1 : 0) != 0);
        ByteBuf msg = Unpooled.copiedBuffer((CharSequence)content, (Charset)StandardCharsets.UTF_8);
        ArgumentCaptor frameCaptor = ArgumentCaptor.forClass(WebSocketFrame.class);
        spy.write(this.ctx, (Object)msg, this.promise);
        Assert.assertEquals((long)0L, (long)msg.readableBytes());
        ((WebSocketFrameEncoder)Mockito.verify((Object)spy)).write(this.ctx, (Object)msg, this.promise);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.times((int)3))).writeAndFlush(frameCaptor.capture(), (ChannelPromise)Mockito.eq((Object)this.promise));
        List frames = frameCaptor.getAllValues();
        Assert.assertEquals((long)3L, (long)frames.size());
        int offset = 0;
        WebSocketFrame first = (WebSocketFrame)frames.get(0);
        Assert.assertTrue((boolean)webSocketFrameClass.isInstance(first));
        Assert.assertFalse((boolean)first.isFinalFragment());
        Assert.assertEquals((Object)content.substring(offset, offset + this.maxFramePayloadLength), (Object)first.content().toString(StandardCharsets.UTF_8));
        WebSocketFrame second = (WebSocketFrame)frames.get(1);
        Assert.assertTrue((boolean)(second instanceof ContinuationWebSocketFrame));
        Assert.assertFalse((boolean)second.isFinalFragment());
        Assert.assertEquals((Object)content.substring(offset += this.maxFramePayloadLength, offset + this.maxFramePayloadLength), (Object)second.content().toString(StandardCharsets.UTF_8));
        WebSocketFrame last = (WebSocketFrame)frames.get(2);
        Assert.assertTrue((boolean)(last instanceof ContinuationWebSocketFrame));
        Assert.assertTrue((boolean)last.isFinalFragment());
        Assert.assertEquals((Object)content.substring(offset += this.maxFramePayloadLength), (Object)last.content().toString(StandardCharsets.UTF_8));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{spy, this.ctx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.promise});
    }
}

