/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.protocol.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.artemis.core.server.protocol.websocket.WebSocketFrameEncoderType;
import org.apache.activemq.artemis.core.server.protocol.websocket.WebSocketServerHandler;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WebSocketServerHandlerTest {
    private int maxFramePayloadLength;
    private List<String> supportedProtocols;
    private WebSocketServerHandler spy;

    @Before
    public void setup() throws Exception {
        this.maxFramePayloadLength = 8192;
        this.supportedProtocols = Arrays.asList("STOMP");
        this.spy = (WebSocketServerHandler)Mockito.spy((Object)new WebSocketServerHandler(this.supportedProtocols, this.maxFramePayloadLength, WebSocketFrameEncoderType.BINARY));
    }

    @Test
    public void testRead0HandleContinuationFrame() throws Exception {
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        ContinuationWebSocketFrame msg = new ContinuationWebSocketFrame();
        this.spy.channelRead0(ctx, (Object)msg);
        ((WebSocketServerHandler)Mockito.verify((Object)this.spy)).channelRead0(ctx, (Object)msg);
        ((ChannelHandlerContext)Mockito.verify((Object)ctx)).fireChannelRead(Mockito.any(ByteBuf.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.spy, ctx});
    }

    @Test
    public void testRead0HandleBinaryFrame() throws Exception {
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        BinaryWebSocketFrame msg = new BinaryWebSocketFrame();
        this.spy.channelRead0(ctx, (Object)msg);
        ((WebSocketServerHandler)Mockito.verify((Object)this.spy)).channelRead0(ctx, (Object)msg);
        ((ChannelHandlerContext)Mockito.verify((Object)ctx)).fireChannelRead(Mockito.any(ByteBuf.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.spy, ctx});
    }

    @Test
    public void testRead0HandleTextFrame() throws Exception {
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        TextWebSocketFrame msg = new TextWebSocketFrame();
        this.spy.channelRead0(ctx, (Object)msg);
        ((WebSocketServerHandler)Mockito.verify((Object)this.spy)).channelRead0(ctx, (Object)msg);
        ((ChannelHandlerContext)Mockito.verify((Object)ctx)).fireChannelRead(Mockito.any(ByteBuf.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.spy, ctx});
    }
}

