/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing;

import java.util.Collections;
import org.apache.activemq.artemis.core.config.routing.ConnectionRouterConfiguration;
import org.apache.activemq.artemis.core.config.routing.NamedPropertyConfiguration;
import org.apache.activemq.artemis.core.config.routing.PoolConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.routing.ConnectionRouterManager;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ConnectionRouterManagerTest {
    ActiveMQServer mockServer;
    ConnectionRouterManager underTest;

    @Before
    public void setUp() throws Exception {
        this.mockServer = (ActiveMQServer)Mockito.mock(ActiveMQServer.class);
        this.underTest = new ConnectionRouterManager(null, this.mockServer, null);
        this.underTest.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.underTest != null) {
            this.underTest.stop();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void deployLocalOnlyPoolInvalid() throws Exception {
        ConnectionRouterConfiguration connectionRouterConfiguration = new ConnectionRouterConfiguration();
        connectionRouterConfiguration.setName("partition-local-pool");
        NamedPropertyConfiguration policyConfig = new NamedPropertyConfiguration();
        policyConfig.setName("CONSISTENT_HASH");
        connectionRouterConfiguration.setPolicyConfiguration(policyConfig);
        PoolConfiguration poolConfiguration = new PoolConfiguration();
        poolConfiguration.setLocalTargetEnabled(true);
        connectionRouterConfiguration.setPoolConfiguration(poolConfiguration);
        this.underTest.deployConnectionRouter(connectionRouterConfiguration);
    }

    @Test
    public void deployLocalOnly() throws Exception {
        ManagementService mockManagementService = (ManagementService)Mockito.mock(ManagementService.class);
        Mockito.when((Object)this.mockServer.getManagementService()).thenReturn((Object)mockManagementService);
        ConnectionRouterConfiguration connectionRouterConfiguration = new ConnectionRouterConfiguration();
        connectionRouterConfiguration.setName("partition-local-pool");
        this.underTest.deployConnectionRouter(connectionRouterConfiguration);
    }

    @Test
    public void deployLocalOnlyWithPolicy() throws Exception {
        ManagementService mockManagementService = (ManagementService)Mockito.mock(ManagementService.class);
        Mockito.when((Object)this.mockServer.getManagementService()).thenReturn((Object)mockManagementService);
        ConnectionRouterConfiguration connectionRouterConfiguration = new ConnectionRouterConfiguration();
        connectionRouterConfiguration.setName("partition-local-consistent-hash").setKeyType(KeyType.CLIENT_ID).setLocalTargetFilter(String.valueOf(2));
        NamedPropertyConfiguration policyConfig = new NamedPropertyConfiguration().setName("CONSISTENT_HASH_MODULO").setProperties(Collections.singletonMap("MODULO", String.valueOf(2)));
        connectionRouterConfiguration.setPolicyConfiguration(policyConfig);
        this.underTest.deployConnectionRouter(connectionRouterConfiguration);
    }
}

