/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.routing.ConnectionRouter;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.core.server.routing.policies.AbstractPolicy;
import org.apache.activemq.artemis.core.server.routing.policies.Policy;
import org.apache.activemq.artemis.core.server.routing.targets.LocalTarget;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.apache.activemq.artemis.core.server.routing.targets.TargetResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ConnectionRouterTest {
    Target localTarget;
    ConnectionRouter underTest;

    @Before
    public void setUp() {
        ActiveMQServer mockServer = (ActiveMQServer)Mockito.mock(ActiveMQServer.class);
        this.localTarget = new LocalTarget(null, mockServer);
    }

    @Test
    public void getTarget() {
        Policy policy = null;
        this.underTest = new ConnectionRouter("test", KeyType.CLIENT_ID, "^.{3}", this.localTarget, "^FOO.*", null, null, policy);
        Assert.assertEquals((Object)this.localTarget, (Object)this.underTest.getTarget("FOO_EE").getTarget());
        Assert.assertEquals((Object)TargetResult.REFUSED_USE_ANOTHER_RESULT, (Object)this.underTest.getTarget("BAR_EE"));
    }

    @Test
    public void getLocalTargetWithTransformer() throws Exception {
        AbstractPolicy policy = new AbstractPolicy("TEST"){

            public String transformKey(String key) {
                return key.substring("TRANSFORM_TO".length() + 1);
            }
        };
        this.underTest = new ConnectionRouter("test", KeyType.CLIENT_ID, "^.{3}", this.localTarget, "^FOO.*", null, null, (Policy)policy);
        Assert.assertEquals((Object)this.localTarget, (Object)this.underTest.getTarget("TRANSFORM_TO_FOO_EE").getTarget());
    }
}

