/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing;

import java.util.HashSet;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.core.server.routing.KeyResolver;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.commons.collections.set.ListOrderedSet;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class KeyResolverTest {
    private static final String UNMATCHED_FILTER = "ARTEMIS";

    @Test
    public void testClientIDKey() {
        this.testClientIDKey("TEST", "TEST", null);
    }

    @Test
    public void testClientIDKeyWithFilter() {
        this.testClientIDKey("TEST", "TEST1234", "^.{4}");
    }

    @Test
    public void testClientIDKeyWithUnmatchedFilter() {
        this.testClientIDKey("NULL", "TEST1234", UNMATCHED_FILTER);
    }

    private void testClientIDKey(String expected, String clientID, String filter) {
        KeyResolver keyResolver = new KeyResolver(KeyType.CLIENT_ID, filter);
        Assert.assertEquals((Object)expected, (Object)keyResolver.resolve(null, clientID, null));
        Assert.assertEquals((Object)"NULL", (Object)keyResolver.resolve(null, null, null));
    }

    @Test
    public void testSNIHostKey() {
        this.testSNIHostKey("TEST", "TEST", null);
    }

    @Test
    public void testSNIHostKeyWithFilter() {
        this.testSNIHostKey("TEST", "TEST1234", "^.{4}");
    }

    @Test
    public void testSNIHostKeyWithUnmatchedFilter() {
        this.testSNIHostKey("NULL", null, UNMATCHED_FILTER);
    }

    private void testSNIHostKey(String expected, String sniHost, String filter) {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        KeyResolver keyResolver = new KeyResolver(KeyType.SNI_HOST, filter);
        Mockito.when((Object)connection.getSNIHostName()).thenReturn((Object)sniHost);
        Assert.assertEquals((Object)expected, (Object)keyResolver.resolve(connection, null, null));
        Assert.assertEquals((Object)"NULL", (Object)keyResolver.resolve(null, null, null));
        Mockito.when((Object)connection.getSNIHostName()).thenReturn(null);
        Assert.assertEquals((Object)"NULL", (Object)keyResolver.resolve(null, null, null));
    }

    @Test
    public void testSourceIPKey() {
        this.testSourceIPKey("10.0.0.1", "10.0.0.1:12345", null);
    }

    @Test
    public void testSourceIPKeyWithFilter() {
        this.testSourceIPKey("10", "10.0.0.1:12345", "^[^.]+");
    }

    @Test
    public void testSourceIPKeyWithUnmatchedFilter() {
        this.testSourceIPKey("NULL", "10.0.0.1:12345", UNMATCHED_FILTER);
    }

    private void testSourceIPKey(String expected, String remoteAddress, String filter) {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        KeyResolver keyResolver = new KeyResolver(KeyType.SOURCE_IP, filter);
        Mockito.when((Object)connection.getRemoteAddress()).thenReturn((Object)remoteAddress);
        Assert.assertEquals((Object)expected, (Object)keyResolver.resolve(connection, null, null));
        Assert.assertEquals((Object)"NULL", (Object)keyResolver.resolve(null, null, null));
        Mockito.when((Object)connection.getRemoteAddress()).thenReturn(null);
        Assert.assertEquals((Object)"NULL", (Object)keyResolver.resolve(null, null, null));
    }

    @Test
    public void testUserNameKey() {
        this.testUserNameKey("TEST", "TEST", null);
    }

    @Test
    public void testUserNameKeyWithFilter() {
        this.testUserNameKey("TEST", "TEST1234", "^.{4}");
    }

    @Test
    public void testUserNameKeyWithUnmatchedFilter() {
        this.testUserNameKey("NULL", "TEST1234", UNMATCHED_FILTER);
    }

    private void testUserNameKey(String expected, String username, String filter) {
        KeyResolver keyResolver = new KeyResolver(KeyType.USER_NAME, filter);
        Assert.assertEquals((Object)expected, (Object)keyResolver.resolve(null, null, username));
        Assert.assertEquals((Object)"NULL", (Object)keyResolver.resolve(null, null, null));
    }

    @Test
    public void testRoleNameKeyWithFilter() throws Exception {
        KeyResolver keyResolver = new KeyResolver(KeyType.ROLE_NAME, "B");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Assert.assertEquals((Object)"NULL", (Object)keyResolver.resolve(connection, null, null));
        RemotingConnection protocolConnection = (RemotingConnection)Mockito.mock(RemotingConnection.class);
        Mockito.when((Object)connection.getProtocolConnection()).thenReturn((Object)protocolConnection);
        Subject subject = (Subject)Mockito.mock(Subject.class);
        Mockito.when((Object)protocolConnection.getSubject()).thenReturn((Object)subject);
        Assert.assertEquals((Object)"NULL", (Object)keyResolver.resolve(connection, null, null));
        HashSet<RolePrincipal> rolePrincipals = new HashSet<RolePrincipal>();
        Mockito.when(subject.getPrincipals(RolePrincipal.class)).thenReturn(rolePrincipals);
        Assert.assertEquals((Object)"NULL", (Object)keyResolver.resolve(connection, null, null));
        rolePrincipals.add(new RolePrincipal("A"));
        Assert.assertEquals((Object)"NULL", (Object)keyResolver.resolve(connection, null, null));
        rolePrincipals.add(new RolePrincipal("B"));
        Assert.assertEquals((Object)"B", (Object)keyResolver.resolve(connection, null, null));
    }

    @Test
    public void testRoleNameKeyWithoutFilter() throws Exception {
        KeyResolver keyResolver = new KeyResolver(KeyType.ROLE_NAME, null);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Assert.assertEquals((Object)"NULL", (Object)keyResolver.resolve(connection, null, null));
        RemotingConnection protocolConnection = (RemotingConnection)Mockito.mock(RemotingConnection.class);
        Mockito.when((Object)connection.getProtocolConnection()).thenReturn((Object)protocolConnection);
        Subject subject = (Subject)Mockito.mock(Subject.class);
        Mockito.when((Object)protocolConnection.getSubject()).thenReturn((Object)subject);
        Assert.assertEquals((Object)"NULL", (Object)keyResolver.resolve(connection, null, null));
        ListOrderedSet rolePrincipals = new ListOrderedSet();
        Mockito.when(subject.getPrincipals(RolePrincipal.class)).thenReturn((Object)rolePrincipals);
        Assert.assertEquals((Object)"NULL", (Object)keyResolver.resolve(connection, null, null));
        RolePrincipal roleA = new RolePrincipal("A");
        rolePrincipals.add(roleA);
        Assert.assertEquals((Object)"A", (Object)keyResolver.resolve(connection, null, null));
        rolePrincipals.add(new RolePrincipal("B"));
        Assert.assertEquals((Object)"A", (Object)keyResolver.resolve(connection, null, null));
        rolePrincipals.remove(roleA);
        Assert.assertEquals((Object)"B", (Object)keyResolver.resolve(connection, null, null));
    }
}

