/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.caches;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.PersistedKeyValuePair;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.server.routing.caches.LocalCache;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.Test;

public class LocalCacheTest {
    private static final String CACHE_NAME = "TEST";
    private static final int CACHE_TIMEOUT = 500;
    private static final String CACHE_ENTRY_KEY = "TEST_KEY";
    private static final String CACHE_ENTRY_VALUE = "TEST_VALUE";

    @Test
    public void testValidEntry() {
        LocalCache cache = new LocalCache(CACHE_NAME, false, 0, null);
        cache.start();
        try {
            cache.put(CACHE_ENTRY_KEY, CACHE_ENTRY_VALUE);
            Assert.assertEquals((Object)CACHE_ENTRY_VALUE, (Object)cache.get(CACHE_ENTRY_KEY));
        }
        finally {
            cache.stop();
        }
    }

    @Test
    public void testExpiration() throws Exception {
        LocalCache cache = new LocalCache(CACHE_NAME, false, 500, null);
        cache.start();
        try {
            cache.put(CACHE_ENTRY_KEY, CACHE_ENTRY_VALUE);
            Assert.assertEquals((Object)CACHE_ENTRY_VALUE, (Object)cache.get(CACHE_ENTRY_KEY));
            Wait.assertTrue(() -> cache.get(CACHE_ENTRY_KEY) == null, (long)1000L, (long)500L);
        }
        finally {
            cache.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPersistedEntry() {
        DummyKeyValuePairStorageManager storageManager = new DummyKeyValuePairStorageManager();
        LocalCache cacheBeforeStop = new LocalCache(CACHE_NAME, true, 0, (StorageManager)storageManager);
        cacheBeforeStop.start();
        try {
            cacheBeforeStop.put(CACHE_ENTRY_KEY, CACHE_ENTRY_VALUE);
            Assert.assertEquals((Object)CACHE_ENTRY_VALUE, (Object)cacheBeforeStop.get(CACHE_ENTRY_KEY));
        }
        finally {
            cacheBeforeStop.stop();
        }
        Assert.assertEquals((Object)CACHE_ENTRY_VALUE, (Object)((PersistedKeyValuePair)storageManager.getPersistedKeyValuePairs(CACHE_NAME).get(CACHE_ENTRY_KEY)).getValue());
        LocalCache cacheAfterStop = new LocalCache(CACHE_NAME, true, 0, (StorageManager)storageManager);
        cacheAfterStop.start();
        try {
            Assert.assertEquals((Object)CACHE_ENTRY_VALUE, (Object)cacheAfterStop.get(CACHE_ENTRY_KEY));
        }
        finally {
            cacheAfterStop.stop();
        }
        Assert.assertEquals((Object)CACHE_ENTRY_VALUE, (Object)((PersistedKeyValuePair)storageManager.getPersistedKeyValuePairs(CACHE_NAME).get(CACHE_ENTRY_KEY)).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPersistedExpiration() throws Exception {
        DummyKeyValuePairStorageManager storageManager = new DummyKeyValuePairStorageManager();
        LocalCache cacheBeforeStop = new LocalCache(CACHE_NAME, true, 500, (StorageManager)storageManager);
        cacheBeforeStop.start();
        try {
            cacheBeforeStop.put(CACHE_ENTRY_KEY, CACHE_ENTRY_VALUE);
            Assert.assertEquals((Object)CACHE_ENTRY_VALUE, (Object)cacheBeforeStop.get(CACHE_ENTRY_KEY));
        }
        finally {
            cacheBeforeStop.stop();
        }
        Assert.assertEquals((Object)CACHE_ENTRY_VALUE, (Object)((PersistedKeyValuePair)storageManager.getPersistedKeyValuePairs(CACHE_NAME).get(CACHE_ENTRY_KEY)).getValue());
        LocalCache cacheAfterStop = new LocalCache(CACHE_NAME, true, 500, (StorageManager)storageManager);
        cacheAfterStop.start();
        try {
            Assert.assertEquals((Object)CACHE_ENTRY_VALUE, (Object)cacheAfterStop.get(CACHE_ENTRY_KEY));
            Thread.sleep(1000L);
            Assert.assertNull((Object)cacheAfterStop.get(CACHE_ENTRY_KEY));
        }
        finally {
            cacheAfterStop.stop();
        }
        Assert.assertNull(storageManager.getPersistedKeyValuePairs(CACHE_NAME).get(CACHE_ENTRY_KEY));
    }

    static class DummyKeyValuePairStorageManager
    extends NullStorageManager {
        private Map<String, Map<String, PersistedKeyValuePair>> mapPersistedKeyValuePairs = new ConcurrentHashMap<String, Map<String, PersistedKeyValuePair>>();

        DummyKeyValuePairStorageManager() {
        }

        public void storeKeyValuePair(PersistedKeyValuePair persistedKeyValuePair) throws Exception {
            Map<String, PersistedKeyValuePair> persistedKeyValuePairs = this.mapPersistedKeyValuePairs.get(persistedKeyValuePair.getMapId());
            if (persistedKeyValuePairs == null) {
                persistedKeyValuePairs = new HashMap<String, PersistedKeyValuePair>();
                this.mapPersistedKeyValuePairs.put(persistedKeyValuePair.getMapId(), persistedKeyValuePairs);
            }
            persistedKeyValuePairs.put(persistedKeyValuePair.getKey(), persistedKeyValuePair);
        }

        public void deleteKeyValuePair(String mapId, String key) throws Exception {
            Map<String, PersistedKeyValuePair> persistedKeyValuePairs = this.mapPersistedKeyValuePairs.get(mapId);
            if (persistedKeyValuePairs != null) {
                persistedKeyValuePairs.remove(key);
            }
        }

        public Map<String, PersistedKeyValuePair> getPersistedKeyValuePairs(String mapId) {
            Map<String, PersistedKeyValuePair> persistedKeyValuePairs = this.mapPersistedKeyValuePairs.get(mapId);
            return persistedKeyValuePairs != null ? new HashMap<String, PersistedKeyValuePair>(persistedKeyValuePairs) : new HashMap();
        }
    }
}

