/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.policies;

import java.util.HashMap;
import org.apache.activemq.artemis.core.server.routing.policies.ConsistentHashModuloPolicy;
import org.junit.Assert;
import org.junit.Test;

public class ConsistentHashModuloPolicyTest {
    @Test
    public void transformKey() {
        ConsistentHashModuloPolicy underTest = new ConsistentHashModuloPolicy();
        Assert.assertEquals((Object)"NULL", (Object)underTest.transformKey("NULL"));
        Assert.assertEquals((Object)"AA", (Object)underTest.transformKey("AA"));
        HashMap<String, String> properties = new HashMap<String, String>();
        int modulo = 2;
        properties.put("MODULO", String.valueOf(2));
        underTest.init(properties);
        String hash1 = underTest.transformKey("AAA");
        int v1 = Integer.parseInt(hash1);
        String hash2 = underTest.transformKey("BBB");
        int v2 = Integer.parseInt(hash2);
        Assert.assertNotEquals((Object)hash1, (Object)hash2);
        Assert.assertNotEquals((long)v1, (long)v2);
        Assert.assertTrue((v1 < 2 && v2 < 2 ? 1 : 0) != 0);
    }

    @Test
    public void transformKeyNotNegative() {
        String[] values;
        ConsistentHashModuloPolicy underTest = new ConsistentHashModuloPolicy();
        HashMap<String, String> properties = new HashMap<String, String>();
        int modulo = 2;
        properties.put("MODULO", String.valueOf(2));
        underTest.init(properties);
        Assert.assertNotNull((Object)underTest.getProperties());
        for (String v : values = new String[]{"ONE", "TWO", "THREE", "FOUR"}) {
            Assert.assertTrue((String)("non negative for: " + v), (Integer.valueOf(underTest.transformKey(v)) >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void transformKeyNotNegativeWithExplicitNegativeHash() {
        final int[] negs = new int[]{-1, Integer.MAX_VALUE, Integer.MIN_VALUE, 100, 500, 22, 2, 1};
        ConsistentHashModuloPolicy underTest = new ConsistentHashModuloPolicy(){
            int v = 0;

            protected int getHash(String str) {
                return negs[this.v++ % negs.length];
            }
        };
        HashMap<String, String> properties = new HashMap<String, String>();
        int modulo = 2;
        properties.put("MODULO", String.valueOf(2));
        underTest.init(properties);
        Assert.assertNotNull((Object)underTest.getProperties());
        for (int i = 0; i < negs.length; ++i) {
            Assert.assertTrue((String)("non negative for: " + i), (Integer.valueOf(underTest.transformKey("BLA")) >= 0 ? 1 : 0) != 0);
        }
    }
}

