/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.policies;

import java.util.ArrayList;
import org.apache.activemq.artemis.core.server.routing.policies.AbstractPolicy;
import org.apache.activemq.artemis.core.server.routing.policies.ConsistentHashPolicy;
import org.apache.activemq.artemis.core.server.routing.policies.PolicyTestBase;
import org.apache.activemq.artemis.core.server.routing.targets.MockTarget;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.junit.Assert;
import org.junit.Test;

public class ConsistentHashPolicyTest
extends PolicyTestBase {
    @Override
    protected AbstractPolicy createPolicy() {
        return new ConsistentHashPolicy();
    }

    @Test
    public void testPolicyWithMultipleTargets() {
        Target selectedTarget;
        AbstractPolicy policy = this.createPolicy();
        ArrayList<MockTarget> targets = new ArrayList<MockTarget>();
        for (int i = 0; i < 10; ++i) {
            targets.add(new MockTarget());
        }
        Target previousTarget = selectedTarget = policy.selectTarget(targets, "test");
        selectedTarget = policy.selectTarget(targets, "test");
        Assert.assertEquals((Object)previousTarget, (Object)selectedTarget);
        targets.remove(previousTarget);
        selectedTarget = policy.selectTarget(targets, "test");
        Assert.assertNotEquals((Object)previousTarget, (Object)selectedTarget);
    }
}

