/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.policies;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import org.apache.activemq.artemis.core.server.routing.policies.AbstractPolicy;
import org.apache.activemq.artemis.core.server.routing.policies.LeastConnectionsPolicy;
import org.apache.activemq.artemis.core.server.routing.policies.PolicyTestBase;
import org.apache.activemq.artemis.core.server.routing.targets.MockTarget;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.junit.Assert;
import org.junit.Test;

public class LeastConnectionsPolicyTest
extends PolicyTestBase {
    @Override
    protected AbstractPolicy createPolicy() {
        return new LeastConnectionsPolicy();
    }

    @Test
    public void testPolicyWithMultipleTargets() {
        int i;
        AbstractPolicy policy = this.createPolicy();
        Target selectedTarget = null;
        ArrayList<MockTarget> targets = new ArrayList<MockTarget>();
        for (i = 0; i < 10; ++i) {
            targets.add(new MockTarget().setConnected(true).setReady(true));
        }
        HashSet<Target> selectedTargets = new HashSet<Target>();
        for (i = 0; i < 10; ++i) {
            selectedTarget = policy.selectTarget(targets, "test");
            selectedTargets.add(selectedTarget);
        }
        Assert.assertEquals((long)10L, (long)selectedTargets.size());
        targets.forEach((Consumer<MockTarget>)((Consumer<Target>)target -> {
            ((MockTarget)((Object)target)).setAttributeValue("broker", "ConnectionCount", 3);
            policy.getTargetProbe().check(target);
        }));
        selectedTargets = new HashSet();
        for (i = 0; i < 10; ++i) {
            selectedTarget = policy.selectTarget(targets, "test");
            selectedTargets.add(selectedTarget);
        }
        Assert.assertEquals((long)10L, (long)selectedTargets.size());
        ((MockTarget)((Object)targets.get(0))).setAttributeValue("broker", "ConnectionCount", 2);
        targets.forEach((Consumer<MockTarget>)((Consumer<Target>)target -> policy.getTargetProbe().check(target)));
        selectedTargets = new HashSet();
        for (i = 0; i < 10; ++i) {
            selectedTarget = policy.selectTarget(targets, "test");
            selectedTargets.add(selectedTarget);
        }
        Assert.assertEquals((long)1L, (long)selectedTargets.size());
        Assert.assertTrue((boolean)selectedTargets.contains(targets.get(0)));
        ((MockTarget)((Object)targets.get(1))).setAttributeValue("broker", "ConnectionCount", 1);
        ((MockTarget)((Object)targets.get(2))).setAttributeValue("broker", "ConnectionCount", 1);
        targets.forEach((Consumer<MockTarget>)((Consumer<Target>)target -> policy.getTargetProbe().check(target)));
        selectedTargets = new HashSet();
        for (i = 0; i < 10; ++i) {
            selectedTarget = policy.selectTarget(targets, "test");
            selectedTargets.add(selectedTarget);
        }
        Assert.assertEquals((long)2L, (long)selectedTargets.size());
        Assert.assertTrue((boolean)selectedTargets.contains(targets.get(1)));
        Assert.assertTrue((boolean)selectedTargets.contains(targets.get(2)));
    }
}

