/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.policies;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.activemq.artemis.core.server.routing.policies.AbstractPolicy;
import org.apache.activemq.artemis.core.server.routing.targets.MockTarget;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.junit.Assert;
import org.junit.Test;

public abstract class PolicyTestBase {
    public static final int MULTIPLE_TARGETS = 10;

    protected abstract AbstractPolicy createPolicy();

    @Test
    public void testPolicyWithNoTarget() {
        AbstractPolicy policy = this.createPolicy();
        Target selectedTarget = policy.selectTarget(Collections.emptyList(), "test");
        Assert.assertNull((Object)selectedTarget);
    }

    @Test
    public void testPolicyWithSingleTarget() {
        AbstractPolicy policy = this.createPolicy();
        ArrayList<MockTarget> targets = new ArrayList<MockTarget>();
        targets.add(new MockTarget());
        Target selectedTarget = policy.selectTarget(targets, "test");
        Assert.assertEquals((Object)selectedTarget, targets.get(0));
    }
}

