/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.policies;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.activemq.artemis.core.server.routing.policies.AbstractPolicy;
import org.apache.activemq.artemis.core.server.routing.policies.PolicyTestBase;
import org.apache.activemq.artemis.core.server.routing.policies.RoundRobinPolicy;
import org.apache.activemq.artemis.core.server.routing.targets.MockTarget;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.junit.Assert;
import org.junit.Test;

public class RoundRobinPolicyTest
extends PolicyTestBase {
    @Override
    protected AbstractPolicy createPolicy() {
        return new RoundRobinPolicy();
    }

    @Test
    public void testPolicyWithMultipleTargets() {
        int i;
        AbstractPolicy policy = this.createPolicy();
        Target selectedTarget = null;
        HashSet<Target> selectedTargets = new HashSet<Target>();
        ArrayList<Target> previousTargets = new ArrayList<Target>();
        ArrayList<MockTarget> targets = new ArrayList<MockTarget>();
        for (i = 0; i < 10; ++i) {
            targets.add(new MockTarget());
        }
        selectedTargets = new HashSet();
        for (i = 0; i < 10; ++i) {
            selectedTarget = policy.selectTarget(targets, "test");
            selectedTargets.add(selectedTarget);
            Assert.assertTrue((String)("Iteration failed: " + i), (!previousTargets.contains(selectedTarget) ? 1 : 0) != 0);
            previousTargets.add(selectedTarget);
        }
        Assert.assertEquals((long)10L, (long)selectedTargets.size());
    }
}

