/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.pools;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.stream.Stream;
import org.apache.activemq.artemis.core.server.routing.pools.DiscoveryPool;
import org.apache.activemq.artemis.core.server.routing.pools.DiscoveryService;
import org.apache.activemq.artemis.core.server.routing.pools.MockDiscoveryService;
import org.apache.activemq.artemis.core.server.routing.pools.Pool;
import org.apache.activemq.artemis.core.server.routing.pools.PoolTestBase;
import org.apache.activemq.artemis.core.server.routing.targets.MockTargetFactory;
import org.apache.activemq.artemis.core.server.routing.targets.MockTargetProbe;
import org.apache.activemq.artemis.core.server.routing.targets.TargetFactory;
import org.apache.activemq.artemis.core.server.routing.targets.TargetProbe;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.Test;

public class DiscoveryPoolTest
extends PoolTestBase {
    @Test
    public void testPoolAddingRemovingAllEntries() throws Exception {
        this.testPoolChangingEntries(5, 10, 10);
    }

    @Test
    public void testPoolAddingRemovingPartialEntries() throws Exception {
        this.testPoolChangingEntries(5, 10, 5);
    }

    @Test
    public void testPoolAddingRemovingAllEntriesAfterStart() throws Exception {
        this.testPoolChangingEntries(0, 10, 10);
    }

    @Test
    public void testPoolAddingRemovingPartialEntriesAfterStart() throws Exception {
        this.testPoolChangingEntries(0, 10, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPoolChangingEntries(int initialEntries, int addingEntries, int removingEntries) throws Exception {
        MockTargetFactory targetFactory = new MockTargetFactory();
        MockTargetProbe targetProbe = new MockTargetProbe("TEST", true);
        MockDiscoveryService discoveryService = new MockDiscoveryService();
        targetProbe.setChecked(true);
        ArrayList<String> initialNodeIDs = new ArrayList<String>();
        for (int i = 0; i < initialEntries; ++i) {
            initialNodeIDs.add(discoveryService.addEntry().getNodeID());
        }
        DiscoveryPool pool = this.createDiscoveryPool((TargetFactory)targetFactory, discoveryService);
        pool.addTargetProbe((TargetProbe)targetProbe);
        pool.start();
        try {
            targetFactory.getCreatedTargets().forEach(mockTarget -> mockTarget.setConnectable(true));
            targetFactory.getCreatedTargets().forEach(mockTarget -> mockTarget.setReady(true));
            Wait.assertEquals((int)initialEntries, () -> DiscoveryPoolTest.lambda$testPoolChangingEntries$2((Pool)pool), (long)1000L);
            Assert.assertEquals((long)initialEntries, (long)pool.getAllTargets().size());
            Assert.assertEquals((long)initialEntries, (long)targetFactory.getCreatedTargets().size());
            initialNodeIDs.forEach(arg_0 -> DiscoveryPoolTest.lambda$testPoolChangingEntries$3((Pool)pool, arg_0));
            ArrayList<String> addedNodeIDs = new ArrayList<String>();
            for (int i = 0; i < addingEntries; ++i) {
                addedNodeIDs.add(discoveryService.addEntry().getNodeID());
            }
            Assert.assertEquals((long)initialEntries, (long)pool.getTargets().size());
            Assert.assertEquals((long)(initialEntries + addingEntries), (long)pool.getAllTargets().size());
            Assert.assertEquals((long)(initialEntries + addingEntries), (long)targetFactory.getCreatedTargets().size());
            initialNodeIDs.forEach(arg_0 -> DiscoveryPoolTest.lambda$testPoolChangingEntries$4((Pool)pool, targetProbe, arg_0));
            addedNodeIDs.forEach(arg_0 -> DiscoveryPoolTest.lambda$testPoolChangingEntries$5((Pool)pool, targetProbe, arg_0));
            targetFactory.getCreatedTargets().forEach(mockTarget -> mockTarget.setConnectable(true));
            Assert.assertEquals((long)initialEntries, (long)pool.getTargets().size());
            Assert.assertEquals((long)(initialEntries + addingEntries), (long)pool.getAllTargets().size());
            Assert.assertEquals((long)(initialEntries + addingEntries), (long)targetFactory.getCreatedTargets().size());
            initialNodeIDs.forEach(arg_0 -> DiscoveryPoolTest.lambda$testPoolChangingEntries$7((Pool)pool, targetProbe, arg_0));
            addedNodeIDs.forEach(arg_0 -> DiscoveryPoolTest.lambda$testPoolChangingEntries$8((Pool)pool, targetProbe, arg_0));
            targetFactory.getCreatedTargets().forEach(mockTarget -> mockTarget.setReady(true));
            Wait.assertEquals((int)(initialEntries + addingEntries), () -> DiscoveryPoolTest.lambda$testPoolChangingEntries$10((Pool)pool), (long)1000L);
            Assert.assertEquals((long)(initialEntries + addingEntries), (long)pool.getAllTargets().size());
            Assert.assertEquals((long)(initialEntries + addingEntries), (long)targetFactory.getCreatedTargets().size());
            Stream.concat(initialNodeIDs.stream(), addedNodeIDs.stream()).forEach(arg_0 -> DiscoveryPoolTest.lambda$testPoolChangingEntries$11((Pool)pool, targetProbe, arg_0));
            if (removingEntries > 0) {
                ArrayList<String> removingNodeIDs = new ArrayList<String>();
                for (int i = 0; i < removingEntries; ++i) {
                    removingNodeIDs.add(discoveryService.removeEntry(targetFactory.getCreatedTargets().get(i).getNodeID()).getNodeID());
                }
                Assert.assertEquals((long)(initialEntries + addingEntries - removingEntries), (long)pool.getTargets().size());
                Assert.assertEquals((long)(initialEntries + addingEntries - removingEntries), (long)pool.getAllTargets().size());
                Assert.assertEquals((long)(initialEntries + addingEntries), (long)targetFactory.getCreatedTargets().size());
                Stream.concat(initialNodeIDs.stream(), addedNodeIDs.stream()).forEach(arg_0 -> DiscoveryPoolTest.lambda$testPoolChangingEntries$12(removingNodeIDs, (Pool)pool, targetProbe, arg_0));
            } else {
                Assert.assertEquals((long)(initialEntries + addingEntries), (long)pool.getTargets().size());
                Assert.assertEquals((long)(initialEntries + addingEntries), (long)pool.getAllTargets().size());
                Assert.assertEquals((long)(initialEntries + addingEntries), (long)targetFactory.getCreatedTargets().size());
                Stream.concat(initialNodeIDs.stream(), addedNodeIDs.stream()).forEach(arg_0 -> DiscoveryPoolTest.lambda$testPoolChangingEntries$13((Pool)pool, targetProbe, arg_0));
            }
        }
        finally {
            pool.stop();
        }
    }

    @Override
    protected Pool createPool(TargetFactory targetFactory, int targets) {
        MockDiscoveryService discoveryService = new MockDiscoveryService();
        for (int i = 0; i < targets; ++i) {
            discoveryService.addEntry();
        }
        return this.createDiscoveryPool(targetFactory, discoveryService);
    }

    private DiscoveryPool createDiscoveryPool(TargetFactory targetFactory, DiscoveryService discoveryService) {
        return new DiscoveryPool(targetFactory, (ScheduledExecutorService)new ScheduledThreadPoolExecutor(0), 100, discoveryService);
    }

    private static /* synthetic */ void lambda$testPoolChangingEntries$13(Pool pool, MockTargetProbe targetProbe, String nodeID) {
        Assert.assertTrue((boolean)pool.isTargetReady(pool.getTarget(nodeID)));
        Assert.assertTrue((targetProbe.getTargetExecutions(pool.getTarget(nodeID)) > 0 ? 1 : 0) != 0);
    }

    private static /* synthetic */ void lambda$testPoolChangingEntries$12(List removingNodeIDs, Pool pool, MockTargetProbe targetProbe, String nodeID) {
        if (removingNodeIDs.contains(nodeID)) {
            Assert.assertNull((Object)pool.getTarget(nodeID));
        } else {
            Assert.assertTrue((boolean)pool.isTargetReady(pool.getTarget(nodeID)));
            Assert.assertTrue((targetProbe.getTargetExecutions(pool.getTarget(nodeID)) > 0 ? 1 : 0) != 0);
        }
    }

    private static /* synthetic */ void lambda$testPoolChangingEntries$11(Pool pool, MockTargetProbe targetProbe, String nodeID) {
        Assert.assertTrue((boolean)pool.isTargetReady(pool.getTarget(nodeID)));
        Assert.assertTrue((targetProbe.getTargetExecutions(pool.getTarget(nodeID)) > 0 ? 1 : 0) != 0);
    }

    private static /* synthetic */ int lambda$testPoolChangingEntries$10(Pool pool) throws Exception {
        return pool.getTargets().size();
    }

    private static /* synthetic */ void lambda$testPoolChangingEntries$8(Pool pool, MockTargetProbe targetProbe, String nodeID) {
        Assert.assertFalse((boolean)pool.isTargetReady(pool.getTarget(nodeID)));
        Assert.assertEquals((long)0L, (long)targetProbe.getTargetExecutions(pool.getTarget(nodeID)));
    }

    private static /* synthetic */ void lambda$testPoolChangingEntries$7(Pool pool, MockTargetProbe targetProbe, String nodeID) {
        Assert.assertTrue((boolean)pool.isTargetReady(pool.getTarget(nodeID)));
        Assert.assertTrue((targetProbe.getTargetExecutions(pool.getTarget(nodeID)) > 0 ? 1 : 0) != 0);
    }

    private static /* synthetic */ void lambda$testPoolChangingEntries$5(Pool pool, MockTargetProbe targetProbe, String nodeID) {
        Assert.assertFalse((boolean)pool.isTargetReady(pool.getTarget(nodeID)));
        Assert.assertEquals((long)0L, (long)targetProbe.getTargetExecutions(pool.getTarget(nodeID)));
    }

    private static /* synthetic */ void lambda$testPoolChangingEntries$4(Pool pool, MockTargetProbe targetProbe, String nodeID) {
        Assert.assertTrue((boolean)pool.isTargetReady(pool.getTarget(nodeID)));
        Assert.assertTrue((targetProbe.getTargetExecutions(pool.getTarget(nodeID)) > 0 ? 1 : 0) != 0);
    }

    private static /* synthetic */ void lambda$testPoolChangingEntries$3(Pool pool, String nodeID) {
        Assert.assertTrue((boolean)pool.isTargetReady(pool.getTarget(nodeID)));
    }

    private static /* synthetic */ int lambda$testPoolChangingEntries$2(Pool pool) throws Exception {
        return pool.getTargets().size();
    }
}

