/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.pools;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.server.routing.pools.DiscoveryService;

public class MockDiscoveryService
extends DiscoveryService {
    private final Map<String, DiscoveryService.Entry> entries = new HashMap<String, DiscoveryService.Entry>();
    private final Map<String, DiscoveryService.Entry> pendingEntries = new HashMap<String, DiscoveryService.Entry>();
    private volatile boolean started;

    public Map<String, DiscoveryService.Entry> getEntries() {
        return this.entries;
    }

    public Map<String, DiscoveryService.Entry> getPendingEntries() {
        return this.pendingEntries;
    }

    public boolean isStarted() {
        return this.started;
    }

    public DiscoveryService.Entry addEntry() {
        return this.addEntry(new DiscoveryService.Entry((DiscoveryService)this, UUID.randomUUID().toString(), new TransportConfiguration()));
    }

    public DiscoveryService.Entry addEntry(DiscoveryService.Entry entry) {
        if (this.started) {
            this.entries.put(entry.getNodeID(), entry);
            this.fireEntryAddedEvent(entry);
        } else {
            this.pendingEntries.put(entry.getNodeID(), entry);
        }
        return entry;
    }

    public DiscoveryService.Entry removeEntry(String nodeID) {
        if (this.started) {
            DiscoveryService.Entry removedEntry = this.entries.remove(nodeID);
            this.fireEntryRemovedEvent(removedEntry);
            return removedEntry;
        }
        return this.pendingEntries.remove(nodeID);
    }

    public void start() throws Exception {
        this.started = true;
        this.pendingEntries.forEach((nodeID, entry) -> {
            this.entries.put((String)nodeID, (DiscoveryService.Entry)entry);
            this.fireEntryAddedEvent((DiscoveryService.Entry)entry);
        });
    }

    public void stop() throws Exception {
        this.started = false;
    }
}

