/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.pools;

import org.apache.activemq.artemis.core.server.routing.pools.Pool;
import org.apache.activemq.artemis.core.server.routing.targets.MockTargetFactory;
import org.apache.activemq.artemis.core.server.routing.targets.MockTargetProbe;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.apache.activemq.artemis.core.server.routing.targets.TargetFactory;
import org.apache.activemq.artemis.core.server.routing.targets.TargetProbe;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.Test;

public abstract class PoolTestBase {
    public static final int MULTIPLE_TARGETS = 10;
    public static final int CHECK_PERIOD = 100;
    public static final int CHECK_TIMEOUT = 1000;

    protected abstract Pool createPool(TargetFactory var1, int var2);

    @Test
    public void testPoolWithNoTargets() throws Exception {
        this.testPoolTargets(0);
    }

    @Test
    public void testPoolWithSingleTarget() throws Exception {
        this.testPoolTargets(1);
    }

    @Test
    public void testPoolWithMultipleTargets() throws Exception {
        this.testPoolTargets(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPoolQuorumWithMultipleTargets() throws Exception {
        int targets = 10;
        int quorumSize = 2;
        Assert.assertTrue((boolean)true);
        MockTargetFactory targetFactory = new MockTargetFactory().setConnectable(true).setReady(true);
        Pool pool = this.createPool((TargetFactory)targetFactory, 10);
        pool.setQuorumSize(2);
        Assert.assertEquals((long)0L, (long)pool.getTargets().size());
        pool.start();
        try {
            Wait.assertEquals((int)10, () -> pool.getTargets().size(), (long)1000L);
            targetFactory.getCreatedTargets().stream().limit(9L).forEach(mockTarget -> mockTarget.setReady(false));
            Wait.assertEquals((int)0, () -> pool.getTargets().size(), (long)1000L);
            targetFactory.getCreatedTargets().get(0).setReady(true);
            Wait.assertEquals((int)2, () -> pool.getTargets().size(), (long)1000L);
            pool.setQuorumSize(3);
            Wait.assertEquals((int)0, () -> pool.getTargets().size(), (long)1000L);
            targetFactory.getCreatedTargets().get(1).setReady(true);
            Wait.assertEquals((int)3, () -> pool.getTargets().size(), (long)1000L);
        }
        finally {
            pool.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPoolTargets(int targets) throws Exception {
        MockTargetFactory targetFactory = new MockTargetFactory();
        MockTargetProbe targetProbe = new MockTargetProbe("TEST", false);
        Pool pool = this.createPool((TargetFactory)targetFactory, targets);
        pool.addTargetProbe((TargetProbe)targetProbe);
        Assert.assertEquals((long)0L, (long)pool.getTargets().size());
        Assert.assertEquals((long)0L, (long)pool.getAllTargets().size());
        Assert.assertEquals((long)0L, (long)targetFactory.getCreatedTargets().size());
        pool.start();
        try {
            Assert.assertEquals((long)0L, (long)pool.getTargets().size());
            Assert.assertEquals((long)targets, (long)pool.getAllTargets().size());
            Assert.assertEquals((long)targets, (long)targetFactory.getCreatedTargets().size());
            targetFactory.getCreatedTargets().forEach(mockTarget -> {
                Assert.assertFalse((boolean)pool.isTargetReady((Target)mockTarget));
                Assert.assertEquals((long)0L, (long)targetProbe.getTargetExecutions((Target)mockTarget));
            });
            if (targets > 0) {
                targetFactory.getCreatedTargets().forEach(mockTarget -> mockTarget.setConnectable(true));
                Assert.assertEquals((long)0L, (long)pool.getTargets().size());
                Assert.assertEquals((long)targets, (long)pool.getAllTargets().size());
                Assert.assertEquals((long)targets, (long)targetFactory.getCreatedTargets().size());
                targetFactory.getCreatedTargets().forEach(mockTarget -> {
                    Assert.assertFalse((boolean)pool.isTargetReady((Target)mockTarget));
                    Assert.assertEquals((long)0L, (long)targetProbe.getTargetExecutions((Target)mockTarget));
                });
                targetFactory.getCreatedTargets().forEach(mockTarget -> mockTarget.setReady(true));
                Assert.assertEquals((long)0L, (long)pool.getTargets().size());
                Assert.assertEquals((long)targets, (long)pool.getAllTargets().size());
                Assert.assertEquals((long)targets, (long)targetFactory.getCreatedTargets().size());
                targetFactory.getCreatedTargets().forEach(mockTarget -> {
                    Assert.assertFalse((boolean)pool.isTargetReady((Target)mockTarget));
                    Wait.assertTrue(() -> targetProbe.getTargetExecutions((Target)mockTarget) > 0, (long)1000L);
                });
                targetProbe.clearTargetExecutions();
                targetProbe.setChecked(true);
                Wait.assertEquals((int)targets, () -> pool.getTargets().size(), (long)1000L);
                Assert.assertEquals((long)targets, (long)pool.getAllTargets().size());
                Assert.assertEquals((long)targets, (long)targetFactory.getCreatedTargets().size());
                targetFactory.getCreatedTargets().forEach(mockTarget -> {
                    Assert.assertTrue((boolean)pool.isTargetReady((Target)mockTarget));
                    Assert.assertTrue((targetProbe.getTargetExecutions((Target)mockTarget) > 0 ? 1 : 0) != 0);
                });
                targetFactory.getCreatedTargets().forEach(mockTarget -> {
                    mockTarget.setConnectable(false);
                    try {
                        mockTarget.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                Wait.assertEquals((int)0, () -> pool.getTargets().size(), (long)1000L);
                Assert.assertEquals((long)targets, (long)pool.getAllTargets().size());
                Assert.assertEquals((long)targets, (long)targetFactory.getCreatedTargets().size());
                targetProbe.clearTargetExecutions();
                targetFactory.getCreatedTargets().forEach(mockTarget -> mockTarget.setConnectable(true));
                Wait.assertEquals((int)targets, () -> pool.getTargets().size(), (long)1000L);
                Assert.assertEquals((long)targets, (long)pool.getAllTargets().size());
                Assert.assertEquals((long)targets, (long)targetFactory.getCreatedTargets().size());
                targetFactory.getCreatedTargets().forEach(mockTarget -> {
                    Wait.assertTrue(() -> pool.isTargetReady((Target)mockTarget), (long)1000L);
                    Wait.assertTrue(() -> targetProbe.getTargetExecutions((Target)mockTarget) > 0, (long)1000L);
                });
                targetProbe.clearTargetExecutions();
                targetProbe.setChecked(false);
                Wait.assertEquals((int)0, () -> pool.getTargets().size(), (long)1000L);
                Assert.assertEquals((long)targets, (long)pool.getAllTargets().size());
                Assert.assertEquals((long)targets, (long)targetFactory.getCreatedTargets().size());
                targetFactory.getCreatedTargets().forEach(mockTarget -> {
                    Wait.assertTrue(() -> !pool.isTargetReady((Target)mockTarget), (long)1000L);
                    Wait.assertTrue(() -> targetProbe.getTargetExecutions((Target)mockTarget) > 0, (long)1000L);
                });
            }
        }
        finally {
            pool.stop();
        }
    }
}

