/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.targets;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.server.routing.targets.AbstractTarget;

public class MockTarget
extends AbstractTarget {
    private boolean local = false;
    private boolean connected = false;
    private boolean connectable = false;
    private boolean ready = false;
    private Map<String, Object> attributeValues = new HashMap<String, Object>();
    private Map<String, Object> operationReturnValues = new HashMap<String, Object>();

    public boolean isLocal() {
        return false;
    }

    public MockTarget setLocal(boolean local) {
        this.local = local;
        return this;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public MockTarget setConnected(boolean connected) {
        this.connected = connected;
        return this;
    }

    public MockTarget setConnectable(boolean connectable) {
        this.connectable = connectable;
        return this;
    }

    public boolean isReady() {
        return this.ready;
    }

    public MockTarget setReady(boolean ready) {
        this.ready = ready;
        return this;
    }

    public Map<String, Object> getAttributeValues() {
        return this.attributeValues;
    }

    public void setAttributeValues(Map<String, Object> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public Map<String, Object> getOperationReturnValues() {
        return this.operationReturnValues;
    }

    public void setOperationReturnValues(Map<String, Object> operationReturnValues) {
        this.operationReturnValues = operationReturnValues;
    }

    public MockTarget() {
        this(new TransportConfiguration(), UUID.randomUUID().toString());
    }

    public MockTarget(TransportConfiguration connector, String nodeID) {
        super(connector, nodeID);
    }

    public void connect() throws Exception {
        if (!this.connectable) {
            throw new IllegalStateException("Target not connectable");
        }
        if (this.getNodeID() == null) {
            this.setNodeID(UUID.randomUUID().toString());
        }
        this.connected = true;
        this.fireConnectedEvent();
    }

    public void disconnect() throws Exception {
        this.connected = false;
        this.fireDisconnectedEvent();
    }

    public boolean checkReadiness() {
        return this.connected && this.ready;
    }

    public <T> T getAttribute(String resourceName, String attributeName, Class<T> attributeClass, int timeout) throws Exception {
        this.checkConnection();
        return (T)this.attributeValues.get(resourceName + attributeName);
    }

    public <T> T invokeOperation(String resourceName, String operationName, Object[] operationParams, Class<T> operationClass, int timeout) throws Exception {
        this.checkConnection();
        return (T)this.operationReturnValues.get(resourceName + operationName);
    }

    public void setAttributeValue(String resourceName, String attributeName, Object value) {
        this.attributeValues.put(resourceName + attributeName, value);
    }

    public void setOperationReturnValue(String resourceName, String attributeName, Object value) {
        this.operationReturnValues.put(resourceName + attributeName, value);
    }

    private void checkConnection() {
        if (!this.connected) {
            throw new IllegalStateException("Target not connected");
        }
    }
}

