/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.targets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.server.routing.targets.AbstractTargetFactory;
import org.apache.activemq.artemis.core.server.routing.targets.MockTarget;
import org.apache.activemq.artemis.core.server.routing.targets.Target;

public class MockTargetFactory
extends AbstractTargetFactory {
    private final List<MockTarget> createdTargets = new ArrayList<MockTarget>();
    private Boolean connectable = null;
    private Boolean ready = null;
    private Map<String, Object> attributeValues = null;
    private Map<String, Object> operationReturnValues = null;

    public Boolean getConnectable() {
        return this.connectable;
    }

    public MockTargetFactory setConnectable(Boolean connectable) {
        this.connectable = connectable;
        return this;
    }

    public Boolean getReady() {
        return this.ready;
    }

    public MockTargetFactory setReady(Boolean ready) {
        this.ready = ready;
        return this;
    }

    public Map<String, Object> getAttributeValues() {
        return this.attributeValues;
    }

    public MockTargetFactory setAttributeValues(Map<String, Object> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    public Map<String, Object> getOperationReturnValues() {
        return this.operationReturnValues;
    }

    public MockTargetFactory setOperationReturnValues(Map<String, Object> operationReturnValues) {
        this.operationReturnValues = operationReturnValues;
        return this;
    }

    public List<MockTarget> getCreatedTargets() {
        return this.createdTargets;
    }

    public Target createTarget(TransportConfiguration connector, String nodeID) {
        MockTarget target = new MockTarget(connector, nodeID);
        target.setUsername(this.getUsername());
        target.setPassword(this.getPassword());
        this.createdTargets.add(target);
        if (this.connectable != null) {
            target.setConnectable(this.connectable);
        }
        if (this.ready != null) {
            target.setReady(this.ready);
        }
        if (this.attributeValues != null) {
            target.setAttributeValues(this.attributeValues);
        }
        if (this.operationReturnValues != null) {
            target.setOperationReturnValues(this.operationReturnValues);
        }
        return target;
    }
}

