/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.targets;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.apache.activemq.artemis.core.server.routing.targets.TargetProbe;

public class MockTargetProbe
extends TargetProbe {
    private final Map<Target, Integer> targetExecutions = new ConcurrentHashMap<Target, Integer>();
    private volatile boolean checked;

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public MockTargetProbe(String name, boolean checked) {
        super(name);
        this.checked = checked;
    }

    public int getTargetExecutions(Target target) {
        Integer executions = this.targetExecutions.get(target);
        return executions != null ? executions : 0;
    }

    public int setTargetExecutions(Target target, int executions) {
        return this.targetExecutions.put(target, executions);
    }

    public void clearTargetExecutions() {
        this.targetExecutions.clear();
    }

    public boolean check(Target target) {
        this.targetExecutions.compute(target, (t, e) -> {
            int n;
            if (e == null) {
                n = 1;
            } else {
                Integer n2 = e;
                Integer n3 = e = Integer.valueOf(e + 1);
                n = n2;
            }
            return n;
        });
        return this.checked;
    }
}

