/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.settings;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.DeletionPolicy;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class AddressSettingsTest
extends ActiveMQTestBase {
    @Test
    public void testDefaults() {
        AddressSettings addressSettings = new AddressSettings();
        Assert.assertEquals(null, (Object)addressSettings.getDeadLetterAddress());
        Assert.assertEquals(null, (Object)addressSettings.getExpiryAddress());
        Assert.assertEquals((long)10L, (long)addressSettings.getMaxDeliveryAttempts());
        Assert.assertEquals((long)addressSettings.getMaxSizeBytes(), (long)-1L);
        Assert.assertEquals((long)0xA00000L, (long)addressSettings.getPageSizeBytes());
        Assert.assertEquals((long)0L, (long)addressSettings.getMessageCounterHistoryDayLimit());
        Assert.assertEquals((long)0L, (long)addressSettings.getRedeliveryDelay());
        Assert.assertEquals((double)1.0, (double)addressSettings.getRedeliveryMultiplier(), (double)1.0E-6);
        Assert.assertEquals((long)-1L, (long)addressSettings.getSlowConsumerThreshold());
        Assert.assertEquals((Object)AddressSettings.DEFAULT_SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT, (Object)addressSettings.getSlowConsumerThresholdMeasurementUnit());
        Assert.assertEquals((long)5L, (long)addressSettings.getSlowConsumerCheckPeriod());
        Assert.assertEquals((Object)AddressSettings.DEFAULT_SLOW_CONSUMER_POLICY, (Object)addressSettings.getSlowConsumerPolicy());
        Assert.assertEquals((Object)true, (Object)addressSettings.isAutoCreateJmsQueues());
        Assert.assertEquals((Object)true, (Object)addressSettings.isAutoDeleteJmsQueues());
        Assert.assertEquals((Object)true, (Object)addressSettings.isAutoCreateJmsTopics());
        Assert.assertEquals((Object)true, (Object)addressSettings.isAutoDeleteJmsTopics());
        Assert.assertEquals((Object)true, (Object)addressSettings.isAutoCreateQueues());
        Assert.assertEquals((Object)true, (Object)addressSettings.isAutoDeleteQueues());
        Assert.assertEquals((Object)true, (Object)addressSettings.isAutoCreateAddresses());
        Assert.assertEquals((Object)true, (Object)addressSettings.isAutoDeleteAddresses());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers(), (Object)addressSettings.isDefaultPurgeOnNoConsumers());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers(), (Object)addressSettings.getDefaultMaxConsumers());
    }

    @Test
    public void testSingleMerge() {
        AddressSettings addressSettings = new AddressSettings();
        AddressSettings addressSettingsToMerge = new AddressSettings();
        SimpleString DLQ = new SimpleString("testDLQ");
        SimpleString exp = new SimpleString("testExpiryQueue");
        addressSettingsToMerge.setDeadLetterAddress(DLQ);
        addressSettingsToMerge.setExpiryAddress(exp);
        addressSettingsToMerge.setMaxDeliveryAttempts(1000);
        addressSettingsToMerge.setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP);
        addressSettingsToMerge.setMaxSizeBytes(1001L);
        addressSettingsToMerge.setMaxSizeMessages(101L);
        addressSettingsToMerge.setMessageCounterHistoryDayLimit(1002);
        addressSettingsToMerge.setRedeliveryDelay(1003L);
        addressSettingsToMerge.setPageSizeBytes(1004);
        addressSettingsToMerge.setMaxSizeBytesRejectThreshold(10240L);
        addressSettingsToMerge.setConfigDeleteDiverts(DeletionPolicy.FORCE);
        addressSettingsToMerge.setExpiryDelay(Long.valueOf(999L));
        addressSettingsToMerge.setMinExpiryDelay(Long.valueOf(888L));
        addressSettingsToMerge.setMaxExpiryDelay(Long.valueOf(777L));
        addressSettings.merge(addressSettingsToMerge);
        Assert.assertEquals((Object)addressSettings.getDeadLetterAddress(), (Object)DLQ);
        Assert.assertEquals((Object)addressSettings.getExpiryAddress(), (Object)exp);
        Assert.assertEquals((long)addressSettings.getMaxDeliveryAttempts(), (long)1000L);
        Assert.assertEquals((long)addressSettings.getMaxSizeBytes(), (long)1001L);
        Assert.assertEquals((long)addressSettings.getMaxSizeMessages(), (long)101L);
        Assert.assertEquals((long)addressSettings.getMessageCounterHistoryDayLimit(), (long)1002L);
        Assert.assertEquals((long)addressSettings.getRedeliveryDelay(), (long)1003L);
        Assert.assertEquals((long)addressSettings.getPageSizeBytes(), (long)1004L);
        Assert.assertEquals((Object)AddressFullMessagePolicy.DROP, (Object)addressSettings.getAddressFullMessagePolicy());
        Assert.assertEquals((long)addressSettings.getMaxSizeBytesRejectThreshold(), (long)10240L);
        Assert.assertEquals((Object)DeletionPolicy.FORCE, (Object)addressSettings.getConfigDeleteDiverts());
        Assert.assertEquals((Object)999L, (Object)addressSettings.getExpiryDelay());
        Assert.assertEquals((Object)888L, (Object)addressSettings.getMinExpiryDelay());
        Assert.assertEquals((Object)777L, (Object)addressSettings.getMaxExpiryDelay());
    }

    @Test
    public void testMultipleMerge() {
        AddressSettings addressSettings = new AddressSettings();
        AddressSettings addressSettingsToMerge = new AddressSettings();
        SimpleString DLQ = new SimpleString("testDLQ");
        SimpleString exp = new SimpleString("testExpiryQueue");
        addressSettingsToMerge.setDeadLetterAddress(DLQ);
        addressSettingsToMerge.setExpiryAddress(exp);
        addressSettingsToMerge.setMaxDeliveryAttempts(1000);
        addressSettingsToMerge.setMaxSizeBytes(1001L);
        addressSettingsToMerge.setMessageCounterHistoryDayLimit(1002);
        addressSettingsToMerge.setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP);
        addressSettingsToMerge.setMaxSizeBytesRejectThreshold(10240L);
        addressSettings.merge(addressSettingsToMerge);
        AddressSettings addressSettingsToMerge2 = new AddressSettings();
        SimpleString exp2 = new SimpleString("testExpiryQueue2");
        addressSettingsToMerge2.setExpiryAddress(exp2);
        addressSettingsToMerge2.setMaxSizeBytes(2001L);
        addressSettingsToMerge2.setRedeliveryDelay(2003L);
        addressSettingsToMerge2.setRedeliveryMultiplier(2.5);
        addressSettings.merge(addressSettingsToMerge2);
        Assert.assertEquals((Object)addressSettings.getDeadLetterAddress(), (Object)DLQ);
        Assert.assertEquals((Object)addressSettings.getExpiryAddress(), (Object)exp);
        Assert.assertEquals((long)addressSettings.getMaxDeliveryAttempts(), (long)1000L);
        Assert.assertEquals((long)addressSettings.getMaxSizeBytes(), (long)1001L);
        Assert.assertEquals((long)addressSettings.getMessageCounterHistoryDayLimit(), (long)1002L);
        Assert.assertEquals((long)addressSettings.getRedeliveryDelay(), (long)2003L);
        Assert.assertEquals((double)addressSettings.getRedeliveryMultiplier(), (double)2.5, (double)1.0E-6);
        Assert.assertEquals((Object)AddressFullMessagePolicy.DROP, (Object)addressSettings.getAddressFullMessagePolicy());
        Assert.assertEquals((long)addressSettings.getMaxSizeBytesRejectThreshold(), (long)10240L);
    }

    @Test
    public void testMultipleMergeAll() {
        AddressSettings addressSettings = new AddressSettings();
        AddressSettings addressSettingsToMerge = new AddressSettings();
        SimpleString DLQ = new SimpleString("testDLQ");
        SimpleString exp = new SimpleString("testExpiryQueue");
        addressSettingsToMerge.setDeadLetterAddress(DLQ);
        addressSettingsToMerge.setExpiryAddress(exp);
        addressSettingsToMerge.setMaxSizeBytes(1001L);
        addressSettingsToMerge.setRedeliveryDelay(1003L);
        addressSettingsToMerge.setRedeliveryMultiplier(1.0);
        addressSettingsToMerge.setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP);
        addressSettings.merge(addressSettingsToMerge);
        AddressSettings addressSettingsToMerge2 = new AddressSettings();
        SimpleString exp2 = new SimpleString("testExpiryQueue2");
        SimpleString DLQ2 = new SimpleString("testDlq2");
        addressSettingsToMerge2.setExpiryAddress(exp2);
        addressSettingsToMerge2.setDeadLetterAddress(DLQ2);
        addressSettingsToMerge2.setMaxDeliveryAttempts(2000);
        addressSettingsToMerge2.setMaxSizeBytes(2001L);
        addressSettingsToMerge2.setMessageCounterHistoryDayLimit(2002);
        addressSettingsToMerge2.setRedeliveryDelay(2003L);
        addressSettingsToMerge2.setRedeliveryMultiplier(2.0);
        addressSettingsToMerge2.setMaxRedeliveryDelay(5000L);
        addressSettingsToMerge.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.merge(addressSettingsToMerge2);
        Assert.assertEquals((Object)addressSettings.getDeadLetterAddress(), (Object)DLQ);
        Assert.assertEquals((Object)addressSettings.getExpiryAddress(), (Object)exp);
        Assert.assertEquals((long)addressSettings.getMaxDeliveryAttempts(), (long)2000L);
        Assert.assertEquals((long)addressSettings.getMaxSizeBytes(), (long)1001L);
        Assert.assertEquals((long)addressSettings.getMessageCounterHistoryDayLimit(), (long)2002L);
        Assert.assertEquals((long)addressSettings.getRedeliveryDelay(), (long)1003L);
        Assert.assertEquals((double)addressSettings.getRedeliveryMultiplier(), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((long)addressSettings.getMaxRedeliveryDelay(), (long)5000L);
        Assert.assertEquals((Object)AddressFullMessagePolicy.DROP, (Object)addressSettings.getAddressFullMessagePolicy());
    }
}

