/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.settings;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.HierarchicalRepositoryChangeListener;
import org.apache.activemq.artemis.core.settings.Mergeable;
import org.apache.activemq.artemis.core.settings.impl.HierarchicalObjectRepository;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RepositoryTest
extends ActiveMQTestBase {
    HierarchicalRepository<HashSet<Role>> securityRepository;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.securityRepository = new HierarchicalObjectRepository();
    }

    @Test
    public void testDefault() {
        this.securityRepository.setDefault(new HashSet());
        HashSet roles = (HashSet)this.securityRepository.getMatch("queues.something");
        Assert.assertEquals((long)roles.size(), (long)0L);
    }

    @Test
    public void testMatchingDocs() throws Throwable {
        HierarchicalObjectRepository repo = new HierarchicalObjectRepository();
        repo.addMatch("a.b.#", (Object)"ab#");
        repo.addMatch("a.b.d.#", (Object)"abd#");
        repo.addMatch("#", (Object)"root");
        Assert.assertEquals((Object)"ab#", (Object)repo.getMatch("a.b"));
        Assert.assertEquals((Object)"ab#", (Object)repo.getMatch("a.b.c"));
        Assert.assertEquals((Object)"abd#", (Object)repo.getMatch("a.b.d.lll"));
        Assert.assertEquals((Object)"root", (Object)repo.getMatch("z.z.z.z.z"));
        Assert.assertEquals((Object)"root", (Object)repo.getMatch("a.babc"));
        Assert.assertEquals((Object)"ab#", (Object)repo.getMatch("a.b.dabc"));
        Assert.assertEquals((Object)"abd#", (Object)repo.getMatch("a.b.d"));
    }

    @Test
    public void testCacheWithWildcards() throws Throwable {
        HierarchicalObjectRepository repo = new HierarchicalObjectRepository();
        repo.addMatch("#", (Object)"root");
        Assert.assertEquals((Object)"root", (Object)repo.getMatch("b"));
        repo.addMatch("b", (Object)"leaf");
        Assert.assertEquals((Object)"leaf", (Object)repo.getMatch("b"));
    }

    @Test
    public void testMultipleMatchesHasRightOrder() {
        HierarchicalObjectRepository repository = new HierarchicalObjectRepository();
        repository.addMatch("a.b.c.d.e.f", (Object)"a.b.c.d.e.f");
        repository.addMatch("a.b.c.d.e.*", (Object)"a.b.c.d.e.*");
        repository.addMatch("a.*.*.*.*.*", (Object)"a.*.*.*.*.*");
        repository.addMatch("*.b.c.d.*.f", (Object)"*.b.c.d.*.f");
        repository.addMatch("*.b.*.d.*.f", (Object)"*.b.*.d.*.f");
        repository.addMatch("a.b.c.d.e.#", (Object)"a.b.c.d.e.#");
        String val = (String)repository.getMatch("a.b.c.d.e.f");
        Assert.assertEquals((Object)"a.b.c.d.e.f", (Object)val);
        val = (String)repository.getMatch("a.b.c.d.e.x");
        Assert.assertEquals((Object)"a.b.c.d.e.*", (Object)val);
        val = (String)repository.getMatch("a.b.x.d.x.f");
        Assert.assertEquals((Object)"a.*.*.*.*.*", (Object)val);
        val = (String)repository.getMatch("x.b.c.d.e.f");
        Assert.assertEquals((Object)"*.b.c.d.*.f", (Object)val);
        val = (String)repository.getMatch("x.b.x.d.e.f");
        Assert.assertEquals((Object)"*.b.*.d.*.f", (Object)val);
        val = (String)repository.getMatch("a.b.c.d.e.f.g");
        Assert.assertEquals((Object)"a.b.c.d.e.#", (Object)val);
    }

    @Test
    public void testMatchingDocsCustomUnderscorDelimiter() throws Throwable {
        WildcardConfiguration wildcardConfiguration = new WildcardConfiguration();
        wildcardConfiguration.setDelimiter('_');
        HierarchicalObjectRepository repo = new HierarchicalObjectRepository(wildcardConfiguration);
        repo.addMatch("a_b_#", (Object)"ab#");
        repo.addMatch("a_b_d_#", (Object)"abd#");
        repo.addMatch("#", (Object)"root");
        Assert.assertEquals((Object)"ab#", (Object)repo.getMatch("a_b"));
        Assert.assertEquals((Object)"ab#", (Object)repo.getMatch("a_b_c"));
        Assert.assertEquals((Object)"abd#", (Object)repo.getMatch("a_b_d_lll"));
        Assert.assertEquals((Object)"root", (Object)repo.getMatch("z_z_z_z_z"));
        Assert.assertEquals((Object)"root", (Object)repo.getMatch("a_babc"));
        Assert.assertEquals((Object)"ab#", (Object)repo.getMatch("a_b_dabc"));
        Assert.assertEquals((Object)"abd#", (Object)repo.getMatch("a_b_d"));
    }

    @Test
    public void testMatchingDocsCustomForwardSlashDelimiter() throws Throwable {
        WildcardConfiguration wildcardConfiguration = new WildcardConfiguration();
        wildcardConfiguration.setDelimiter('/');
        HierarchicalObjectRepository repo = new HierarchicalObjectRepository(wildcardConfiguration);
        repo.addMatch("a/b/#", (Object)"ab#");
        repo.addMatch("a/b/d/#", (Object)"abd#");
        repo.addMatch("#", (Object)"root");
        Assert.assertEquals((Object)"ab#", (Object)repo.getMatch("a/b"));
        Assert.assertEquals((Object)"ab#", (Object)repo.getMatch("a/b/c"));
        Assert.assertEquals((Object)"abd#", (Object)repo.getMatch("a/b/d/lll"));
        Assert.assertEquals((Object)"root", (Object)repo.getMatch("z/z/z/z/z"));
        Assert.assertEquals((Object)"root", (Object)repo.getMatch("a/babc"));
        Assert.assertEquals((Object)"ab#", (Object)repo.getMatch("a/b/dabc"));
        Assert.assertEquals((Object)"abd#", (Object)repo.getMatch("a/b/d"));
    }

    @Test
    public void testSingleMatch() {
        this.securityRepository.addMatch("queues.*", new HashSet());
        HashSet hashSet = (HashSet)this.securityRepository.getMatch("queues.something");
        Assert.assertEquals((long)hashSet.size(), (long)0L);
    }

    @Test
    public void testSingletwo() {
        this.securityRepository.addMatch("queues.another.aq.*", new HashSet());
        HashSet<Role> roles = new HashSet<Role>(2);
        roles.add(new Role("test1", true, true, true, true, true, true, true, true, true, true));
        roles.add(new Role("test2", true, true, true, true, true, true, true, true, true, true));
        this.securityRepository.addMatch("queues.aq", roles);
        HashSet<Role> roles2 = new HashSet<Role>(2);
        roles2.add(new Role("test1", true, true, true, true, true, true, true, true, true, true));
        roles2.add(new Role("test2", true, true, true, true, true, true, true, true, true, true));
        roles2.add(new Role("test3", true, true, true, true, true, true, true, true, true, true));
        this.securityRepository.addMatch("queues.another.andanother", roles2);
        HashSet hashSet = (HashSet)this.securityRepository.getMatch("queues.another.andanother");
        Assert.assertEquals((long)hashSet.size(), (long)3L);
    }

    @Test
    public void testWithoutWildcard() {
        this.securityRepository.addMatch("queues.1.*", new HashSet());
        HashSet<Role> roles = new HashSet<Role>(2);
        roles.add(new Role("test1", true, true, true, true, true, true, true, true, true, true));
        roles.add(new Role("test2", true, true, true, true, true, true, true, true, true, true));
        this.securityRepository.addMatch("queues.2.aq", roles);
        HashSet hashSet = (HashSet)this.securityRepository.getMatch("queues.2.aq");
        Assert.assertEquals((long)hashSet.size(), (long)2L);
    }

    @Test
    public void testMultipleWildcards() {
        HierarchicalObjectRepository repository = new HierarchicalObjectRepository();
        repository.addMatch("#", (Object)"#");
        repository.addMatch("a", (Object)"a");
        repository.addMatch("a.#", (Object)"a.#");
        repository.addMatch("a.*", (Object)"a.*");
        repository.addMatch("a.b.c", (Object)"a.b.c");
        repository.addMatch("a.*.c", (Object)"a.*.c");
        repository.addMatch("a.d.c", (Object)"a.d.c");
        repository.addMatch("a.b.#", (Object)"a.b.#");
        repository.addMatch("a.b", (Object)"a.b");
        repository.addMatch("a.b.c.#", (Object)"a.b.c.#");
        repository.addMatch("a.b.c.d", (Object)"a.b.c.d");
        repository.addMatch("a.*.*.d", (Object)"a.*.*.d");
        repository.addMatch("a.*.d.#", (Object)"a.*.d.#");
        String val = (String)repository.getMatch("a");
        Assert.assertEquals((Object)"a", (Object)val);
        val = (String)repository.getMatch("a.b");
        Assert.assertEquals((Object)"a.b", (Object)val);
        val = (String)repository.getMatch("a.x");
        Assert.assertEquals((Object)"a.*", (Object)val);
        val = (String)repository.getMatch("a.b.x");
        Assert.assertEquals((Object)"a.b.#", (Object)val);
        val = (String)repository.getMatch("a.b.c");
        Assert.assertEquals((Object)"a.b.c", (Object)val);
        val = (String)repository.getMatch("a.d.c");
        Assert.assertEquals((Object)"a.d.c", (Object)val);
        val = (String)repository.getMatch("a.x.c");
        Assert.assertEquals((Object)"a.*.c", (Object)val);
        val = (String)repository.getMatch("a.b.c.d");
        Assert.assertEquals((Object)"a.b.c.d", (Object)val);
        val = (String)repository.getMatch("a.x.c.d");
        Assert.assertEquals((Object)"a.*.*.d", (Object)val);
        val = (String)repository.getMatch("a.b.x.d");
        Assert.assertEquals((Object)"a.*.*.d", (Object)val);
        val = (String)repository.getMatch("a.d.x.d");
        Assert.assertEquals((Object)"a.*.*.d", (Object)val);
        val = (String)repository.getMatch("a.d.d.g");
        Assert.assertEquals((Object)"a.*.d.#", (Object)val);
        val = (String)repository.getMatch("zzzz.z.z.z.d.r.g.f.sd.s.fsdfd.fsdfs");
        Assert.assertEquals((Object)"#", (Object)val);
    }

    @Test
    public void testRepositoryMerge() {
        HierarchicalObjectRepository repository = new HierarchicalObjectRepository();
        repository.addMatch("#", (Object)new DummyMergeable(1));
        repository.addMatch("a.#", (Object)new DummyMergeable(2));
        repository.addMatch("b.#", (Object)new DummyMergeable(3));
        repository.addMatch("a.b.#", (Object)new DummyMergeable(4));
        repository.addMatch("b.c.#", (Object)new DummyMergeable(5));
        repository.addMatch("a.b.c.#", (Object)new DummyMergeable(6));
        repository.addMatch("a.b.*.d", (Object)new DummyMergeable(7));
        repository.addMatch("a.b.c.*", (Object)new DummyMergeable(8));
        repository.getMatch("a.b.c.d");
        Assert.assertEquals((long)5L, (long)DummyMergeable.timesMerged);
        Assert.assertTrue((boolean)DummyMergeable.contains(1));
        Assert.assertTrue((boolean)DummyMergeable.contains(2));
        Assert.assertTrue((boolean)DummyMergeable.contains(4));
        Assert.assertTrue((boolean)DummyMergeable.contains(7));
        Assert.assertTrue((boolean)DummyMergeable.contains(8));
        DummyMergeable.reset();
        repository.getMatch("a.b.c");
        Assert.assertEquals((long)3L, (long)DummyMergeable.timesMerged);
        Assert.assertTrue((boolean)DummyMergeable.contains(1));
        Assert.assertTrue((boolean)DummyMergeable.contains(2));
        Assert.assertTrue((boolean)DummyMergeable.contains(4));
        DummyMergeable.reset();
        repository.getMatch("z");
        Assert.assertEquals((long)0L, (long)DummyMergeable.timesMerged);
        DummyMergeable.reset();
    }

    @Test
    public void testAddListener() {
        HierarchicalObjectRepository repository = new HierarchicalObjectRepository();
        repository.addMatch("#", (Object)"1");
        repository.addMatch("B", (Object)"2");
        final AtomicInteger called = new AtomicInteger(0);
        repository.registerListener(new HierarchicalRepositoryChangeListener(){

            public void onChange() {
                called.incrementAndGet();
            }
        });
        RepositoryTest.assertEquals((long)1L, (long)called.get());
        repository.disableListeners();
        repository.addMatch("C", (Object)"3");
        RepositoryTest.assertEquals((long)1L, (long)called.get());
        repository.enableListeners();
        RepositoryTest.assertEquals((long)2L, (long)called.get());
        repository.addMatch("D", (Object)"4");
        RepositoryTest.assertEquals((long)3L, (long)called.get());
        repository.removeMatch("D");
        RepositoryTest.assertEquals((long)4L, (long)called.get());
        repository.disableListeners();
        repository.removeMatch("C");
        RepositoryTest.assertEquals((long)4L, (long)called.get());
    }

    @Test
    public void testIllegalMatches() {
        HierarchicalObjectRepository repository = new HierarchicalObjectRepository();
        try {
            repository.addMatch("hjhjhjhjh.#.hhh", (Object)"test");
            RepositoryTest.fail((String)"expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            repository.addMatch(null, (Object)"test");
            RepositoryTest.fail((String)"expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static class DummyMergeable
    implements Mergeable {
        static int timesMerged = 0;
        static ArrayList<Integer> merged = new ArrayList();
        private final Integer id;

        static void reset() {
            timesMerged = 0;
            merged = new ArrayList();
        }

        static boolean contains(Integer i) {
            return merged.contains(i);
        }

        DummyMergeable(Integer id) {
            this.id = id;
        }

        public void merge(Object merged) {
            ++timesMerged;
            DummyMergeable.merged.add(this.id);
            DummyMergeable.merged.add(((DummyMergeable)merged).id);
        }
    }
}

