/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.transaction.impl;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.persistence.AddressBindingInfo;
import org.apache.activemq.artemis.core.persistence.AddressQueueStatus;
import org.apache.activemq.artemis.core.persistence.GroupingInfo;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.QueueBindingInfo;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.PersistedAddressSetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedBridgeConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedConnector;
import org.apache.activemq.artemis.core.persistence.config.PersistedDivertConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedKeyValuePair;
import org.apache.activemq.artemis.core.persistence.config.PersistedRole;
import org.apache.activemq.artemis.core.persistence.config.PersistedSecuritySetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedUser;
import org.apache.activemq.artemis.core.persistence.impl.PageCountPending;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.server.group.impl.GroupBinding;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionImplTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testTimeoutAndThenCommitWithARollback() throws Exception {
        TransactionImpl tx = new TransactionImpl((Xid)this.newXID(), (StorageManager)new FakeSM(), 10);
        Assert.assertTrue((boolean)tx.hasTimedOut(System.currentTimeMillis() + 60000L, 10));
        final AtomicInteger commit = new AtomicInteger(0);
        final AtomicInteger rollback = new AtomicInteger(0);
        tx.addOperation(new TransactionOperation(){

            public void beforePrepare(Transaction tx) throws Exception {
            }

            public void afterPrepare(Transaction tx) {
            }

            public void beforeCommit(Transaction tx) throws Exception {
            }

            public void afterCommit(Transaction tx) {
                logger.debug("commit...");
                commit.incrementAndGet();
            }

            public void beforeRollback(Transaction tx) throws Exception {
            }

            public void afterRollback(Transaction tx) {
                logger.debug("rollback...");
                rollback.incrementAndGet();
            }

            public List<MessageReference> getRelatedMessageReferences() {
                return null;
            }

            public List<MessageReference> getListOnConsumer(long consumerID) {
                return null;
            }
        });
        for (int i = 0; i < 2; ++i) {
            try {
                tx.commit();
                Assert.fail((String)"Exception expected!");
                continue;
            }
            catch (ActiveMQException activeMQException) {
                // empty catch block
            }
        }
        tx.rollback();
        Assert.assertEquals((long)0L, (long)commit.get());
        Assert.assertEquals((long)1L, (long)rollback.get());
    }

    @Test
    public void testTimeoutThenRollbackWithRollback() throws Exception {
        TransactionImpl tx = new TransactionImpl((Xid)this.newXID(), (StorageManager)new FakeSM(), 10);
        Assert.assertTrue((boolean)tx.hasTimedOut(System.currentTimeMillis() + 60000L, 10));
        final AtomicInteger commit = new AtomicInteger(0);
        final AtomicInteger rollback = new AtomicInteger(0);
        tx.addOperation(new TransactionOperation(){

            public void beforePrepare(Transaction tx) throws Exception {
            }

            public void afterPrepare(Transaction tx) {
            }

            public void beforeCommit(Transaction tx) throws Exception {
            }

            public void afterCommit(Transaction tx) {
                logger.debug("commit...");
                commit.incrementAndGet();
            }

            public void beforeRollback(Transaction tx) throws Exception {
            }

            public void afterRollback(Transaction tx) {
                logger.debug("rollback...");
                rollback.incrementAndGet();
            }

            public List<MessageReference> getRelatedMessageReferences() {
                return null;
            }

            public List<MessageReference> getListOnConsumer(long consumerID) {
                return null;
            }
        });
        tx.rollback();
        tx.markAsRollbackOnly(new ActiveMQException("rollback only again"));
        tx.rollback();
        Assert.assertEquals((long)0L, (long)commit.get());
        Assert.assertEquals((long)1L, (long)rollback.get());
    }

    @Test
    public void testAlreadyCommitted() throws Exception {
        TransactionImpl tx = new TransactionImpl((Xid)this.newXID(), (StorageManager)new FakeSM(), 10);
        final AtomicInteger commit = new AtomicInteger(0);
        final AtomicInteger rollback = new AtomicInteger(0);
        tx.commit();
        tx.addOperation(new TransactionOperation(){

            public void beforePrepare(Transaction tx) throws Exception {
            }

            public void afterPrepare(Transaction tx) {
            }

            public void beforeCommit(Transaction tx) throws Exception {
            }

            public void afterCommit(Transaction tx) {
                commit.incrementAndGet();
            }

            public void beforeRollback(Transaction tx) throws Exception {
            }

            public void afterRollback(Transaction tx) {
                rollback.incrementAndGet();
            }

            public List<MessageReference> getRelatedMessageReferences() {
                return null;
            }

            public List<MessageReference> getListOnConsumer(long consumerID) {
                return null;
            }
        });
        Assert.assertEquals((long)1L, (long)commit.get());
        Assert.assertEquals((long)0L, (long)rollback.get());
    }

    @Test
    public void testAlreadyRolledBack() throws Exception {
        TransactionImpl tx = new TransactionImpl((Xid)this.newXID(), (StorageManager)new FakeSM(), 10);
        final AtomicInteger rollback = new AtomicInteger(0);
        final AtomicInteger commit = new AtomicInteger(0);
        tx.rollback();
        tx.addOperation(new TransactionOperation(){

            public void beforePrepare(Transaction tx) throws Exception {
            }

            public void afterPrepare(Transaction tx) {
            }

            public void beforeCommit(Transaction tx) throws Exception {
            }

            public void afterCommit(Transaction tx) {
                commit.incrementAndGet();
            }

            public void beforeRollback(Transaction tx) throws Exception {
            }

            public void afterRollback(Transaction tx) {
                rollback.incrementAndGet();
            }

            public List<MessageReference> getRelatedMessageReferences() {
                return null;
            }

            public List<MessageReference> getListOnConsumer(long consumerID) {
                return null;
            }
        });
        Assert.assertEquals((long)0L, (long)commit.get());
        Assert.assertEquals((long)1L, (long)rollback.get());
    }

    class FakeSM
    implements StorageManager {
        FakeSM() {
        }

        public OperationContext getContext() {
            return null;
        }

        public void lineUpContext() {
        }

        public ArtemisCloseable closeableReadLock() {
            return () -> {};
        }

        public void criticalError(Throwable error) {
            error.printStackTrace();
        }

        public OperationContext newContext(Executor executor) {
            return null;
        }

        public OperationContext newSingleThreadContext() {
            return null;
        }

        public void setContext(OperationContext context) {
        }

        public void updateQueueBinding(long tx, Binding binding) throws Exception {
        }

        public void stop(boolean ioCriticalError, boolean sendFailover) throws Exception {
        }

        public void deleteLargeMessageBody(LargeServerMessage largeServerMessage) throws ActiveMQException {
        }

        public void largeMessageClosed(LargeServerMessage largeServerMessage) throws ActiveMQException {
        }

        public void addBytesToLargeMessage(SequentialFile file, long messageId, ActiveMQBuffer bytes) throws Exception {
        }

        public void pageClosed(SimpleString storeName, long pageNumber) {
        }

        public void pageDeleted(SimpleString storeName, long pageNumber) {
        }

        public long storeQueueStatus(long queueID, AddressQueueStatus status) throws Exception {
            return 0L;
        }

        public void deleteQueueStatus(long recordID) throws Exception {
        }

        public void pageWrite(PagedMessage message, long pageNumber) {
        }

        public void afterCompleteOperations(IOCallback run) {
            run.done();
        }

        public void afterStoreOperations(IOCallback run) {
            run.done();
        }

        public boolean waitOnOperations(long timeout) throws Exception {
            return false;
        }

        public void waitOnOperations() throws Exception {
        }

        public ByteBuffer allocateDirectBuffer(int size) {
            return null;
        }

        public void freeDirectBuffer(ByteBuffer buffer) {
        }

        public void clearContext() {
        }

        public void confirmPendingLargeMessageTX(Transaction transaction, long messageID, long recordID) throws Exception {
        }

        public void injectMonitor(FileStoreMonitor monitor) throws Exception {
        }

        public void confirmPendingLargeMessage(long recordID) throws Exception {
        }

        public void storeMessage(Message message) throws Exception {
        }

        public void storeReference(long queueID, long messageID, boolean last) throws Exception {
        }

        public void deleteMessage(long messageID) throws Exception {
        }

        public void storeAcknowledge(long queueID, long messageID) throws Exception {
        }

        public void storeCursorAcknowledge(long queueID, PagePosition position) throws Exception {
        }

        public void updateDeliveryCount(MessageReference ref) throws Exception {
        }

        public void updateScheduledDeliveryTime(MessageReference ref) throws Exception {
        }

        public void storeDuplicateID(SimpleString address, byte[] duplID, long recordID) throws Exception {
        }

        public void deleteDuplicateID(long recordID) throws Exception {
        }

        public void storeMessageTransactional(long txID, Message message) throws Exception {
        }

        public void storeReferenceTransactional(long txID, long queueID, long messageID) throws Exception {
        }

        public void storeAcknowledgeTransactional(long txID, long queueID, long messageID) throws Exception {
        }

        public void storeCursorAcknowledgeTransactional(long txID, long queueID, PagePosition position) throws Exception {
        }

        public void deleteCursorAcknowledgeTransactional(long txID, long ackID) throws Exception {
        }

        public void deleteCursorAcknowledge(long ackID) throws Exception {
        }

        public void storePageCompleteTransactional(long txID, long queueID, PagePosition position) throws Exception {
        }

        public void deletePageComplete(long ackID) throws Exception {
        }

        public void updateScheduledDeliveryTimeTransactional(long txID, MessageReference ref) throws Exception {
        }

        public void storeDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
        }

        public void updateDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
        }

        public void deleteDuplicateIDTransactional(long txID, long recordID) throws Exception {
        }

        public LargeServerMessage createLargeMessage() {
            return null;
        }

        public LargeServerMessage createLargeMessage(long id, Message message) throws Exception {
            return null;
        }

        public LargeServerMessage largeMessageCreated(long id, LargeServerMessage largeMessage) throws Exception {
            return null;
        }

        public SequentialFile createFileForLargeMessage(long messageID, StorageManager.LargeMessageExtension extension) {
            return null;
        }

        public void prepare(long txID, Xid xid) throws Exception {
        }

        public void commit(long txID) throws Exception {
        }

        public void commit(long txID, boolean lineUpContext) throws Exception {
        }

        public void rollback(long txID) throws Exception {
        }

        public void rollbackBindings(long txID) throws Exception {
        }

        public void commitBindings(long txID) throws Exception {
        }

        public void storePageTransaction(long txID, PageTransactionInfo pageTransaction) throws Exception {
        }

        public void updatePageTransaction(long txID, PageTransactionInfo pageTransaction, int depage) throws Exception {
        }

        public void deletePageTransactional(long recordID) throws Exception {
        }

        public JournalLoadInformation loadMessageJournal(PostOffice postOffice, PagingManager pagingManager, ResourceManager resourceManager, Map<Long, QueueBindingInfo> queueInfos, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, Set<Pair<Long, Long>> pendingLargeMessages, Set<Long> largeMessagesInFolder, List<PageCountPending> pendingNonTXPageCounter, JournalLoader journalLoader) throws Exception {
            return null;
        }

        public long storeHeuristicCompletion(Xid xid, boolean isCommit) throws Exception {
            return 0L;
        }

        public void deleteHeuristicCompletion(long id) throws Exception {
        }

        public void addQueueBinding(long tx, Binding binding) throws Exception {
        }

        public void deleteQueueBinding(long tx, long queueBindingID) throws Exception {
        }

        public void addAddressBinding(long tx, AddressInfo addressInfo) throws Exception {
        }

        public void deleteAddressBinding(long tx, long addressBindingID) throws Exception {
        }

        public JournalLoadInformation loadBindingJournal(List<QueueBindingInfo> queueBindingInfos, List<GroupingInfo> groupingInfos, List<AddressBindingInfo> addressBindingInfos) throws Exception {
            return null;
        }

        public void addGrouping(GroupBinding groupBinding) throws Exception {
        }

        public void deleteGrouping(long tx, GroupBinding groupBinding) throws Exception {
        }

        public void storeAddressSetting(PersistedAddressSetting addressSetting) throws Exception {
        }

        public void deleteAddressSetting(SimpleString addressMatch) throws Exception {
        }

        public List<PersistedAddressSetting> recoverAddressSettings() throws Exception {
            return null;
        }

        public void storeSecuritySetting(PersistedSecuritySetting persistedRoles) throws Exception {
        }

        public void deleteSecuritySetting(SimpleString addressMatch) throws Exception {
        }

        public List<PersistedSecuritySetting> recoverSecuritySettings() throws Exception {
            return null;
        }

        public void storeDivertConfiguration(PersistedDivertConfiguration persistedDivertConfiguration) throws Exception {
        }

        public void deleteDivertConfiguration(String divertName) throws Exception {
        }

        public List<PersistedDivertConfiguration> recoverDivertConfigurations() {
            return null;
        }

        public void storeBridgeConfiguration(PersistedBridgeConfiguration persistedBridgeConfiguration) throws Exception {
        }

        public void deleteBridgeConfiguration(String bridgeName) throws Exception {
        }

        public List<PersistedBridgeConfiguration> recoverBridgeConfigurations() {
            return null;
        }

        public void storeConnector(PersistedConnector persistedConnector) throws Exception {
        }

        public void deleteConnector(String connectorName) throws Exception {
        }

        public List<PersistedConnector> recoverConnectors() {
            return null;
        }

        public void storeUser(PersistedUser persistedUser) throws Exception {
        }

        public void deleteUser(String username) throws Exception {
        }

        public Map<String, PersistedUser> getPersistedUsers() {
            return null;
        }

        public void storeRole(PersistedRole persistedRole) throws Exception {
        }

        public void deleteRole(String role) throws Exception {
        }

        public Map<String, PersistedRole> getPersistedRoles() {
            return null;
        }

        public void storeKeyValuePair(PersistedKeyValuePair persistedKeyValuePair) throws Exception {
        }

        public void deleteKeyValuePair(String mapId, String key) throws Exception {
        }

        public Map<String, PersistedKeyValuePair> getPersistedKeyValuePairs(String mapId) {
            return null;
        }

        public long storePageCounter(long txID, long queueID, long value, long size) throws Exception {
            return 0L;
        }

        public long storePendingCounter(long queueID, long pageID) throws Exception {
            return 0L;
        }

        public void deleteIncrementRecord(long txID, long recordID) throws Exception {
        }

        public void deletePageCounter(long txID, long recordID) throws Exception {
        }

        public void deletePendingPageCounter(long txID, long recordID) throws Exception {
        }

        public long storePageCounterInc(long txID, long queueID, int add, long size) throws Exception {
            return 0L;
        }

        public long storePageCounterInc(long queueID, int add, long size) throws Exception {
            return 0L;
        }

        public Journal getBindingsJournal() {
            return null;
        }

        public Journal getMessageJournal() {
            return null;
        }

        public void startReplication(ReplicationManager replicationManager, PagingManager pagingManager, String nodeID, boolean autoFailBack, long initialReplicationSyncTimeout) throws Exception {
        }

        public boolean addToPage(PagingStore store, Message msg, Transaction tx, RouteContextList listCtx) throws Exception {
            return false;
        }

        public void stopReplication() {
        }

        public void addBytesToLargeMessage(SequentialFile appendFile, long messageID, byte[] bytes) throws Exception {
        }

        public void storeID(long journalID, long id) throws Exception {
        }

        public void deleteID(long journalD) throws Exception {
        }

        public void persistIdGenerator() {
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
        }

        public boolean isStarted() {
            return false;
        }

        public long generateID() {
            return 0L;
        }

        public long getCurrentID() {
            return 0L;
        }

        public long storeAddressStatus(long addressID, AddressQueueStatus status) throws Exception {
            return 0L;
        }

        public void deleteAddressStatus(long recordID) throws Exception {
        }
    }
}

