/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsExchange;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.spi.core.security.jaas.HttpServerAuthenticator;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HttpServerAuthenticatorTest {
    private final HttpsExchange httpsExchange = (HttpsExchange)Mockito.mock(HttpsExchange.class);
    static final String loginConfigSystemPropName = "java.security.auth.login.config";

    @BeforeClass
    public static void setSystemProps() {
        String val;
        URL url = HttpServerAuthenticatorTest.class.getClassLoader().getResource("login.config");
        if (url != null && (val = url.getFile()) != null) {
            System.setProperty(loginConfigSystemPropName, val);
        }
    }

    @AfterClass
    public static void unsetSystemProps() {
        System.clearProperty(loginConfigSystemPropName);
        System.clearProperty("httpServerAuthenticator.realm");
        System.clearProperty("httpServerAuthenticator.requestSubjectAttribute");
    }

    @Test
    public void testGuestLogin() {
        System.setProperty("httpServerAuthenticator.realm", "GuestLogin");
        System.clearProperty("httpServerAuthenticator.requestSubjectAttribute");
        Object[] tracked = new Object[1];
        ((HttpsExchange)Mockito.doAnswer(invocationOnMock -> {
            tracked[0] = invocationOnMock.getArgument(1);
            return null;
        }).when((Object)this.httpsExchange)).setAttribute((String)ArgumentMatchers.any(String.class), ArgumentMatchers.any(Object.class));
        Mockito.when((Object)this.httpsExchange.getAttribute(HttpServerAuthenticator.DEFAULT_SUBJECT_ATTRIBUTE)).then(invocationOnMock -> tracked[0]);
        HttpServerAuthenticator underTest = new HttpServerAuthenticator();
        Authenticator.Result result = underTest.authenticate((HttpExchange)this.httpsExchange);
        Assert.assertTrue((boolean)(result instanceof Authenticator.Success));
        MatcherAssert.assertThat((Object)((Authenticator.Success)result).getPrincipal().getUsername(), (Matcher)CoreMatchers.is((Object)"foo"));
        Subject subject = (Subject)this.httpsExchange.getAttribute(HttpServerAuthenticator.DEFAULT_SUBJECT_ATTRIBUTE);
        MatcherAssert.assertThat(subject.getPrincipals(UserPrincipal.class), (Matcher)Matchers.hasSize((int)1));
        subject.getPrincipals(UserPrincipal.class).forEach(p -> MatcherAssert.assertThat((Object)p.getName(), (Matcher)CoreMatchers.is((Object)"foo")));
        Set<RolePrincipal> roles = subject.getPrincipals(RolePrincipal.class);
        MatcherAssert.assertThat(roles, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testBasicLogin() {
        System.setProperty("httpServerAuthenticator.realm", "PropertiesLogin");
        System.clearProperty("httpServerAuthenticator.requestSubjectAttribute");
        Headers headers = new Headers();
        headers.add("Authorization", "Basic " + Base64.getEncoder().encodeToString("first:secret".getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)this.httpsExchange.getRequestHeaders()).thenReturn((Object)headers);
        Object[] tracked = new Object[1];
        ((HttpsExchange)Mockito.doAnswer(invocationOnMock -> {
            tracked[0] = invocationOnMock.getArgument(1);
            return null;
        }).when((Object)this.httpsExchange)).setAttribute((String)ArgumentMatchers.any(String.class), ArgumentMatchers.any(Object.class));
        Mockito.when((Object)this.httpsExchange.getAttribute(HttpServerAuthenticator.DEFAULT_SUBJECT_ATTRIBUTE)).then(invocationOnMock -> tracked[0]);
        HttpServerAuthenticator underTest = new HttpServerAuthenticator();
        Authenticator.Result result = underTest.authenticate((HttpExchange)this.httpsExchange);
        Assert.assertTrue((boolean)(result instanceof Authenticator.Success));
        MatcherAssert.assertThat((Object)((Authenticator.Success)result).getPrincipal().getUsername(), (Matcher)CoreMatchers.is((Object)"first"));
        Subject subject = (Subject)this.httpsExchange.getAttribute(HttpServerAuthenticator.DEFAULT_SUBJECT_ATTRIBUTE);
        MatcherAssert.assertThat(subject.getPrincipals(UserPrincipal.class), (Matcher)Matchers.hasSize((int)1));
        subject.getPrincipals(UserPrincipal.class).forEach(p -> MatcherAssert.assertThat((Object)p.getName(), (Matcher)CoreMatchers.is((Object)"first")));
        Set<RolePrincipal> roles = subject.getPrincipals(RolePrincipal.class);
        MatcherAssert.assertThat(roles, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testNonBasic() {
        System.setProperty("httpServerAuthenticator.realm", "HttpServerAuthenticator");
        System.clearProperty("httpServerAuthenticator.requestSubjectAttribute");
        Headers headers = new Headers();
        headers.add("Authorization", "Bearer " + Base64.getEncoder().encodeToString("some-random-string".getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)this.httpsExchange.getRequestHeaders()).thenReturn((Object)headers);
        HttpServerAuthenticator underTest = new HttpServerAuthenticator();
        Authenticator.Result result = underTest.authenticate((HttpExchange)this.httpsExchange);
        Assert.assertTrue((boolean)(result instanceof Authenticator.Failure));
        Assert.assertNull((String)"no subject", (Object)this.httpsExchange.getAttribute(HttpServerAuthenticator.DEFAULT_SUBJECT_ATTRIBUTE));
        ((HttpsExchange)Mockito.verify((Object)this.httpsExchange, (VerificationMode)Mockito.times((int)1))).getRequestHeaders();
        ((HttpsExchange)Mockito.verify((Object)this.httpsExchange, (VerificationMode)Mockito.times((int)1))).getSSLSession();
    }
}

