/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.security.Principal;
import java.util.Collections;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.activemq.artemis.core.management.impl.ManagementRemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.ClientIDCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.JaasCallbackHandler;
import org.apache.activemq.artemis.spi.core.security.jaas.PrincipalsCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.junit.Assert;
import org.junit.Test;

public class JaasCallbackHandlerTest {
    @Test
    public void handlePasswordCallback() throws Exception {
        String password = "password";
        PasswordCallback passwordCallback = new PasswordCallback("prompt", false);
        new JaasCallbackHandler(null, "password", null).handle(new Callback[]{passwordCallback});
        Assert.assertEquals((Object)"password", (Object)new String(passwordCallback.getPassword()));
        new JaasCallbackHandler(null, null, null).handle(new Callback[]{passwordCallback});
        Assert.assertNull((Object)passwordCallback.getPassword());
    }

    @Test
    public void handleNameCallback() throws Exception {
        String username = "username";
        NameCallback nameCallback = new NameCallback("prompt");
        new JaasCallbackHandler("username", null, null).handle(new Callback[]{nameCallback});
        Assert.assertEquals((Object)"username", (Object)nameCallback.getName());
        new JaasCallbackHandler(null, null, null).handle(new Callback[]{nameCallback});
        Assert.assertNull((Object)nameCallback.getName());
    }

    @Test
    public void handleCertificateCallback() throws Exception {
        CertificateCallback certificateCallback = new CertificateCallback();
        new JaasCallbackHandler(null, null, null).handle(new Callback[]{certificateCallback});
        Assert.assertNull((Object)certificateCallback.getCertificates());
    }

    @Test
    public void handlePrincipalsCallback() throws Exception {
        PrincipalsCallback principalsCallback = new PrincipalsCallback();
        new JaasCallbackHandler(null, null, (RemotingConnection)new ManagementRemotingConnection()).handle(new Callback[]{principalsCallback});
        Assert.assertNull((Object)principalsCallback.getPeerPrincipals());
        UserPrincipal principal = new UserPrincipal("");
        ManagementRemotingConnection remotingConnection = new ManagementRemotingConnection((Principal)principal){
            final /* synthetic */ Principal val$principal;
            {
                this.val$principal = principal;
            }

            public Subject getSubject() {
                return new Subject(false, Collections.singleton(this.val$principal), Collections.emptySet(), Collections.emptySet());
            }
        };
        new JaasCallbackHandler(null, null, (RemotingConnection)remotingConnection).handle(new Callback[]{principalsCallback});
        Assert.assertArrayEquals((Object[])new Principal[]{principal}, (Object[])principalsCallback.getPeerPrincipals());
    }

    @Test
    public void handleClientIDCallback() throws Exception {
        String clientID = "clientID";
        ClientIDCallback clientIDCallback = new ClientIDCallback();
        ManagementRemotingConnection remotingConnection = new ManagementRemotingConnection(){

            public String getClientID() {
                return "clientID";
            }
        };
        new JaasCallbackHandler(null, null, (RemotingConnection)remotingConnection).handle(new Callback[]{clientIDCallback});
        Assert.assertEquals((Object)"clientID", (Object)clientIDCallback.getClientID());
        new JaasCallbackHandler(null, null, (RemotingConnection)new ManagementRemotingConnection()).handle(new Callback[]{clientIDCallback});
        Assert.assertNull((Object)clientIDCallback.getClientID());
    }

    @Test(expected=UnsupportedCallbackException.class)
    public void handleUnsupported() throws Exception {
        new JaasCallbackHandler(null, null, null).handle(new Callback[]{new TextInputCallback("prompt")});
    }
}

