/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.KubernetesLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.ServiceAccountPrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.TokenCallbackHandler;
import org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.client.KubernetesClient;
import org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.model.TokenReview;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class KubernetesLoginModuleTest {
    private final KubernetesClient client = (KubernetesClient)Mockito.mock(KubernetesClient.class);
    private final KubernetesLoginModule loginModule = new KubernetesLoginModule(this.client);
    private static final String TOKEN = "the_token";
    public static final String USERNAME = "system:serviceaccounts:some-ns:kermit";
    public static final String AUTH_JSON = "{\"status\": {\"authenticated\": true, \"user\": {  \"username\": \"system:serviceaccounts:some-ns:kermit\"}}}";
    public static final String AUTH_JSON_WITH_GROUPS = "{\"status\": {\"authenticated\": true, \"user\": {  \"username\": \"system:serviceaccounts:some-ns:kermit\",  \"groups\": [\"developers\", \"qa\"]}}}";
    public static final String UNAUTH_JSON = "{\"status\": {\"authenticated\": false }}";

    @Test
    public void testBasicLogin() throws LoginException {
        TokenCallbackHandler handler = new TokenCallbackHandler(TOKEN);
        Subject subject = new Subject();
        this.loginModule.initialize(subject, (CallbackHandler)handler, Collections.emptyMap(), this.getDefaultOptions());
        TokenReview tr = TokenReview.fromJsonString((String)AUTH_JSON);
        Mockito.when((Object)this.client.getTokenReview(TOKEN)).thenReturn((Object)tr);
        Assert.assertTrue((boolean)this.loginModule.login());
        Assert.assertTrue((boolean)this.loginModule.commit());
        MatcherAssert.assertThat(subject.getPrincipals(UserPrincipal.class), (Matcher)Matchers.hasSize((int)1));
        subject.getPrincipals(ServiceAccountPrincipal.class).forEach(p -> {
            MatcherAssert.assertThat((Object)p.getName(), (Matcher)Matchers.is((Object)USERNAME));
            MatcherAssert.assertThat((Object)p.getSaName(), (Matcher)Matchers.is((Object)"kermit"));
            MatcherAssert.assertThat((Object)p.getNamespace(), (Matcher)Matchers.is((Object)"some-ns"));
        });
        Set<RolePrincipal> roles = subject.getPrincipals(RolePrincipal.class);
        MatcherAssert.assertThat(roles, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(roles, (Matcher)Matchers.containsInAnyOrder((Object[])new RolePrincipal[]{new RolePrincipal("muppet"), new RolePrincipal("admin")}));
        Assert.assertTrue((boolean)this.loginModule.logout());
        Assert.assertFalse((boolean)this.loginModule.commit());
        MatcherAssert.assertThat(subject.getPrincipals(), (Matcher)Matchers.empty());
        ((KubernetesClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).getTokenReview(TOKEN);
    }

    @Test
    public void testFailedLogin() throws LoginException {
        TokenCallbackHandler handler = new TokenCallbackHandler(TOKEN);
        Subject subject = new Subject();
        this.loginModule.initialize(subject, (CallbackHandler)handler, Collections.emptyMap(), this.getDefaultOptions());
        TokenReview tr = TokenReview.fromJsonString((String)UNAUTH_JSON);
        Mockito.when((Object)this.client.getTokenReview(TOKEN)).thenReturn((Object)tr);
        Assert.assertFalse((boolean)this.loginModule.login());
        Assert.assertFalse((boolean)this.loginModule.commit());
        MatcherAssert.assertThat(subject.getPrincipals(), (Matcher)Matchers.empty());
        ((KubernetesClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).getTokenReview(TOKEN);
    }

    @Test
    public void testNullToken() throws LoginException {
        TokenCallbackHandler handler = new TokenCallbackHandler(null);
        Subject subject = new Subject();
        this.loginModule.initialize(subject, (CallbackHandler)handler, Collections.emptyMap(), this.getDefaultOptions());
        try {
            Assert.assertFalse((boolean)this.loginModule.login());
            Assert.fail((String)"Exception expected");
        }
        catch (LoginException e) {
            Assert.assertNotNull((Object)e);
        }
        Assert.assertFalse((boolean)this.loginModule.commit());
        MatcherAssert.assertThat(subject.getPrincipals(), (Matcher)Matchers.empty());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.client});
    }

    @Test
    public void testUnableToVerifyToken() throws LoginException {
        TokenCallbackHandler handler = new TokenCallbackHandler(TOKEN);
        Subject subject = new Subject();
        this.loginModule.initialize(subject, (CallbackHandler)handler, Collections.emptyMap(), this.getDefaultOptions());
        Mockito.when((Object)this.client.getTokenReview(TOKEN)).thenReturn((Object)new TokenReview());
        Assert.assertFalse((boolean)this.loginModule.login());
        Assert.assertFalse((boolean)this.loginModule.commit());
        MatcherAssert.assertThat(subject.getPrincipals(), (Matcher)Matchers.empty());
        ((KubernetesClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).getTokenReview(TOKEN);
    }

    @Test
    public void testRolesFromReview() throws LoginException {
        TokenCallbackHandler handler = new TokenCallbackHandler(TOKEN);
        Subject subject = new Subject();
        this.loginModule.initialize(subject, (CallbackHandler)handler, Collections.emptyMap(), Map.of());
        TokenReview tr = TokenReview.fromJsonString((String)AUTH_JSON_WITH_GROUPS);
        Mockito.when((Object)this.client.getTokenReview(TOKEN)).thenReturn((Object)tr);
        Assert.assertTrue((boolean)this.loginModule.login());
        Assert.assertTrue((boolean)this.loginModule.commit());
        MatcherAssert.assertThat(subject.getPrincipals(UserPrincipal.class), (Matcher)Matchers.hasSize((int)1));
        subject.getPrincipals(ServiceAccountPrincipal.class).forEach(p -> {
            MatcherAssert.assertThat((Object)p.getName(), (Matcher)Matchers.is((Object)USERNAME));
            MatcherAssert.assertThat((Object)p.getSaName(), (Matcher)Matchers.is((Object)"kermit"));
            MatcherAssert.assertThat((Object)p.getNamespace(), (Matcher)Matchers.is((Object)"some-ns"));
        });
        Set<RolePrincipal> roles = subject.getPrincipals(RolePrincipal.class);
        MatcherAssert.assertThat(roles, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(roles, (Matcher)Matchers.containsInAnyOrder((Object[])new RolePrincipal[]{new RolePrincipal("developers"), new RolePrincipal("qa")}));
        Assert.assertTrue((boolean)this.loginModule.logout());
        Assert.assertFalse((boolean)this.loginModule.commit());
        MatcherAssert.assertThat(subject.getPrincipals(), (Matcher)Matchers.empty());
        ((KubernetesClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).getTokenReview(TOKEN);
    }

    @Test
    public void testIgnoreRolesFromReview() throws LoginException {
        TokenCallbackHandler handler = new TokenCallbackHandler(TOKEN);
        Subject subject = new Subject();
        this.loginModule.initialize(subject, (CallbackHandler)handler, Collections.emptyMap(), Map.of("ignoreTokenReviewRoles", "true"));
        TokenReview tr = TokenReview.fromJsonString((String)AUTH_JSON_WITH_GROUPS);
        Mockito.when((Object)this.client.getTokenReview(TOKEN)).thenReturn((Object)tr);
        Assert.assertTrue((boolean)this.loginModule.login());
        Assert.assertTrue((boolean)this.loginModule.commit());
        MatcherAssert.assertThat(subject.getPrincipals(UserPrincipal.class), (Matcher)Matchers.hasSize((int)1));
        subject.getPrincipals(ServiceAccountPrincipal.class).forEach(p -> {
            MatcherAssert.assertThat((Object)p.getName(), (Matcher)Matchers.is((Object)USERNAME));
            MatcherAssert.assertThat((Object)p.getSaName(), (Matcher)Matchers.is((Object)"kermit"));
            MatcherAssert.assertThat((Object)p.getNamespace(), (Matcher)Matchers.is((Object)"some-ns"));
        });
        Set<RolePrincipal> roles = subject.getPrincipals(RolePrincipal.class);
        MatcherAssert.assertThat(roles, (Matcher)Matchers.hasSize((int)0));
        Assert.assertTrue((boolean)this.loginModule.logout());
        Assert.assertFalse((boolean)this.loginModule.commit());
        MatcherAssert.assertThat(subject.getPrincipals(), (Matcher)Matchers.empty());
        ((KubernetesClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).getTokenReview(TOKEN);
    }

    private Map<String, ?> getDefaultOptions() {
        String baseDirValue = new File(KubernetesLoginModuleTest.class.getClassLoader().getResource("k8s-roles.properties").getPath()).getParentFile().getAbsolutePath();
        return Map.of("org.apache.activemq.jaas.kubernetes.role", "k8s-roles.properties", "baseDir", baseDirValue);
    }
}

