/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.JaasCallbackHandler;
import org.apache.activemq.artemis.spi.core.security.jaas.LDAPLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.LDAPLoginProperty;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=1024)}, allowAnonymousAccess=true)
@ApplyLdifFiles(value={"test.ldif"})
public class LDAPLoginModuleTest
extends AbstractLdapTestUnit {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PRINCIPAL = "uid=admin,ou=system";
    private static final String CREDENTIALS = "secret";
    private final String loginConfigSysPropName = "java.security.auth.login.config";
    private String oldLoginConfig;

    @Before
    public void setLoginConfigSysProperty() {
        this.oldLoginConfig = System.getProperty("java.security.auth.login.config", null);
        System.setProperty("java.security.auth.login.config", "src/test/resources/login.config");
    }

    @After
    public void resetLoginConfigSysProperty() {
        if (this.oldLoginConfig != null) {
            System.setProperty("java.security.auth.login.config", this.oldLoginConfig);
        }
    }

    @Test
    public void testRunning() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ldap://localhost:1024");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", PRINCIPAL);
        env.put("java.naming.security.credentials", CREDENTIALS);
        InitialDirContext ctx = new InitialDirContext(env);
        HashSet<String> set = new HashSet<String>();
        NamingEnumeration<NameClassPair> list = ctx.list("ou=system");
        while (list.hasMore()) {
            NameClassPair ncp = list.next();
            set.add(ncp.getName());
        }
        Assert.assertTrue((boolean)set.contains("uid=admin"));
        Assert.assertTrue((boolean)set.contains("ou=users"));
        Assert.assertTrue((boolean)set.contains("ou=groups"));
        Assert.assertTrue((boolean)set.contains("ou=configuration"));
        Assert.assertTrue((boolean)set.contains("prefNodeName=sysPrefRoot"));
    }

    @Test
    public void testLogin() throws Exception {
        logger.info("num session: {}", (Object)ldapServer.getLdapSessionManager().getSessions().length);
        LoginContext context = new LoginContext("LDAPLogin", new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName("first");
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(LDAPLoginModuleTest.CREDENTIALS.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
            }
        });
        context.login();
        context.logout();
        Assert.assertTrue((String)"sessions still active after logout", (boolean)this.waitFor(() -> ldapServer.getLdapSessionManager().getSessions().length == 0));
    }

    @Test
    public void testLoginPooled() throws Exception {
        CallbackHandler callbackHandler = callbacks -> {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName("first");
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword(CREDENTIALS.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i]);
            }
        };
        LoginContext context = new LoginContext("LDAPLoginPooled", callbackHandler);
        context.login();
        context.logout();
        context.login();
        context.logout();
        context = new LoginContext("LDAPLoginPooled", callbackHandler);
        context.login();
        context.logout();
        ExecutorService pool = Executors.newCachedThreadPool();
        for (int i = 0; i < 20; ++i) {
            pool.execute(() -> {
                try {
                    LoginContext context1 = new LoginContext("LDAPLoginPooled", callbackHandler);
                    context1.login();
                    context1.logout();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        Assert.assertTrue((String)"not enough active sessions after logout", (boolean)this.waitFor(() -> ldapServer.getLdapSessionManager().getSessions().length >= 5));
        pool.shutdown();
        pool.awaitTermination(2L, TimeUnit.SECONDS);
    }

    private boolean waitFor(Condition condition) throws Exception {
        long expiry = System.currentTimeMillis() + 5000L;
        boolean conditionSatisified = condition.isSatisfied();
        while (!conditionSatisified && System.currentTimeMillis() < expiry) {
            TimeUnit.MILLISECONDS.sleep(100L);
            conditionSatisified = condition.isSatisfied();
        }
        return conditionSatisified;
    }

    @Test
    public void testUnauthenticated() throws Exception {
        LoginContext context = new LoginContext("UnAuthenticatedLDAPLogin", new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName("first");
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(LDAPLoginModuleTest.CREDENTIALS.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
            }
        });
        try {
            context.login();
        }
        catch (LoginException le) {
            Assert.assertEquals((Object)le.getCause().getMessage(), (Object)"Empty password is not allowed");
            return;
        }
        Assert.fail((String)"Should have failed authenticating");
        Assert.assertTrue((String)"sessions still active after logout", (boolean)this.waitFor(() -> ldapServer.getLdapSessionManager().getSessions().length == 0));
    }

    @Test
    public void testAuthenticatedViaBindOnAnonConnection() throws Exception {
        LoginContext context = new LoginContext("AnonBindCheckUserLDAPLogin", new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName("first");
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword("wrongSecret".toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
            }
        });
        try {
            context.login();
            Assert.fail((String)"Should have failed authenticating");
        }
        catch (FailedLoginException failedLoginException) {
            // empty catch block
        }
        Assert.assertTrue((String)"sessions still active after logout", (boolean)this.waitFor(() -> ldapServer.getLdapSessionManager().getSessions().length == 0));
    }

    @Test
    public void testAuthenticatedOkViaBindOnAnonConnection() throws Exception {
        LoginContext context = new LoginContext("AnonBindCheckUserLDAPLogin", new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName("first");
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(LDAPLoginModuleTest.CREDENTIALS.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
            }
        });
        context.login();
        context.logout();
        Assert.assertTrue((String)"sessions still active after logout", (boolean)this.waitFor(() -> ldapServer.getLdapSessionManager().getSessions().length == 0));
    }

    @Test
    public void testCommitOnFailedLogin() throws LoginException {
        LDAPLoginModule loginModule = new LDAPLoginModule();
        JaasCallbackHandler callbackHandler = new JaasCallbackHandler(null, null, null);
        loginModule.initialize(new Subject(), (CallbackHandler)callbackHandler, null, new HashMap());
        Assert.assertFalse((boolean)loginModule.login());
        Assert.assertFalse((boolean)loginModule.commit());
    }

    @Test
    public void testPropertyConfigMap() throws Exception {
        LDAPLoginModule loginModule = new LDAPLoginModule();
        JaasCallbackHandler callbackHandler = new JaasCallbackHandler(null, null, null);
        Field configMap = null;
        HashMap<String, String> options = new HashMap<String, String>();
        for (Field field : loginModule.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && field.getType().isAssignableFrom(String.class)) {
                field.setAccessible(true);
                options.put((String)field.get(loginModule), "SET");
            }
            if (!field.getName().equals("config")) continue;
            field.setAccessible(true);
            configMap = field;
        }
        loginModule.initialize(new Subject(), (CallbackHandler)callbackHandler, null, options);
        Set ldapProps = (Set)configMap.get(loginModule);
        for (String key : options.keySet()) {
            Assert.assertTrue((String)("val set: " + key), (boolean)this.presentIn(ldapProps, key));
        }
    }

    @Test
    public void testEmptyPassword() throws Exception {
        LoginContext context = new LoginContext("LDAPLogin", new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName("first");
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword("".toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
            }
        });
        try {
            context.login();
            Assert.fail((String)"Should have thrown a FailedLoginException");
        }
        catch (FailedLoginException fle) {
            Assert.assertEquals((Object)"Password cannot be null or empty", (Object)fle.getMessage());
        }
        context.logout();
    }

    @Test
    public void testNullPassword() throws Exception {
        LoginContext context = new LoginContext("LDAPLogin", new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName("first");
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(null);
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
            }
        });
        try {
            context.login();
            Assert.fail((String)"Should have thrown a FailedLoginException");
        }
        catch (FailedLoginException fle) {
            Assert.assertEquals((Object)"Password cannot be null or empty", (Object)fle.getMessage());
        }
        context.logout();
    }

    @Test
    public void testEnvironmentProperties() throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        for (LDAPLoginModule.ConfigKey configKey : LDAPLoginModule.ConfigKey.values()) {
            if (configKey.getName().equals("initialContextFactory")) {
                options.put(configKey.getName(), "com.sun.jndi.ldap.LdapCtxFactory");
                continue;
            }
            if (configKey.getName().equals("connectionURL")) {
                options.put(configKey.getName(), "ldap://localhost:1024");
                continue;
            }
            if (configKey.getName().equals("referral")) {
                options.put(configKey.getName(), "ignore");
                continue;
            }
            if (configKey.getName().equals("connectionTimeout")) {
                options.put(configKey.getName(), "10000");
                continue;
            }
            if (configKey.getName().equals("readTimeout")) {
                options.put(configKey.getName(), "11000");
                continue;
            }
            if (configKey.getName().equals("authentication")) {
                options.put(configKey.getName(), "simple");
                continue;
            }
            if (configKey.getName().equals("connectionUsername")) {
                options.put(configKey.getName(), PRINCIPAL);
                continue;
            }
            if (configKey.getName().equals("connectionPassword")) {
                options.put(configKey.getName(), CREDENTIALS);
                continue;
            }
            if (configKey.getName().equals("connectionProtocol")) {
                options.put(configKey.getName(), "s");
                continue;
            }
            if (configKey.getName().equals("debug")) {
                options.put(configKey.getName(), "true");
                continue;
            }
            options.put(configKey.getName(), configKey.getName() + "_value_set");
        }
        options.put("com.sun.jndi.ldap.tls.cbtype", "tls-server-end-point");
        options.put("randomConfig", "some-value");
        options.put("non.string.1", new Object());
        options.put("non.string.2", 1);
        LDAPLoginModule loginModule = new LDAPLoginModule();
        loginModule.initialize(new Subject(), null, null, options);
        loginModule.openContext();
        Hashtable<?, ?> environment = loginModule.context.getEnvironment();
        loginModule.closeContext();
        for (LDAPLoginModule.ConfigKey configKey : LDAPLoginModule.ConfigKey.values()) {
            Assert.assertEquals((String)("value should not be set for key: " + configKey.getName()), null, environment.get(configKey.getName()));
        }
        Assert.assertEquals((String)"value should be set for key: com.sun.jndi.ldap.tls.cbtype", (Object)"tls-server-end-point", environment.get("com.sun.jndi.ldap.tls.cbtype"));
        Assert.assertEquals((String)"value should be set for key: randomConfig", (Object)"some-value", environment.get("randomConfig"));
        Assert.assertEquals((String)"value should not be set for key: non.string.1", null, environment.get("non.string.1"));
        Assert.assertEquals((String)"value should not be set for key: non.string.2", null, environment.get("non.string.2"));
        Assert.assertEquals((String)"value should be set for key: java.naming.factory.initial", (Object)"com.sun.jndi.ldap.LdapCtxFactory", environment.get("java.naming.factory.initial"));
        Assert.assertEquals((String)"value should be set for key: java.naming.provider.url", (Object)"ldap://localhost:1024", environment.get("java.naming.provider.url"));
        Assert.assertEquals((String)"value should be set for key: java.naming.referral", (Object)"ignore", environment.get("java.naming.referral"));
        Assert.assertEquals((String)"value should be set for key: com.sun.jndi.ldap.connect.timeout", (Object)"10000", environment.get("com.sun.jndi.ldap.connect.timeout"));
        Assert.assertEquals((String)"value should be set for key: com.sun.jndi.ldap.read.timeout", (Object)"11000", environment.get("com.sun.jndi.ldap.read.timeout"));
        Assert.assertEquals((String)"value should be set for key: java.naming.security.authentication", (Object)"simple", environment.get("java.naming.security.authentication"));
        Assert.assertEquals((String)"value should be set for key: java.naming.security.principal", (Object)PRINCIPAL, environment.get("java.naming.security.principal"));
        Assert.assertEquals((String)"value should be set for key: java.naming.security.credentials", (Object)CREDENTIALS, environment.get("java.naming.security.credentials"));
        Assert.assertEquals((String)"value should be set for key: java.naming.security.protocol", (Object)"s", environment.get("java.naming.security.protocol"));
    }

    private boolean presentIn(Set<LDAPLoginProperty> ldapProps, String propertyName) {
        for (LDAPLoginProperty conf : ldapProps) {
            if (!conf.getPropertyName().equals(propertyName) || conf.getPropertyValue() == null || "".equals(conf.getPropertyValue())) continue;
            return true;
        }
        return false;
    }

    public static interface Condition {
        public boolean isSatisfied() throws Exception;
    }
}

